/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.ext.EUC_TW;

public abstract class X11CNS11643
extends Charset {
    private final int plane;

    public X11CNS11643(int n, String string) {
        super(string, null);
        switch (n) {
            case 1: {
                this.plane = 0;
                break;
            }
            case 2: 
            case 3: {
                this.plane = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("Only planes 1, 2, and 3 supported");
            }
        }
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this, this.plane);
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this, this.plane);
    }

    @Override
    public boolean contains(Charset charset) {
        return charset instanceof X11CNS11643;
    }

    private class Decoder
    extends EUC_TW.Decoder {
        int plane;
        private String table;

        protected Decoder(Charset charset, int n) {
            super(charset);
            if (n == 0) {
                this.plane = n;
            } else if (n == 2 || n == 3) {
                this.plane = n - 1;
            } else {
                throw new IllegalArgumentException("Only planes 1, 2, and 3 supported");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n;
            byte[] byArray = byteBuffer.array();
            int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
            char[] cArray = charBuffer.array();
            int n3 = charBuffer.arrayOffset() + charBuffer.position();
            int n4 = charBuffer.arrayOffset() + charBuffer.limit();
            try {
                for (n = byteBuffer.arrayOffset() + byteBuffer.position(); n < n2; n += 2) {
                    if (n2 - n < 2) {
                        CoderResult coderResult = CoderResult.UNDERFLOW;
                        return coderResult;
                    }
                    int n5 = byArray[n] & 0xFF | 0x80;
                    int n6 = byArray[n + 1] & 0xFF | 0x80;
                    char[] cArray2 = this.toUnicode(n5, n6, this.plane);
                    if (cArray2 == null || cArray2.length == 2) {
                        CoderResult coderResult = CoderResult.unmappableForLength(2);
                        return coderResult;
                    }
                    if (n4 - n3 < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    cArray[n3++] = cArray2[0];
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n - byteBuffer.arrayOffset());
                charBuffer.position(n3 - charBuffer.arrayOffset());
            }
        }
    }

    private class Encoder
    extends EUC_TW.Encoder {
        private int plane;
        private byte[] bb;

        public Encoder(Charset charset, int n) {
            super(charset);
            this.bb = new byte[4];
            this.plane = n;
        }

        @Override
        public boolean canEncode(char c) {
            if (c <= '\u007f') {
                return false;
            }
            int n = this.toEUC(c, this.bb);
            if (n == -1) {
                return false;
            }
            int n2 = 0;
            if (n == 4) {
                n2 = (this.bb[1] & 0xFF) - 160;
            }
            return n2 == this.plane;
        }

        @Override
        public boolean isLegalReplacement(byte[] byArray) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n;
            char[] cArray = charBuffer.array();
            int n2 = charBuffer.arrayOffset() + charBuffer.limit();
            byte[] byArray = byteBuffer.array();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
            try {
                for (n = charBuffer.arrayOffset() + charBuffer.position(); n < n2; ++n) {
                    int n5;
                    char c = cArray[n];
                    if (c > '\u007f' && c < '\ufffe' && (n5 = this.toEUC(c, this.bb)) != -1) {
                        int n6 = 0;
                        if (n5 == 4) {
                            n6 = (this.bb[1] & 0xFF) - 160;
                        }
                        if (n6 == this.plane) {
                            if (n4 - n3 < 2) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            if (n5 == 2) {
                                byArray[n3++] = (byte)(this.bb[0] & 0x7F);
                                byArray[n3++] = (byte)(this.bb[1] & 0x7F);
                                continue;
                            }
                            byArray[n3++] = (byte)(this.bb[2] & 0x7F);
                            byArray[n3++] = (byte)(this.bb[3] & 0x7F);
                            continue;
                        }
                    }
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n - charBuffer.arrayOffset());
                byteBuffer.position(n3 - byteBuffer.arrayOffset());
            }
        }
    }
}

