/*
 * Decompiled with CFR 0.152.
 */
package sun.dyn;

import java.dyn.MethodType;
import sun.dyn.Access;
import sun.dyn.FilterGeneric;
import sun.dyn.FromGeneric;
import sun.dyn.Invokers;
import sun.dyn.MethodHandleImpl;
import sun.dyn.ToGeneric;
import sun.dyn.util.Wrapper;

public class MethodTypeImpl {
    final int[] argToSlotTable;
    final int[] slotToArgTable;
    final long argCounts;
    final long primCounts;
    final int vmslots;
    final MethodType erasedType;
    MethodType primsAsBoxes;
    MethodType primArgsAsBoxes;
    MethodType primsAsInts;
    MethodType primsAsLongs;
    MethodType primsAtEnd;
    ToGeneric toGeneric;
    FromGeneric fromGeneric;
    FilterGeneric filterGeneric;
    private static MethodTypeFriend METHOD_TYPE_FRIEND;
    public static final int NO_CHANGE = 0;
    public static final int ERASE = 1;
    public static final int WRAP = 2;
    public static final int UNWRAP = 3;
    public static final int INTS = 4;
    public static final int LONGS = 5;
    public static final int RAW_RETURN = 6;

    public MethodType erasedType() {
        return this.erasedType;
    }

    public static MethodTypeImpl of(MethodType methodType) {
        return METHOD_TYPE_FRIEND.form(methodType);
    }

    public static void setMethodTypeFriend(Access access, MethodTypeFriend methodTypeFriend) {
        Access.check(access);
        if (METHOD_TYPE_FRIEND != null) {
            throw new InternalError();
        }
        METHOD_TYPE_FRIEND = methodTypeFriend;
    }

    protected MethodTypeImpl(MethodType methodType) {
        int n;
        int n2;
        this.erasedType = methodType;
        Class<?>[] classArray = METHOD_TYPE_FRIEND.ptypes(methodType);
        int n3 = n2 = classArray.length;
        int n4 = 1;
        int n5 = 1;
        int[] nArray = null;
        int[] nArray2 = null;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        Class<?>[] classArray2 = classArray;
        for (int i = 0; i < classArray2.length; ++i) {
            Class<?> clazz = classArray2[i];
            if (clazz == Object.class) continue;
            assert (clazz.isPrimitive());
            ++n6;
            if (!MethodTypeImpl.hasTwoArgSlots(clazz)) continue;
            ++n7;
        }
        n3 += n7;
        Class<?> clazz = methodType.returnType();
        if (clazz != Object.class) {
            ++n8;
            if (MethodTypeImpl.hasTwoArgSlots(clazz)) {
                ++n9;
            }
            if (clazz == Void.TYPE) {
                n5 = 0;
                n4 = 0;
            } else {
                n5 += n9;
            }
        }
        if (n7 != 0) {
            int n10 = n2 + n7;
            nArray2 = new int[n10 + 1];
            nArray = new int[1 + n2];
            nArray[0] = n10;
            for (n = 0; n < classArray2.length; ++n) {
                Class<?> clazz2 = classArray2[n];
                if (MethodTypeImpl.hasTwoArgSlots(clazz2)) {
                    --n10;
                }
                nArray2[--n10] = n + 1;
                nArray[1 + n] = n10;
            }
            assert (n10 == 0);
        }
        this.primCounts = MethodTypeImpl.pack(n9, n8, n7, n6);
        this.argCounts = MethodTypeImpl.pack(n5, n4, n3, n2);
        if (nArray2 == null) {
            int n11 = n2;
            nArray2 = new int[n11 + 1];
            nArray = new int[1 + n2];
            nArray[0] = n11;
            for (n = 0; n < n2; ++n) {
                nArray2[--n11] = n + 1;
                nArray[1 + n] = n11;
            }
        }
        this.argToSlotTable = nArray;
        this.slotToArgTable = nArray2;
        if (n3 >= 256) {
            throw new IllegalArgumentException("too many arguments");
        }
        this.vmslots = this.parameterSlotCount();
        if (!this.hasPrimitives()) {
            this.primsAsBoxes = methodType;
            this.primArgsAsBoxes = methodType;
            this.primsAsInts = methodType;
            this.primsAsLongs = methodType;
            this.primsAtEnd = methodType;
        }
    }

    public MethodType primsAsBoxes() {
        MethodType methodType = this.primsAsBoxes;
        if (methodType != null) {
            return methodType;
        }
        MethodType methodType2 = this.erasedType;
        methodType = MethodTypeImpl.canonicalize(this.erasedType, 2, 2);
        if (methodType == null) {
            methodType = methodType2;
        }
        this.primsAsBoxes = methodType;
        return this.primsAsBoxes;
    }

    public MethodType primArgsAsBoxes() {
        MethodType methodType = this.primArgsAsBoxes;
        if (methodType != null) {
            return methodType;
        }
        MethodType methodType2 = this.erasedType;
        methodType = MethodTypeImpl.canonicalize(this.erasedType, 6, 2);
        if (methodType == null) {
            methodType = methodType2;
        }
        this.primArgsAsBoxes = methodType;
        return this.primArgsAsBoxes;
    }

    public MethodType primsAsInts() {
        MethodType methodType = this.primsAsInts;
        if (methodType != null) {
            return methodType;
        }
        MethodType methodType2 = this.erasedType;
        methodType = MethodTypeImpl.canonicalize(methodType2, 6, 4);
        if (methodType == null) {
            methodType = methodType2;
        }
        this.primsAsInts = methodType;
        return this.primsAsInts;
    }

    public MethodType primsAsLongs() {
        MethodType methodType = this.primsAsLongs;
        if (methodType != null) {
            return methodType;
        }
        MethodType methodType2 = this.erasedType;
        methodType = MethodTypeImpl.canonicalize(methodType2, 6, 5);
        if (methodType == null) {
            methodType = methodType2;
        }
        this.primsAsLongs = methodType;
        return this.primsAsLongs;
    }

    public MethodType primsAtEnd() {
        MethodType methodType = this.primsAtEnd;
        if (methodType != null) {
            return methodType;
        }
        MethodType methodType2 = this.erasedType;
        int n = this.primitiveParameterCount();
        if (n == 0) {
            this.primsAtEnd = methodType2;
            return this.primsAtEnd;
        }
        int n2 = this.parameterCount();
        int n3 = this.longPrimitiveParameterCount();
        if (n == n2 && (n3 == 0 || n3 == n2)) {
            this.primsAtEnd = methodType2;
            return this.primsAtEnd;
        }
        this.primsAtEnd = MethodTypeImpl.reorderParameters(methodType2, MethodTypeImpl.primsAtEndOrder(methodType2), null);
        return this.primsAtEnd;
    }

    public static int[] primsAtEndOrder(MethodType methodType) {
        MethodTypeImpl methodTypeImpl = METHOD_TYPE_FRIEND.form(methodType);
        if (methodTypeImpl.primsAtEnd == methodTypeImpl.erasedType) {
            return null;
        }
        int n = methodTypeImpl.parameterCount();
        int[] nArray = new int[n];
        int n2 = methodTypeImpl.primitiveParameterCount();
        int n3 = methodTypeImpl.longPrimitiveParameterCount();
        int n4 = 0;
        int n5 = n - n2;
        int n6 = n - n3;
        Class<?>[] classArray = METHOD_TYPE_FRIEND.ptypes(methodType);
        boolean bl = false;
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz = classArray[i];
            int n7 = !clazz.isPrimitive() ? n4++ : (!MethodTypeImpl.hasTwoArgSlots(clazz) ? n5++ : n6++);
            if (n7 != i) {
                bl = true;
            }
            nArray[i] = n7;
        }
        assert (n4 == n - n2 && n5 == n - n3 && n6 == n);
        if (!bl) {
            methodTypeImpl.primsAtEnd = methodTypeImpl.erasedType;
            return null;
        }
        return nArray;
    }

    public static MethodType reorderParameters(MethodType methodType, int[] nArray, Class<?>[] classArray) {
        if (nArray == null) {
            return methodType;
        }
        Class<?>[] classArray2 = METHOD_TYPE_FRIEND.ptypes(methodType);
        Class[] classArray3 = new Class[nArray.length];
        int n = classArray2.length + (classArray == null ? 0 : classArray.length);
        boolean bl = classArray3.length != classArray2.length;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (n2 != i) {
                bl = true;
            }
            Class<?> clazz = n2 < classArray2.length ? classArray2[n2] : (n2 == n ? methodType.returnType() : classArray[n2 - classArray2.length]);
            classArray3[i] = clazz;
        }
        if (!bl) {
            return methodType;
        }
        return METHOD_TYPE_FRIEND.makeImpl(methodType.returnType(), classArray3, true);
    }

    private static boolean hasTwoArgSlots(Class<?> clazz) {
        return clazz == Long.TYPE || clazz == Double.TYPE;
    }

    private static long pack(int n, int n2, int n3, int n4) {
        assert (((n | n2 | n3 | n4) & 0xFFFF0000) == 0);
        long l = n << 16 | n2;
        long l2 = n3 << 16 | n4;
        return l << 32 | l2;
    }

    private static char unpack(long l, int n) {
        assert (n <= 3);
        return (char)(l >> (3 - n) * 16);
    }

    public int parameterCount() {
        return MethodTypeImpl.unpack(this.argCounts, 3);
    }

    public int parameterSlotCount() {
        return MethodTypeImpl.unpack(this.argCounts, 2);
    }

    public int returnCount() {
        return MethodTypeImpl.unpack(this.argCounts, 1);
    }

    public int returnSlotCount() {
        return MethodTypeImpl.unpack(this.argCounts, 0);
    }

    public int primitiveParameterCount() {
        return MethodTypeImpl.unpack(this.primCounts, 3);
    }

    public int longPrimitiveParameterCount() {
        return MethodTypeImpl.unpack(this.primCounts, 2);
    }

    public int primitiveReturnCount() {
        return MethodTypeImpl.unpack(this.primCounts, 1);
    }

    public int longPrimitiveReturnCount() {
        return MethodTypeImpl.unpack(this.primCounts, 0);
    }

    public boolean hasPrimitives() {
        return this.primCounts != 0L;
    }

    public boolean hasLongPrimitives() {
        return (this.longPrimitiveParameterCount() | this.longPrimitiveReturnCount()) != 0;
    }

    public int parameterToArgSlot(int n) {
        return this.argToSlotTable[1 + n];
    }

    public int argSlotToParameter(int n) {
        return this.slotToArgTable[n] - 1;
    }

    public static void initForm(Access access, MethodType methodType) {
        Access.check(access);
        MethodTypeImpl methodTypeImpl = MethodTypeImpl.findForm(methodType);
        METHOD_TYPE_FRIEND.setForm(methodType, methodTypeImpl);
        if (methodTypeImpl.erasedType == methodType) {
            MethodHandleImpl.init(access, methodType);
        }
    }

    static MethodTypeImpl findForm(MethodType methodType) {
        MethodType methodType2 = MethodTypeImpl.canonicalize(methodType, 1, 1);
        if (methodType2 == null) {
            return METHOD_TYPE_FRIEND.newMethodTypeForm(methodType);
        }
        return METHOD_TYPE_FRIEND.form(methodType2);
    }

    public static MethodType canonicalize(MethodType methodType, int n, int n2) {
        Class<?>[] classArray = METHOD_TYPE_FRIEND.ptypes(methodType);
        Class<?>[] classArray2 = MethodTypeImpl.canonicalizes(classArray, n2);
        Class<?> clazz = methodType.returnType();
        Class<?> clazz2 = MethodTypeImpl.canonicalize(clazz, n);
        if (classArray2 == null && clazz2 == null) {
            return null;
        }
        if (clazz2 == null) {
            clazz2 = clazz;
        }
        if (classArray2 == null) {
            classArray2 = classArray;
        }
        return METHOD_TYPE_FRIEND.makeImpl(clazz2, classArray2, true);
    }

    static Class<?> canonicalize(Class<?> clazz, int n) {
        if (clazz != Object.class) {
            if (!clazz.isPrimitive()) {
                switch (n) {
                    case 3: {
                        Class<?> clazz2 = Wrapper.asPrimitiveType(clazz);
                        if (clazz2 == clazz) break;
                        return clazz2;
                    }
                    case 1: 
                    case 6: {
                        return Object.class;
                    }
                }
            } else if (clazz == Void.TYPE) {
                switch (n) {
                    case 6: {
                        return Integer.TYPE;
                    }
                    case 2: {
                        return Void.class;
                    }
                }
            } else {
                switch (n) {
                    case 2: {
                        return Wrapper.asWrapperType(clazz);
                    }
                    case 4: {
                        if (clazz == Integer.TYPE || clazz == Long.TYPE) {
                            return null;
                        }
                        if (clazz == Double.TYPE) {
                            return Long.TYPE;
                        }
                        return Integer.TYPE;
                    }
                    case 5: {
                        if (clazz == Long.TYPE) {
                            return null;
                        }
                        return Long.TYPE;
                    }
                    case 6: {
                        if (clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE) {
                            return null;
                        }
                        return Integer.TYPE;
                    }
                }
            }
        }
        return null;
    }

    static Class<?>[] canonicalizes(Class<?>[] classArray, int n) {
        Class[] classArray2 = null;
        int n2 = classArray.length;
        for (int i = 0; i < n2; ++i) {
            Class<?> clazz = MethodTypeImpl.canonicalize(classArray[i], n);
            if (clazz == null) continue;
            if (classArray2 == null) {
                classArray2 = (Class[])classArray.clone();
            }
            classArray2[i] = clazz;
        }
        return classArray2;
    }

    public static Invokers invokers(Access access, MethodType methodType) {
        Access.check(access);
        Invokers invokers = METHOD_TYPE_FRIEND.getInvokers(methodType);
        if (invokers != null) {
            return invokers;
        }
        invokers = new Invokers(access, methodType);
        METHOD_TYPE_FRIEND.setInvokers(methodType, invokers);
        return invokers;
    }

    public String toString() {
        return "Form" + this.erasedType;
    }

    public static interface MethodTypeFriend {
        public Class<?>[] ptypes(MethodType var1);

        public MethodTypeImpl form(MethodType var1);

        public void setForm(MethodType var1, MethodTypeImpl var2);

        public MethodType makeImpl(Class<?> var1, Class<?>[] var2, boolean var3);

        public MethodTypeImpl newMethodTypeForm(MethodType var1);

        public Invokers getInvokers(MethodType var1);

        public void setInvokers(MethodType var1, Invokers var2);
    }
}

