/*
 * Decompiled with CFR 0.152.
 */
package sun.dyn.util;

public final class Wrapper
extends Enum<Wrapper> {
    public static final /* enum */ Wrapper INT = new Wrapper(Integer.class, Integer.TYPE, 'I', 0, Format.signed(32));
    public static final /* enum */ Wrapper LONG = new Wrapper(Long.class, Long.TYPE, 'J', 0L, Format.signed(64));
    public static final /* enum */ Wrapper BYTE = new Wrapper(Byte.class, Byte.TYPE, 'B', (byte)0, Format.signed(8));
    public static final /* enum */ Wrapper SHORT = new Wrapper(Short.class, Short.TYPE, 'S', (short)0, Format.signed(16));
    public static final /* enum */ Wrapper CHAR = new Wrapper(Character.class, Character.TYPE, 'C', Character.valueOf('\u0000'), Format.unsigned(16));
    public static final /* enum */ Wrapper BOOLEAN = new Wrapper(Boolean.class, Boolean.TYPE, 'Z', false, Format.unsigned(1));
    public static final /* enum */ Wrapper FLOAT = new Wrapper(Float.class, Float.TYPE, 'F', Float.valueOf(0.0f), Format.floating(32));
    public static final /* enum */ Wrapper DOUBLE = new Wrapper(Double.class, Double.TYPE, 'D', 0.0, Format.floating(64));
    public static final /* enum */ Wrapper VOID = new Wrapper(Void.class, Void.TYPE, 'V', null, Format.other(0));
    public static final /* enum */ Wrapper OBJECT = new Wrapper(Object.class, Object.class, 'L', null, Format.other(1));
    private final Class<?> wrapperType;
    private final Class<?> primitiveType;
    private final char basicTypeChar;
    private final Object zero;
    private final int format;
    private final String simpleName;
    private static final Wrapper[] FROM_PRIM;
    private static final Wrapper[] FROM_WRAP;
    private static final Wrapper[] FROM_CHAR;
    private static final /* synthetic */ Wrapper[] $VALUES;

    public static Wrapper[] values() {
        return (Wrapper[])$VALUES.clone();
    }

    public static Wrapper valueOf(String string) {
        return Enum.valueOf(Wrapper.class, string);
    }

    private Wrapper(Class<?> clazz, Class<?> clazz2, char c, Object object, int n2) {
        this.wrapperType = clazz;
        this.primitiveType = clazz2;
        this.basicTypeChar = c;
        this.zero = object;
        this.format = n2;
        this.simpleName = clazz.getSimpleName();
    }

    public int bitWidth() {
        return this.format >> 2 & 0x3FF;
    }

    public int stackSlots() {
        return this.format >> 0 & 3;
    }

    public boolean isSingleWord() {
        return (this.format & 1) != 0;
    }

    public boolean isDoubleWord() {
        return (this.format & 2) != 0;
    }

    public boolean isNumeric() {
        return (this.format & Format.NUM_MASK) != 0;
    }

    public boolean isIntegral() {
        return this.isNumeric() && this.format < Format.FLOAT;
    }

    public boolean isSubwordOrInt() {
        return this.isIntegral() && this.isSingleWord();
    }

    public boolean isSigned() {
        return this.format < Format.VOID;
    }

    public boolean isUnsigned() {
        return this.format >= Format.BOOLEAN && this.format < Format.FLOAT;
    }

    public boolean isFloating() {
        return this.format >= Format.FLOAT;
    }

    public Object zero() {
        return this.zero;
    }

    public <T> T zero(Class<T> clazz) {
        return this.cast(this.zero, clazz);
    }

    public static Wrapper forPrimitiveType(Class<?> clazz) {
        Wrapper wrapper = FROM_PRIM[Wrapper.hashPrim(clazz)];
        if (wrapper != null && wrapper.primitiveType == clazz) {
            return wrapper;
        }
        if (clazz.isPrimitive()) {
            throw new InternalError();
        }
        throw Wrapper.newIllegalArgumentException("not primitive: " + clazz);
    }

    public static Wrapper forWrapperType(Class<?> clazz) {
        Wrapper wrapper = Wrapper.findWrapperType(clazz);
        if (wrapper != null) {
            return wrapper;
        }
        for (Wrapper wrapper2 : Wrapper.values()) {
            if (wrapper.wrapperType != clazz) continue;
            throw new InternalError();
        }
        throw Wrapper.newIllegalArgumentException("not wrapper: " + clazz);
    }

    static Wrapper findWrapperType(Class<?> clazz) {
        Wrapper wrapper = FROM_WRAP[Wrapper.hashWrap(clazz)];
        if (wrapper != null && wrapper.wrapperType == clazz) {
            return wrapper;
        }
        if (clazz.isInterface()) {
            return OBJECT;
        }
        return null;
    }

    public static Wrapper forBasicType(char c) {
        Wrapper wrapper = FROM_CHAR[Wrapper.hashChar(c)];
        if (wrapper != null && wrapper.basicTypeChar == c) {
            return wrapper;
        }
        for (Wrapper wrapper2 : Wrapper.values()) {
            if (wrapper.basicTypeChar != c) continue;
            throw new InternalError();
        }
        throw Wrapper.newIllegalArgumentException("not basic type char: " + c);
    }

    public static Wrapper forBasicType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return Wrapper.forPrimitiveType(clazz);
        }
        return OBJECT;
    }

    private static int hashPrim(Class<?> clazz) {
        String string = clazz.getName();
        if (string.length() < 3) {
            return 0;
        }
        return (string.charAt(0) + string.charAt(2)) % 16;
    }

    private static int hashWrap(Class<?> clazz) {
        String string = clazz.getName();
        assert (10 == "java.lang.".length());
        if (string.length() < 13) {
            return 0;
        }
        return (3 * string.charAt(11) + string.charAt(12)) % 16;
    }

    private static int hashChar(char c) {
        return (c + (c >> 1)) % 16;
    }

    public Class<?> primitiveType() {
        return this.primitiveType;
    }

    public Class<?> wrapperType() {
        return this.wrapperType;
    }

    public <T> Class<T> wrapperType(Class<T> clazz) {
        if (clazz == this.wrapperType) {
            return clazz;
        }
        if (clazz == this.primitiveType || this.wrapperType == Object.class || clazz.isInterface()) {
            return Wrapper.forceType(this.wrapperType, clazz);
        }
        throw new ClassCastException(clazz + " not <:" + this.wrapperType);
    }

    public static <T> Class<T> asWrapperType(Class<T> clazz) {
        if (clazz.isPrimitive()) {
            return Wrapper.forPrimitiveType(clazz).wrapperType(clazz);
        }
        return clazz;
    }

    public static <T> Class<T> asPrimitiveType(Class<T> clazz) {
        Wrapper wrapper = Wrapper.findWrapperType(clazz);
        if (wrapper != null) {
            return Wrapper.forceType(wrapper.primitiveType(), clazz);
        }
        return clazz;
    }

    public static boolean isWrapperType(Class<?> clazz) {
        return Wrapper.findWrapperType(clazz) != null;
    }

    public static boolean isPrimitiveType(Class<?> clazz) {
        return clazz.isPrimitive();
    }

    public char basicTypeChar() {
        return this.basicTypeChar;
    }

    public String simpleName() {
        return this.simpleName;
    }

    public <T> T cast(Object object, Class<T> clazz) {
        Class<T> clazz2 = this.wrapperType(clazz);
        if (clazz2.isInstance(object)) {
            return clazz2.cast(object);
        }
        return clazz2.cast(this.wrap(object));
    }

    static <T> Class<T> forceType(Class<?> clazz, Class<T> clazz2) {
        assert (clazz == clazz2 || clazz == Wrapper.asWrapperType(clazz2) || clazz == Object.class && clazz2.isInterface());
        Class<?> clazz3 = clazz;
        return clazz3;
    }

    public Object wrap(Object object) {
        switch (this.basicTypeChar) {
            case 'L': {
                return object;
            }
            case 'V': {
                return null;
            }
        }
        Number number = Wrapper.numberValue(object);
        switch (this.basicTypeChar) {
            case 'I': {
                return number.intValue();
            }
            case 'J': {
                return number.longValue();
            }
            case 'F': {
                return Float.valueOf(number.floatValue());
            }
            case 'D': {
                return number.doubleValue();
            }
            case 'S': {
                return (short)number.intValue();
            }
            case 'B': {
                return (byte)number.intValue();
            }
            case 'C': {
                return Character.valueOf((char)number.intValue());
            }
            case 'Z': {
                return Wrapper.boolValue(number.longValue());
            }
        }
        throw new InternalError("bad wrapper");
    }

    public Object wrap(int n) {
        if (this.basicTypeChar == 'L') {
            return n;
        }
        switch (this.basicTypeChar) {
            case 'L': {
                throw Wrapper.newIllegalArgumentException("cannot wrap to object type");
            }
            case 'V': {
                return null;
            }
            case 'I': {
                return n;
            }
            case 'J': {
                return (long)n;
            }
            case 'F': {
                return Float.valueOf(n);
            }
            case 'D': {
                return (double)n;
            }
            case 'S': {
                return (short)n;
            }
            case 'B': {
                return (byte)n;
            }
            case 'C': {
                return Character.valueOf((char)n);
            }
            case 'Z': {
                return Wrapper.boolValue(n);
            }
        }
        throw new InternalError("bad wrapper");
    }

    public Object wrapRaw(long l) {
        switch (this.basicTypeChar) {
            case 'F': {
                return Float.valueOf(Float.intBitsToFloat((int)l));
            }
            case 'D': {
                return Double.longBitsToDouble(l);
            }
            case 'J': 
            case 'L': {
                return l;
            }
        }
        return this.wrap((int)l);
    }

    public long unwrapRaw(Object object) {
        switch (this.basicTypeChar) {
            case 'F': {
                return Float.floatToRawIntBits(((Float)object).floatValue());
            }
            case 'D': {
                return Double.doubleToRawLongBits((Double)object);
            }
            case 'L': {
                throw Wrapper.newIllegalArgumentException("cannot unwrap from sobject type");
            }
            case 'V': {
                return 0L;
            }
            case 'I': {
                return ((Integer)object).intValue();
            }
            case 'J': {
                return (Long)object;
            }
            case 'S': {
                return ((Short)object).shortValue();
            }
            case 'B': {
                return ((Byte)object).byteValue();
            }
            case 'C': {
                return ((Character)object).charValue();
            }
            case 'Z': {
                return (Boolean)object != false ? 1L : 0L;
            }
        }
        throw new InternalError("bad wrapper");
    }

    public Class<?> rawPrimitiveType() {
        return this.rawPrimitive().primitiveType();
    }

    public Wrapper rawPrimitive() {
        switch (this.basicTypeChar) {
            case 'B': 
            case 'C': 
            case 'F': 
            case 'S': 
            case 'V': 
            case 'Z': {
                return INT;
            }
            case 'D': {
                return LONG;
            }
        }
        return this;
    }

    private static Number numberValue(Object object) {
        if (object instanceof Number) {
            return (Number)object;
        }
        if (object instanceof Character) {
            return (int)((Character)object).charValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        return (Number)object;
    }

    private static boolean boolValue(long l) {
        return l != 0L;
    }

    private static RuntimeException newIllegalArgumentException(String string, Object object) {
        return Wrapper.newIllegalArgumentException(string + object);
    }

    private static RuntimeException newIllegalArgumentException(String string) {
        return new IllegalArgumentException(string);
    }

    static {
        $VALUES = new Wrapper[]{INT, LONG, BYTE, SHORT, CHAR, BOOLEAN, FLOAT, DOUBLE, VOID, OBJECT};
        FROM_PRIM = new Wrapper[16];
        FROM_WRAP = new Wrapper[16];
        FROM_CHAR = new Wrapper[16];
        for (Wrapper wrapper : Wrapper.values()) {
            int n = Wrapper.hashPrim(wrapper.primitiveType);
            int n2 = Wrapper.hashWrap(wrapper.wrapperType);
            int n3 = Wrapper.hashChar(wrapper.basicTypeChar);
            assert (FROM_PRIM[n] == null);
            assert (FROM_WRAP[n2] == null);
            assert (FROM_CHAR[n3] == null);
            Wrapper.FROM_PRIM[n] = wrapper;
            Wrapper.FROM_WRAP[n2] = wrapper;
            Wrapper.FROM_CHAR[n3] = wrapper;
        }
    }

    private static abstract class Format {
        static final int SLOT_SHIFT = 0;
        static final int SIZE_SHIFT = 2;
        static final int KIND_SHIFT = 12;
        static final int SIGNED = -4096;
        static final int UNSIGNED = 0;
        static final int FLOATING = 4096;
        static final int SLOT_MASK = 3;
        static final int SIZE_MASK = 1023;
        static int INT = -3967;
        static int BOOLEAN = 5;
        static int FLOAT = 4225;
        static int VOID = 0;
        static int NUM_MASK = -4;

        private Format() {
        }

        static int format(int n, int n2, int n3) {
            assert (n >> 12 << 12 == n);
            assert ((n2 & n2 - 1) == 0);
            assert (n == -4096 ? n2 > 0 : (n == 0 ? n2 > 0 : n == 4096 && (n2 == 32 || n2 == 64)));
            assert (n3 == 2 ? n2 == 64 : n3 == 1 && n2 <= 32);
            return n | n2 << 2 | n3 << 0;
        }

        static int signed(int n) {
            return Format.format(-4096, n, n > 32 ? 2 : 1);
        }

        static int unsigned(int n) {
            return Format.format(0, n, n > 32 ? 2 : 1);
        }

        static int floating(int n) {
            return Format.format(4096, n, n > 32 ? 2 : 1);
        }

        static int other(int n) {
            return n << 0;
        }
    }
}

