/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.net.ProtocolFamily;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousDatagramChannel;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.IllegalChannelGroupException;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import sun.nio.ch.SimpleAsynchronousDatagramChannelImpl;
import sun.nio.ch.SolarisEventPort;
import sun.nio.ch.ThreadPool;
import sun.nio.ch.UnixAsynchronousServerSocketChannelImpl;
import sun.nio.ch.UnixAsynchronousSocketChannelImpl;

public class SolarisAsynchronousChannelProvider
extends AsynchronousChannelProvider {
    private static volatile SolarisEventPort defaultEventPort;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SolarisEventPort defaultEventPort() throws IOException {
        if (defaultEventPort != null) return defaultEventPort;
        Class<SolarisAsynchronousChannelProvider> clazz = SolarisAsynchronousChannelProvider.class;
        synchronized (SolarisAsynchronousChannelProvider.class) {
            if (defaultEventPort != null) return defaultEventPort;
            defaultEventPort = new SolarisEventPort(this, ThreadPool.getDefault()).start();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return defaultEventPort;
        }
    }

    @Override
    public AsynchronousChannelGroup openAsynchronousChannelGroup(int n, ThreadFactory threadFactory) throws IOException {
        return new SolarisEventPort(this, ThreadPool.create(n, threadFactory)).start();
    }

    @Override
    public AsynchronousChannelGroup openAsynchronousChannelGroup(ExecutorService executorService, int n) throws IOException {
        return new SolarisEventPort(this, ThreadPool.wrap(executorService, n)).start();
    }

    private SolarisEventPort toEventPort(AsynchronousChannelGroup asynchronousChannelGroup) throws IOException {
        if (asynchronousChannelGroup == null) {
            return this.defaultEventPort();
        }
        if (!(asynchronousChannelGroup instanceof SolarisEventPort)) {
            throw new IllegalChannelGroupException();
        }
        return (SolarisEventPort)asynchronousChannelGroup;
    }

    @Override
    public AsynchronousServerSocketChannel openAsynchronousServerSocketChannel(AsynchronousChannelGroup asynchronousChannelGroup) throws IOException {
        return new UnixAsynchronousServerSocketChannelImpl(this.toEventPort(asynchronousChannelGroup));
    }

    @Override
    public AsynchronousSocketChannel openAsynchronousSocketChannel(AsynchronousChannelGroup asynchronousChannelGroup) throws IOException {
        return new UnixAsynchronousSocketChannelImpl(this.toEventPort(asynchronousChannelGroup));
    }

    @Override
    public AsynchronousDatagramChannel openAsynchronousDatagramChannel(ProtocolFamily protocolFamily, AsynchronousChannelGroup asynchronousChannelGroup) throws IOException {
        return new SimpleAsynchronousDatagramChannelImpl(protocolFamily, this.toEventPort(asynchronousChannelGroup));
    }
}

