/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.trace;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.VMStartException;
import com.sun.tools.example.trace.EventThread;
import com.sun.tools.example.trace.StreamRedirectThread;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;

public class Trace {
    private final VirtualMachine vm;
    private Thread errThread = null;
    private Thread outThread = null;
    private int debugTraceMode = 0;
    private boolean watchFields = false;
    private String[] excludes = new String[]{"java.*", "javax.*", "sun.*", "com.sun.*"};

    public static void main(String[] stringArray) {
        new Trace(stringArray);
    }

    Trace(String[] stringArray) {
        CharSequence charSequence;
        int n;
        PrintWriter printWriter = new PrintWriter(System.out);
        for (n = 0; n < stringArray.length && ((String)(charSequence = stringArray[n])).charAt(0) == '-'; ++n) {
            if (((String)charSequence).equals("-output")) {
                try {
                    printWriter = new PrintWriter(new FileWriter(stringArray[++n]));
                }
                catch (IOException iOException) {
                    System.err.println("Cannot open output file: " + stringArray[n] + " - " + iOException);
                    System.exit(1);
                }
                continue;
            }
            if (((String)charSequence).equals("-all")) {
                this.excludes = new String[0];
                continue;
            }
            if (((String)charSequence).equals("-fields")) {
                this.watchFields = true;
                continue;
            }
            if (((String)charSequence).equals("-dbgtrace")) {
                this.debugTraceMode = Integer.parseInt(stringArray[++n]);
                continue;
            }
            if (((String)charSequence).equals("-help")) {
                this.usage();
                System.exit(0);
                continue;
            }
            System.err.println("No option: " + (String)charSequence);
            this.usage();
            System.exit(1);
        }
        if (n >= stringArray.length) {
            System.err.println("<class> missing");
            this.usage();
            System.exit(1);
        }
        charSequence = new StringBuffer();
        ((StringBuffer)charSequence).append(stringArray[n]);
        ++n;
        while (n < stringArray.length) {
            ((StringBuffer)charSequence).append(' ');
            ((StringBuffer)charSequence).append(stringArray[n]);
            ++n;
        }
        this.vm = this.launchTarget(((StringBuffer)charSequence).toString());
        this.generateTrace(printWriter);
    }

    void generateTrace(PrintWriter printWriter) {
        this.vm.setDebugTraceMode(this.debugTraceMode);
        EventThread eventThread = new EventThread(this.vm, this.excludes, printWriter);
        eventThread.setEventRequests(this.watchFields);
        eventThread.start();
        this.redirectOutput();
        this.vm.resume();
        try {
            eventThread.join();
            this.errThread.join();
            this.outThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        printWriter.close();
    }

    VirtualMachine launchTarget(String string) {
        LaunchingConnector launchingConnector = this.findLaunchingConnector();
        Map map = this.connectorArguments(launchingConnector, string);
        try {
            return launchingConnector.launch(map);
        }
        catch (IOException iOException) {
            throw new Error("Unable to launch target VM: " + iOException);
        }
        catch (IllegalConnectorArgumentsException illegalConnectorArgumentsException) {
            throw new Error("Internal error: " + illegalConnectorArgumentsException);
        }
        catch (VMStartException vMStartException) {
            throw new Error("Target VM failed to initialize: " + vMStartException.getMessage());
        }
    }

    void redirectOutput() {
        Process process = this.vm.process();
        this.errThread = new StreamRedirectThread("error reader", process.getErrorStream(), System.err);
        this.outThread = new StreamRedirectThread("output reader", process.getInputStream(), System.out);
        this.errThread.start();
        this.outThread.start();
    }

    LaunchingConnector findLaunchingConnector() {
        List<Connector> list = Bootstrap.virtualMachineManager().allConnectors();
        for (Connector connector : list) {
            if (!connector.name().equals("com.sun.jdi.CommandLineLaunch")) continue;
            return (LaunchingConnector)connector;
        }
        throw new Error("No launching connector");
    }

    Map connectorArguments(LaunchingConnector launchingConnector, String string) {
        Map<String, Connector.Argument> map = launchingConnector.defaultArguments();
        Connector.Argument argument = map.get("main");
        if (argument == null) {
            throw new Error("Bad launching connector");
        }
        argument.setValue(string);
        if (this.watchFields) {
            Connector.Argument argument2 = map.get("options");
            if (argument2 == null) {
                throw new Error("Bad launching connector");
            }
            argument2.setValue("-classic");
        }
        return map;
    }

    void usage() {
        System.err.println("Usage: java Trace <options> <class> <args>");
        System.err.println("<options> are:");
        System.err.println("  -output <filename>   Output trace to <filename>");
        System.err.println("  -all                 Include system classes in output");
        System.err.println("  -help                Print this help message");
        System.err.println("<class> is the program to trace");
        System.err.println("<args> are the arguments to <class>");
    }
}

