/*
 * Decompiled with CFR 0.152.
 */
package com.sun.demo.scripting.jconsole;

import com.sun.demo.scripting.jconsole.EditableAtEndDocument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

class ScriptShellPanel
extends JPanel {
    private CommandProcessor commandProcessor;
    private JTextComponent editor;
    private final ExecutorService commandExecutor = Executors.newSingleThreadExecutor();
    private boolean updating;

    public ScriptShellPanel(CommandProcessor commandProcessor) {
        this.setLayout(new BorderLayout());
        this.commandProcessor = commandProcessor;
        this.editor = new JTextArea();
        this.editor.setDocument(new EditableAtEndDocument());
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.editor);
        this.add((Component)jScrollPane, "Center");
        this.editor.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (ScriptShellPanel.this.updating) {
                    return;
                }
                ScriptShellPanel.this.beginUpdate();
                ScriptShellPanel.this.editor.setCaretPosition(ScriptShellPanel.this.editor.getDocument().getLength());
                if (ScriptShellPanel.this.insertContains(documentEvent, '\n')) {
                    String string = ScriptShellPanel.this.getMarkedText();
                    if (string.length() == 0 || string.charAt(string.length() - 1) != '\\') {
                        final String string2 = ScriptShellPanel.this.trimContinuations(string);
                        ScriptShellPanel.this.commandExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                final String string = ScriptShellPanel.this.executeCommand(string2);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (string != null) {
                                            ScriptShellPanel.this.print(string + "\n");
                                        }
                                        ScriptShellPanel.this.printPrompt();
                                        ScriptShellPanel.this.setMark();
                                        ScriptShellPanel.this.endUpdate();
                                    }
                                });
                            }
                        });
                    } else {
                        ScriptShellPanel.this.endUpdate();
                    }
                } else {
                    ScriptShellPanel.this.endUpdate();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
            }
        });
        this.editor.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                int n = ScriptShellPanel.this.editor.getDocument().getLength();
                if (caretEvent.getDot() > n) {
                    ScriptShellPanel.this.editor.setCaretPosition(n);
                }
            }
        });
        Box box = Box.createHorizontalBox();
        box.add(Box.createGlue());
        JButton jButton = new JButton("Clear");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScriptShellPanel.this.clear();
            }
        });
        box.add(jButton);
        box.add(Box.createGlue());
        this.add((Component)box, "South");
        this.clear();
    }

    public void dispose() {
        this.commandExecutor.shutdown();
    }

    @Override
    public void requestFocus() {
        this.editor.requestFocus();
    }

    public void clear() {
        this.clear(true);
    }

    public void clear(boolean bl) {
        EditableAtEndDocument editableAtEndDocument = (EditableAtEndDocument)this.editor.getDocument();
        editableAtEndDocument.clear();
        if (bl) {
            this.printPrompt();
        }
        this.setMark();
        this.editor.requestFocus();
    }

    public void setMark() {
        ((EditableAtEndDocument)this.editor.getDocument()).setMark();
    }

    public String getMarkedText() {
        try {
            int n;
            String string = ((EditableAtEndDocument)this.editor.getDocument()).getMarkedText();
            for (n = string.length(); n > 0 && string.charAt(n - 1) == '\n'; --n) {
            }
            return string.substring(0, n);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return null;
        }
    }

    public void print(String string) {
        Document document = this.editor.getDocument();
        try {
            document.insertString(document.getLength(), string, null);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    private String executeCommand(String string) {
        return this.commandProcessor.executeCommand(string);
    }

    private String getPrompt() {
        return this.commandProcessor.getPrompt();
    }

    private void beginUpdate() {
        this.editor.setEditable(false);
        this.updating = true;
    }

    private void endUpdate() {
        this.editor.setEditable(true);
        this.updating = false;
    }

    private void printPrompt() {
        this.print(this.getPrompt());
    }

    private boolean insertContains(DocumentEvent documentEvent, char c) {
        String string = null;
        try {
            string = this.editor.getText(documentEvent.getOffset(), documentEvent.getLength());
            for (int i = 0; i < documentEvent.getLength(); ++i) {
                if (string.charAt(i) != c) continue;
                return true;
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return false;
    }

    private String trimContinuations(String string) {
        int n;
        while ((n = string.indexOf("\\\n")) >= 0) {
            string = string.substring(0, n) + string.substring(n + 1, string.length());
        }
        return string;
    }

    static interface CommandProcessor {
        public String executeCommand(String var1);

        public String getPrompt();
    }
}

