/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifReader;
import com.drew.metadata.iptc.IptcReader;
import java.io.File;
import java.util.Iterator;

public class SampleUsage {
    public SampleUsage(String string) {
        Object object;
        File file = new File(string);
        try {
            object = JpegMetadataReader.readMetadata(file);
            this.printImageTags(1, (Metadata)object);
        }
        catch (JpegProcessingException jpegProcessingException) {
            System.err.println("error 1a");
        }
        try {
            object = new Metadata();
            new ExifReader(file).extract((Metadata)object);
            new IptcReader(file).extract((Metadata)object);
            this.printImageTags(2, (Metadata)object);
        }
        catch (JpegProcessingException jpegProcessingException) {
            System.err.println("error 2a");
        }
        try {
            object = new JpegSegmentReader(file);
            byte[] byArray = ((JpegSegmentReader)object).readSegment((byte)-31);
            byte[] byArray2 = ((JpegSegmentReader)object).readSegment((byte)-19);
            Metadata metadata = new Metadata();
            new ExifReader(byArray).extract(metadata);
            new IptcReader(byArray2).extract(metadata);
            this.printImageTags(3, metadata);
        }
        catch (JpegProcessingException jpegProcessingException) {
            System.err.println("error 3a");
        }
    }

    private void printImageTags(int n, Metadata metadata) {
        System.out.println();
        System.out.println("*** APPROACH " + n + " ***");
        System.out.println();
        Iterator iterator = metadata.getDirectoryIterator();
        while (iterator.hasNext()) {
            Object object;
            Directory directory = (Directory)iterator.next();
            Iterator iterator2 = directory.getTagIterator();
            while (iterator2.hasNext()) {
                object = (Tag)iterator2.next();
                System.out.println(object);
            }
            if (!directory.hasErrors()) continue;
            object = directory.getErrors();
            while (object.hasNext()) {
                System.out.println("ERROR: " + object.next());
            }
        }
    }

    public static void main(String[] stringArray) {
        new SampleUsage("src/com/drew/metadata/test/withIptcExifGps.jpg");
    }
}

