/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInfoAction
extends JosmAction {
    public AbstractInfoAction() {
    }

    public AbstractInfoAction(String name, String iconName, String tooltip, Shortcut shortcut, boolean register) {
        super(name, iconName, tooltip, shortcut, register);
    }

    public static String getBaseBrowseUrl() {
        String baseUrl = Main.pref.get("osm-server.url", "http://api.openstreetmap.org/api");
        Pattern pattern = Pattern.compile("/api/?$");
        String ret = pattern.matcher(baseUrl).replaceAll("/browse");
        if (ret.equals(baseUrl)) {
            System.out.println(I18n.tr("WARNING: unexpected format of API base URL. Redirection to info or history page for OSM primitive will probably fail. API base URL is: ''{0}''", baseUrl));
        }
        if (ret.startsWith("http://api.openstreetmap.org/")) {
            ret = ret.substring("http://api.openstreetmap.org/".length());
            ret = "http://www.openstreetmap.org/" + ret;
        }
        return ret;
    }

    public static String getBaseUserUrl() {
        String baseUrl = Main.pref.get("osm-server.url", "http://api.openstreetmap.org/api");
        Pattern pattern = Pattern.compile("/api/?$");
        String ret = pattern.matcher(baseUrl).replaceAll("/user");
        if (ret.equals(baseUrl)) {
            System.out.println(I18n.tr("WARNING: unexpected format of API base URL. Redirection to user page for OSM user will probably fail. API base URL is: ''{0}''", baseUrl));
        }
        if (ret.startsWith("http://api.openstreetmap.org/")) {
            ret = ret.substring("http://api.openstreetmap.org/".length());
            ret = "http://www.openstreetmap.org/" + ret;
        }
        return ret;
    }

    protected void launchBrowser(URL url) {
        OpenBrowser.displayUrl(url.toString());
    }

    protected void launchBrowser(String url) {
        OpenBrowser.displayUrl(url);
    }

    public static boolean confirmLaunchMultiple(int numBrowsers) {
        String msg = I18n.tr("You are about to launch {0} browser windows.<br>This may both clutter your screen with browser windows<br>and take some time to finish.", numBrowsers);
        msg = "<html>" + msg + "</html>";
        HelpAwareOptionPane.ButtonSpec[] spec = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Continue"), ImageProvider.get("ok"), I18n.tr("Click to continue and to open {0} browsers", numBrowsers), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel"), ImageProvider.get("cancel"), I18n.tr("Click to abort launching external browsers"), null)};
        int ret = HelpAwareOptionPane.showOptionDialog(Main.parent, msg, I18n.tr("Warning"), 2, null, spec, spec[0], HelpUtil.ht("/WarningMessages#ToManyBrowsersToOpen"));
        return ret == 0;
    }

    protected void launchInfoBrowsersForSelectedPrimitives() {
        ArrayList<OsmPrimitive> primitivesToShow = new ArrayList<OsmPrimitive>(this.getCurrentDataSet().getSelected());
        Iterator<OsmPrimitive> it = primitivesToShow.iterator();
        while (it.hasNext()) {
            if (!it.next().isNew()) continue;
            it.remove();
        }
        if (primitivesToShow.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Please select at least one already uploaded node, way, or relation."), I18n.tr("Warning"), 2);
            return;
        }
        int max = Math.min(10, primitivesToShow.size());
        if (primitivesToShow.size() > max && !AbstractInfoAction.confirmLaunchMultiple(primitivesToShow.size())) {
            return;
        }
        for (int i = 0; i < max; ++i) {
            this.launchBrowser(this.createInfoUrl(primitivesToShow.get(i)));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.launchInfoBrowsersForSelectedPrimitives();
    }

    protected abstract String createInfoUrl(Object var1);

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getCurrentDataSet() != null && !this.getCurrentDataSet().getSelected().isEmpty());
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }
}

