/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.io.AllFormatsImporter;
import org.openstreetmap.josm.io.FileImporter;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenFileAction
extends DiskAccessAction {
    public OpenFileAction() {
        super(I18n.tr("Open..."), "open", I18n.tr("Open a file."), Shortcut.registerShortcut("system:open", I18n.tr("File: {0}", I18n.tr("Open...")), 79, 2));
        this.putValue("help", HelpUtil.ht("/Action/OpenFile"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser fc = OpenFileAction.createAndOpenFileChooser(true, true, null);
        if (fc == null) {
            return;
        }
        File[] files = fc.getSelectedFiles();
        OpenFileTask task = new OpenFileTask(Arrays.asList(files), fc.getFileFilter());
        Main.worker.submit(task);
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(!Main.applet);
    }

    public static void openFiles(List<File> fileList) {
        OpenFileTask task = new OpenFileTask(fileList, null);
        Main.worker.submit(task);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OpenFileTask
    extends PleaseWaitRunnable {
        private List<File> files;
        private FileFilter fileFilter;
        private boolean cancelled;

        public OpenFileTask(List<File> files, FileFilter fileFilter) {
            super(I18n.tr("Opening files"), false);
            this.files = new ArrayList<File>(files);
            this.fileFilter = fileFilter;
        }

        @Override
        protected void cancel() {
            this.cancelled = true;
        }

        @Override
        protected void finish() {
        }

        protected void alertFilesNotMatchingWithImporter(Collection<File> files, FileImporter importer) {
            final StringBuffer msg = new StringBuffer();
            msg.append("<html>");
            msg.append(I18n.trn("Cannot open {0} file with the file importer ''{1}''.", "Cannot open {0} files with the file importer ''{1}''.", files.size(), files.size(), importer.filter.getDescription())).append("<br>");
            msg.append("<ul>");
            for (File f : files) {
                msg.append("<li>").append(f.getAbsolutePath()).append("</li>");
            }
            msg.append("</ul>");
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    HelpAwareOptionPane.showOptionDialog(Main.parent, msg.toString(), I18n.tr("Warning"), 2, HelpUtil.ht("/Action/OpenFile#ImporterCantImportFiles"));
                }
            });
        }

        protected void alertFilesWithUnknownImporter(Collection<File> files) {
            final StringBuffer msg = new StringBuffer();
            msg.append("<html>");
            msg.append(I18n.trn("Cannot open {0} file because no suitable file importer is available.", "Cannot open {0} files because no suitable file importer is available.", files.size(), files.size())).append("<br>");
            msg.append("<ul>");
            for (File f : files) {
                msg.append("<li>").append(f.getAbsolutePath()).append("</li>");
            }
            msg.append("</ul>");
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    HelpAwareOptionPane.showOptionDialog(Main.parent, msg.toString(), I18n.tr("Warning"), 2, HelpUtil.ht("/Action/OpenFile#MissingImporterForFiles"));
                }
            });
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            if (this.files == null || this.files.isEmpty()) {
                return;
            }
            FileImporter chosenImporter = null;
            for (FileImporter importer : ExtensionFileFilter.importers) {
                if (this.fileFilter != importer.filter) continue;
                chosenImporter = importer;
            }
            if (chosenImporter instanceof AllFormatsImporter) {
                chosenImporter = null;
            }
            this.getProgressMonitor().setTicksCount(this.files.size());
            if (chosenImporter != null) {
                LinkedList<File> filesNotMatchingWithImporter = new LinkedList<File>();
                LinkedList<File> filesMatchingWithImporter = new LinkedList<File>();
                for (final File f : this.files) {
                    if (!chosenImporter.acceptFile(f)) {
                        if (f.isDirectory()) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Cannot open directory ''{0}''.<br>Please select a file.</html>", f.getAbsolutePath()), I18n.tr("Open file"), 0);
                                }
                            });
                            return;
                        }
                        filesNotMatchingWithImporter.add(f);
                        continue;
                    }
                    filesMatchingWithImporter.add(f);
                }
                if (!filesNotMatchingWithImporter.isEmpty()) {
                    this.alertFilesNotMatchingWithImporter(filesNotMatchingWithImporter, chosenImporter);
                    return;
                }
                if (!filesMatchingWithImporter.isEmpty()) {
                    this.importData(chosenImporter, filesMatchingWithImporter);
                }
            } else {
                MultiMap<FileImporter, File> map = new MultiMap<FileImporter, File>();
                LinkedList<File> filesWithKnownImporter = new LinkedList<File>();
                LinkedList<File> filesWithUnknownImporter = new LinkedList<File>();
                block2: for (File f : this.files) {
                    for (FileImporter importer : ExtensionFileFilter.importers) {
                        if (!importer.acceptFile(f)) continue;
                        map.put(importer, f);
                        filesWithKnownImporter.add(f);
                        continue block2;
                    }
                    filesWithUnknownImporter.add(f);
                }
                if (!filesWithUnknownImporter.isEmpty()) {
                    this.alertFilesWithUnknownImporter(filesWithUnknownImporter);
                    return;
                }
                ArrayList ims = new ArrayList(map.keySet());
                Collections.sort(ims);
                Collections.reverse(ims);
                for (FileImporter importer : ims) {
                    ArrayList<File> files = new ArrayList<File>((Collection)map.get(importer));
                    this.importData(importer, files);
                }
            }
        }

        public void importData(FileImporter importer, List<File> files) {
            if (importer.isBatchImporter()) {
                if (this.cancelled) {
                    return;
                }
                String msg = files.size() == 1 ? I18n.tr("Opening 1 file...") : I18n.trn("Opening {0} file...", "Opening {0} files...", files.size(), files.size());
                this.getProgressMonitor().setCustomText(msg);
                this.getProgressMonitor().indeterminateSubTask(msg);
                importer.importDataHandleExceptions(files, this.getProgressMonitor().createSubTaskMonitor(files.size(), false));
            } else {
                for (File f : files) {
                    if (this.cancelled) {
                        return;
                    }
                    this.getProgressMonitor().indeterminateSubTask(I18n.tr("Opening file ''{0}'' ...", f.getAbsolutePath()));
                    importer.importDataHandleExceptions(f, this.getProgressMonitor().createSubTaskMonitor(1, false));
                }
            }
        }
    }
}

