/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.io.IOException;
import java.util.concurrent.Future;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.BoundingBoxDownloader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadGpsTask
extends AbstractDownloadTask {
    private DownloadTask downloadTask;

    @Override
    public Future<?> download(boolean newLayer, Bounds downloadArea, ProgressMonitor progressMonitor) {
        this.downloadTask = new DownloadTask(newLayer, new BoundingBoxDownloader(downloadArea), progressMonitor);
        return Main.worker.submit(this.downloadTask);
    }

    @Override
    public Future<?> loadUrl(boolean a, String b, ProgressMonitor progressMonitor) {
        return null;
    }

    @Override
    public void cancel() {
        if (this.downloadTask != null) {
            this.downloadTask.cancel();
        }
    }

    class DownloadTask
    extends PleaseWaitRunnable {
        private BoundingBoxDownloader reader;
        private GpxData rawData;
        private final boolean newLayer;

        public DownloadTask(boolean newLayer, BoundingBoxDownloader reader, ProgressMonitor progressMonitor) {
            super(I18n.tr("Downloading GPS data"));
            this.reader = reader;
            this.newLayer = newLayer;
        }

        public void realRun() throws IOException, SAXException, OsmTransferException {
            try {
                if (DownloadGpsTask.this.isCanceled()) {
                    return;
                }
                this.rawData = this.reader.parseRawGps(this.progressMonitor.createSubTaskMonitor(-1, false));
            }
            catch (Exception e) {
                if (DownloadGpsTask.this.isCanceled()) {
                    return;
                }
                if (e instanceof OsmTransferException) {
                    DownloadGpsTask.this.rememberException(e);
                }
                DownloadGpsTask.this.rememberException(new OsmTransferException(e));
            }
        }

        protected void finish() {
            if (DownloadGpsTask.this.isCanceled() || DownloadGpsTask.this.isFailed()) {
                return;
            }
            if (this.rawData == null) {
                return;
            }
            this.rawData.recalculateBounds();
            String name = I18n.tr("Downloaded GPX Data");
            GpxLayer layer = new GpxLayer(this.rawData, name);
            Layer x = this.findMergeLayer();
            if (this.newLayer || x == null) {
                Main.main.addLayer(layer);
            } else {
                x.mergeFrom(layer);
            }
        }

        private Layer findMergeLayer() {
            boolean merge = Main.pref.getBoolean("download.gps.mergeWithLocal", false);
            if (!Main.isDisplayingMapView()) {
                return null;
            }
            Layer active = Main.map.mapView.getActiveLayer();
            if (active != null && active instanceof GpxLayer && (merge || ((GpxLayer)active).data.fromServer)) {
                return active;
            }
            for (Layer l : Main.map.mapView.getAllLayers()) {
                if (!(l instanceof GpxLayer) || !merge && !((GpxLayer)l).data.fromServer) continue;
                return l;
            }
            return null;
        }

        protected void cancel() {
            DownloadGpsTask.this.setCanceled(true);
            if (this.reader != null) {
                this.reader.cancel();
            }
        }
    }
}

