/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.coor;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.Coordinate;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.tools.I18n;

public class LatLon
extends Coordinate {
    public static final double MAX_SERVER_PRECISION = 1.0E-7;
    private static DecimalFormat cDmsMinuteFormatter = new DecimalFormat("00");
    private static DecimalFormat cDmsSecondFormatter = new DecimalFormat("00.0");
    private static DecimalFormat cDdFormatter = (DecimalFormat)NumberFormat.getInstance(Locale.UK);

    public static boolean isValidLat(double lat) {
        return lat >= -90.0 && lat <= 90.0;
    }

    public static boolean isValidLon(double lon) {
        return lon >= -180.0 && lon <= 180.0;
    }

    public static String dms(double pCoordinate) {
        double tAbsCoord = Math.abs(pCoordinate);
        int tDegree = (int)tAbsCoord;
        double tTmpMinutes = (tAbsCoord - (double)tDegree) * 60.0;
        int tMinutes = (int)tTmpMinutes;
        double tSeconds = (tTmpMinutes - (double)tMinutes) * 60.0;
        return tDegree + "\u00b0" + cDmsMinuteFormatter.format(tMinutes) + "'" + cDmsSecondFormatter.format(tSeconds) + "\"";
    }

    public LatLon(double lat, double lon) {
        super(lon, lat);
    }

    public LatLon(LatLon coor) {
        super(coor.lon(), coor.lat());
    }

    public double lat() {
        return this.y;
    }

    public String latToString(CoordinateFormat d) {
        switch (d) {
            case DECIMAL_DEGREES: {
                return cDdFormatter.format(this.y);
            }
            case DEGREES_MINUTES_SECONDS: {
                return LatLon.dms(this.y) + (this.y < 0.0 ? I18n.trc("compass", "S") : I18n.trc("compass", "N"));
            }
            case EAST_NORTH: {
                return cDdFormatter.format(Main.proj.latlon2eastNorth(this).north());
            }
        }
        return "ERR";
    }

    public double lon() {
        return this.x;
    }

    public String lonToString(CoordinateFormat d) {
        switch (d) {
            case DECIMAL_DEGREES: {
                return cDdFormatter.format(this.x);
            }
            case DEGREES_MINUTES_SECONDS: {
                return LatLon.dms(this.x) + (this.x < 0.0 ? I18n.trc("compass", "W") : I18n.trc("compass", "E"));
            }
            case EAST_NORTH: {
                return cDdFormatter.format(Main.proj.latlon2eastNorth(this).east());
            }
        }
        return "ERR";
    }

    public boolean equalsEpsilon(LatLon other) {
        double p = 5.0E-8;
        return Math.abs(this.lat() - other.lat()) <= p && Math.abs(this.lon() - other.lon()) <= p;
    }

    public boolean isOutSideWorld() {
        Bounds b = Main.proj.getWorldBoundsLatLon();
        return this.lat() < b.getMin().lat() || this.lat() > b.getMax().lat() || this.lon() < b.getMin().lon() || this.lon() > b.getMax().lon();
    }

    public boolean isWithin(Bounds b) {
        return this.lat() >= b.getMin().lat() && this.lat() <= b.getMax().lat() && this.lon() > b.getMin().lon() && this.lon() < b.getMax().lon();
    }

    public double greatCircleDistance(LatLon other) {
        double R = 6378135.0;
        double sinHalfLat = Math.sin(Math.toRadians(other.lat() - this.lat()) / 2.0);
        double sinHalfLon = Math.sin(Math.toRadians(other.lon() - this.lon()) / 2.0);
        double d = 2.0 * R * Math.asin(Math.sqrt(sinHalfLat * sinHalfLat + Math.cos(Math.toRadians(this.lat())) * Math.cos(Math.toRadians(other.lat())) * sinHalfLon * sinHalfLon));
        if (Double.isNaN(d)) {
            System.err.println("Error: NaN in greatCircleDistance");
            d = Math.PI * R;
        }
        return d;
    }

    public double heading(LatLon other) {
        double rv;
        if (other.lat() == this.lat()) {
            rv = other.lon() > this.lon() ? 1.5707963267948966 : 4.71238898038469;
        } else {
            rv = Math.atan((other.lon() - this.lon()) / (other.lat() - this.lat()));
            if (rv < 0.0) {
                rv += Math.PI;
            }
            if (other.lon() < this.lon()) {
                rv += Math.PI;
            }
        }
        return rv;
    }

    public String toDisplayString() {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(5);
        return "lat=" + nf.format(this.lat()) + "\u00b0, lon=" + nf.format(this.lon()) + "\u00b0";
    }

    public LatLon interpolate(LatLon ll2, double proportion) {
        return new LatLon(this.lat() + proportion * (ll2.lat() - this.lat()), this.lon() + proportion * (ll2.lon() - this.lon()));
    }

    public LatLon getCenter(LatLon ll2) {
        return new LatLon((this.lat() + ll2.lat()) / 2.0, (this.lon() + ll2.lon()) / 2.0);
    }

    public String toString() {
        return "LatLon[lat=" + this.lat() + ",lon=" + this.lon() + "]";
    }

    public LatLon getRoundedToOsmPrecision() {
        return new LatLon((double)Math.round(this.lat() / 1.0E-7) * 1.0E-7, (double)Math.round(this.lon() / 1.0E-7) * 1.0E-7);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Coordinate other = (Coordinate)obj;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        return Double.doubleToLongBits(this.y) == Double.doubleToLongBits(other.y);
    }

    static {
        cDdFormatter.applyPattern("###0.00000");
    }
}

