/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Collection;
import org.openstreetmap.josm.data.osm.FilterMatcher;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterWorker {
    public static void executeFilters(Collection<OsmPrimitive> all, FilterMatcher filterMatcher) {
        for (OsmPrimitive primitive : all) {
            if (primitive instanceof Node) continue;
            if (filterMatcher.isHidden(primitive)) {
                primitive.setDisabledState(true);
                continue;
            }
            if (filterMatcher.isDisabled(primitive)) {
                primitive.setDisabledState(false);
                continue;
            }
            primitive.unsetDisabledState();
        }
        for (OsmPrimitive primitive : all) {
            if (!(primitive instanceof Node)) continue;
            if (filterMatcher.isHidden(primitive)) {
                primitive.setDisabledState(true);
                continue;
            }
            if (filterMatcher.isDisabled(primitive)) {
                primitive.setDisabledState(false);
                continue;
            }
            primitive.unsetDisabledState();
        }
    }

    public static boolean executeFilters(OsmPrimitive primitive, FilterMatcher filterMatcher) {
        boolean hidden = primitive.isDisabledAndHidden();
        boolean disabled = primitive.isDisabled();
        if (filterMatcher.isHidden(primitive)) {
            primitive.setDisabledState(true);
        } else if (filterMatcher.isDisabled(primitive)) {
            primitive.setDisabledState(false);
        } else {
            primitive.unsetDisabledState();
        }
        return hidden != primitive.isDisabledAndHidden() || disabled != primitive.isDisabled();
    }

    public static void clearFilterFlags(Collection<OsmPrimitive> prims) {
        for (OsmPrimitive osm : prims) {
            osm.unsetDisabledState();
        }
    }
}

