/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

public class Tag {
    private String key;
    private String value;

    public Tag() {
        this("", "");
    }

    public Tag(String key) {
        this(key, "");
    }

    public Tag(String key, String value) {
        this.key = key == null ? "" : key;
        this.value = value == null ? "" : value;
    }

    public Tag(Tag tag) {
        this(tag.getKey(), tag.getValue());
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public Tag clone() {
        return new Tag(this);
    }

    public boolean matchesKey(String key) {
        return this.key.equals(key);
    }

    public void normalize() {
        this.key = this.key.trim();
        this.value = this.value.trim();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.key.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Tag) {
            Tag other = (Tag)obj;
            return this.key.equals(other.getKey()) && this.value.equals(other.getValue());
        }
        return false;
    }

    public String toString() {
        return this.key + "=" + this.value;
    }
}

