/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;

public class ChangesetClosedException
extends OsmTransferException {
    public static final String ERROR_HEADER_PATTERN = "The changeset (\\d+) was closed at (.*)";
    private long changesetId;
    private Date closedOn;
    private Source source;

    public static boolean errorHeaderMatchesPattern(String errorHeader) {
        if (errorHeader == null) {
            return false;
        }
        Pattern p = Pattern.compile(ERROR_HEADER_PATTERN);
        Matcher m = p.matcher(errorHeader);
        return m.matches();
    }

    protected void parseErrorHeader(String errorHeader) {
        Pattern p = Pattern.compile(ERROR_HEADER_PATTERN);
        Matcher m = p.matcher(errorHeader);
        if (m.matches()) {
            this.changesetId = Long.parseLong(m.group(1));
            SimpleDateFormat formatter = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.ENGLISH);
            try {
                this.closedOn = formatter.parse(m.group(2));
            }
            catch (ParseException ex) {
                System.err.println(I18n.tr("Failed to parse date ''{0}'' replied by server.", m.group(2)));
                ex.printStackTrace();
            }
        } else {
            System.err.println(I18n.tr("Unexpected format of error header for conflict in changeset update. Got ''{0}''", errorHeader));
        }
    }

    public ChangesetClosedException(String errorHeader) {
        super(errorHeader);
        this.parseErrorHeader(errorHeader);
        this.source = Source.UNSPECIFIED;
    }

    public ChangesetClosedException(String errorHeader, Source source) {
        super(errorHeader);
        this.parseErrorHeader(errorHeader);
        this.source = source == null ? Source.UNSPECIFIED : source;
    }

    public ChangesetClosedException(long changesetId, Date closedOn, Source source) {
        super("");
        this.source = source == null ? Source.UNSPECIFIED : source;
        this.changesetId = changesetId;
        this.closedOn = closedOn;
    }

    public long getChangesetId() {
        return this.changesetId;
    }

    public Date getClosedOn() {
        return this.closedOn;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source == null ? Source.UNSPECIFIED : source;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Source {
        UPDATE_CHANGESET,
        UPLOAD_DATA,
        UNSPECIFIED;

    }
}

