/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import sun.nio.cs.ext.CompoundTextSupport;

public class COMPOUND_TEXT_Encoder
extends CharsetEncoder {
    private static final Map encodingToEncoderMap = Collections.synchronizedMap(new HashMap(21, 1.0f));
    private static final CharsetEncoder latin1Encoder;
    private static final CharsetEncoder defaultEncoder;
    private static final boolean defaultEncodingSupported;
    private CharsetEncoder encoder;
    private char[] charBuf = new char[1];
    private CharBuffer charbuf = CharBuffer.wrap(this.charBuf);
    private ByteArrayOutputStream nonStandardCharsetBuffer;
    private byte[] byteBuf;
    private ByteBuffer bytebuf;
    private int numNonStandardChars;
    private int nonStandardEncodingLen;
    private CharBuffer fcb = CharBuffer.allocate(0);

    public COMPOUND_TEXT_Encoder(Charset charset) {
        super(charset, CompoundTextSupport.MAX_CONTROL_SEQUENCE_LEN + 2, CompoundTextSupport.MAX_CONTROL_SEQUENCE_LEN + 2);
        try {
            this.encoder = Charset.forName("ISO8859_1").newEncoder();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.initEncoder(this.encoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
        CoderResult coderResult = CoderResult.UNDERFLOW;
        char[] cArray = charBuffer.array();
        int n = charBuffer.arrayOffset() + charBuffer.position();
        int n2 = charBuffer.arrayOffset() + charBuffer.limit();
        try {
            Object object;
            while (n < n2 && coderResult.isUnderflow()) {
                Object object2;
                this.charBuf[0] = cArray[n];
                if (this.charBuf[0] <= '\b' || this.charBuf[0] >= '\u000b' && this.charBuf[0] <= '\u001f' || this.charBuf[0] >= '\u0080' && this.charBuf[0] <= '\u009f') {
                    this.charBuf[0] = 63;
                }
                if ((object = this.getEncoder(this.charBuf[0])) == null) {
                    if (this.unmappableCharacterAction() == CodingErrorAction.REPORT) {
                        this.charBuf[0] = 63;
                        object = latin1Encoder;
                    } else {
                        object2 = CoderResult.unmappableForLength(1);
                        return object2;
                    }
                }
                if (object != this.encoder) {
                    if (this.nonStandardCharsetBuffer != null) {
                        coderResult = this.flushNonStandardCharsetBuffer(byteBuffer);
                    } else {
                        this.flushEncoder(this.encoder, byteBuffer);
                    }
                    if (!coderResult.isUnderflow()) {
                        object2 = coderResult;
                        return object2;
                    }
                    object2 = CompoundTextSupport.getEscapeSequence(((CharsetEncoder)object).charset().name());
                    if (object2 == null) {
                        throw new InternalError("Unknown encoding: " + ((CharsetEncoder)object).charset().name());
                    }
                    if (object2[1] == 37 && object2[2] == 47) {
                        this.initNonStandardCharsetBuffer((CharsetEncoder)object, (byte[])object2);
                    } else if (byteBuffer.remaining() >= ((Object)object2).length) {
                        byteBuffer.put((byte[])object2, 0, ((Object)object2).length);
                    } else {
                        CoderResult coderResult2 = CoderResult.OVERFLOW;
                        return coderResult2;
                    }
                    this.encoder = object;
                    continue;
                }
                this.charbuf.rewind();
                if (this.nonStandardCharsetBuffer == null) {
                    coderResult = this.encoder.encode(this.charbuf, byteBuffer, false);
                } else {
                    this.bytebuf.clear();
                    coderResult = this.encoder.encode(this.charbuf, this.bytebuf, false);
                    this.bytebuf.flip();
                    this.nonStandardCharsetBuffer.write(this.byteBuf, 0, this.bytebuf.limit());
                    ++this.numNonStandardChars;
                }
                ++n;
            }
            object = coderResult;
            return object;
        }
        finally {
            charBuffer.position(n - charBuffer.arrayOffset());
        }
    }

    @Override
    protected CoderResult implFlush(ByteBuffer byteBuffer) {
        CoderResult coderResult = this.nonStandardCharsetBuffer != null ? this.flushNonStandardCharsetBuffer(byteBuffer) : this.flushEncoder(this.encoder, byteBuffer);
        this.reset();
        return coderResult;
    }

    private void initNonStandardCharsetBuffer(CharsetEncoder charsetEncoder, byte[] byArray) {
        this.nonStandardCharsetBuffer = new ByteArrayOutputStream();
        this.byteBuf = new byte[(int)charsetEncoder.maxBytesPerChar()];
        this.bytebuf = ByteBuffer.wrap(this.byteBuf);
        this.nonStandardCharsetBuffer.write(byArray, 0, byArray.length);
        this.nonStandardCharsetBuffer.write(0);
        this.nonStandardCharsetBuffer.write(0);
        byte[] byArray2 = CompoundTextSupport.getEncoding(charsetEncoder.charset().name());
        if (byArray2 == null) {
            throw new InternalError("Unknown encoding: " + this.encoder.charset().name());
        }
        this.nonStandardCharsetBuffer.write(byArray2, 0, byArray2.length);
        this.nonStandardCharsetBuffer.write(2);
        this.nonStandardEncodingLen = byArray2.length + 1;
    }

    private CoderResult flushNonStandardCharsetBuffer(ByteBuffer byteBuffer) {
        int n;
        if (this.numNonStandardChars > 0) {
            byte[] byArray = new byte[(int)this.encoder.maxBytesPerChar() * this.numNonStandardChars];
            ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray);
            this.flushEncoder(this.encoder, byteBuffer2);
            byteBuffer2.flip();
            this.nonStandardCharsetBuffer.write(byArray, 0, byteBuffer2.limit());
            this.numNonStandardChars = 0;
        }
        int n2 = this.nonStandardCharsetBuffer.size();
        int n3 = 6 + this.nonStandardEncodingLen;
        if (byteBuffer.remaining() < n2 - n3 + n3 * ((n2 - n3) / 16383 + 1)) {
            return CoderResult.OVERFLOW;
        }
        byte[] byArray = this.nonStandardCharsetBuffer.toByteArray();
        do {
            byteBuffer.put((byte)27);
            byteBuffer.put((byte)37);
            byteBuffer.put((byte)47);
            byteBuffer.put(byArray[3]);
            n = Math.min(n2 - n3, 16383 - this.nonStandardEncodingLen);
            byteBuffer.put((byte)((n + this.nonStandardEncodingLen) / 128 | 0x80));
            byteBuffer.put((byte)((n + this.nonStandardEncodingLen) % 128 | 0x80));
            byteBuffer.put(byArray, 6, this.nonStandardEncodingLen);
            byteBuffer.put(byArray, n3, n);
        } while ((n3 += n) < n2);
        this.nonStandardCharsetBuffer = null;
        this.byteBuf = null;
        this.nonStandardEncodingLen = 0;
        return CoderResult.UNDERFLOW;
    }

    @Override
    protected void implReset() {
        this.nonStandardEncodingLen = 0;
        this.numNonStandardChars = 0;
        this.nonStandardCharsetBuffer = null;
        this.byteBuf = null;
        try {
            this.encoder = Charset.forName("ISO8859_1").newEncoder();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.initEncoder(this.encoder);
    }

    @Override
    public boolean canEncode(char c) {
        return this.getEncoder(c) != null;
    }

    @Override
    protected void implOnMalformedInput(CodingErrorAction codingErrorAction) {
        this.encoder.onUnmappableCharacter(codingErrorAction);
    }

    @Override
    protected void implOnUnmappableCharacter(CodingErrorAction codingErrorAction) {
        this.encoder.onUnmappableCharacter(codingErrorAction);
    }

    @Override
    protected void implReplaceWith(byte[] byArray) {
        if (this.encoder != null) {
            this.encoder.replaceWith(byArray);
        }
    }

    private CharsetEncoder getEncoder(char c) {
        if (this.encoder.canEncode(c)) {
            return this.encoder;
        }
        if (defaultEncodingSupported && defaultEncoder.canEncode(c)) {
            CharsetEncoder charsetEncoder = null;
            try {
                charsetEncoder = defaultEncoder.charset().newEncoder();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            this.initEncoder(charsetEncoder);
            return charsetEncoder;
        }
        if (latin1Encoder.canEncode(c)) {
            CharsetEncoder charsetEncoder = null;
            try {
                charsetEncoder = latin1Encoder.charset().newEncoder();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            this.initEncoder(charsetEncoder);
            return charsetEncoder;
        }
        for (String string : CompoundTextSupport.getEncodings()) {
            CharsetEncoder charsetEncoder = (CharsetEncoder)encodingToEncoderMap.get(string);
            if (charsetEncoder == null) {
                charsetEncoder = CompoundTextSupport.getEncoder(string);
                if (charsetEncoder == null) {
                    throw new InternalError("Unsupported encoding: " + string);
                }
                encodingToEncoderMap.put(string, charsetEncoder);
            }
            if (!charsetEncoder.canEncode(c)) continue;
            CharsetEncoder charsetEncoder2 = CompoundTextSupport.getEncoder(string);
            this.initEncoder(charsetEncoder2);
            return charsetEncoder2;
        }
        return null;
    }

    private void initEncoder(CharsetEncoder charsetEncoder) {
        try {
            charsetEncoder.onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith(this.replacement());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private CoderResult flushEncoder(CharsetEncoder charsetEncoder, ByteBuffer byteBuffer) {
        charsetEncoder.encode(this.fcb, byteBuffer, true);
        return charsetEncoder.flush(byteBuffer);
    }

    static {
        CharsetEncoder charsetEncoder = Charset.defaultCharset().newEncoder();
        String string = charsetEncoder.charset().name();
        if ("ISO8859_1".equals(string)) {
            latin1Encoder = charsetEncoder;
            defaultEncoder = charsetEncoder;
            defaultEncodingSupported = true;
        } else {
            try {
                latin1Encoder = Charset.forName("ISO8859_1").newEncoder();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ExceptionInInitializerError("ISO8859_1 unsupported");
            }
            defaultEncoder = charsetEncoder;
            defaultEncodingSupported = CompoundTextSupport.getEncodings().contains(defaultEncoder.charset().name());
        }
    }
}

