/*
 * Decompiled with CFR 0.152.
 */
package javax.management.namespace;

import com.sun.jmx.mbeanserver.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;

public class MBeanServerConnectionWrapper
implements MBeanServer {
    private final MBeanServerConnection wrapped;
    private final ClassLoader defaultCl;

    public MBeanServerConnectionWrapper(MBeanServerConnection mBeanServerConnection) {
        this(mBeanServerConnection, null);
    }

    public MBeanServerConnectionWrapper(MBeanServerConnection mBeanServerConnection, ClassLoader classLoader) {
        this.wrapped = mBeanServerConnection;
        this.defaultCl = classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader;
    }

    protected MBeanServerConnection getMBeanServerConnection() {
        return this.wrapped;
    }

    public ClassLoader getDefaultClassLoader() {
        return this.defaultCl;
    }

    protected RuntimeException wrapIOException(IOException iOException, String string) {
        return Util.newRuntimeIOException(iOException);
    }

    private synchronized MBeanServerConnection connection() throws IOException {
        MBeanServerConnection mBeanServerConnection = this.getMBeanServerConnection();
        if (mBeanServerConnection == null) {
            throw new IOException("MBeanServerConnection unavailable");
        }
        return mBeanServerConnection;
    }

    @Override
    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        try {
            this.connection().addNotificationListener(objectName, notificationListener, notificationFilter, object);
        }
        catch (IOException iOException) {
            throw this.wrapIOException(iOException, "addNotificationListener");
        }
    }

    @Override
    public void addNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        try {
            this.connection().addNotificationListener(objectName, objectName2, notificationFilter, object);
        }
        catch (IOException iOException) {
            throw this.wrapIOException(iOException, "addNotificationListener");
        }
    }

    @Override
    public ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        try {
            return this.connection().createMBean(string, objectName);
        }
        catch (IOException iOException) {
            throw this.wrapIOException(iOException, "createMBean");
        }
    }

    @Override
    public ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        try {
            return this.connection().createMBean(string, objectName, objectArray, stringArray);
        }
        catch (IOException iOException) {
            throw this.wrapIOException(iOException, "createMBean");
        }
    }

    @Override
    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        try {
            return this.connection().createMBean(string, objectName, objectName2);
        }
        catch (IOException iOException) {
            throw this.wrapIOException(iOException, "createMBean");
        }
    }

    @Override
    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        try {
            return this.connection().createMBean(string, objectName, objectName2, objectArray, stringArray);
        }
        catch (IOException iOException) {
            throw this.wrapIOException(iOException, "createMBean");
        }
    }

    @Override
    @Deprecated
    public ObjectInputStream deserialize(ObjectName objectName, byte[] byArray) throws InstanceNotFoundException, OperationsException {
        throw new UnsupportedOperationException("deserialize");
    }

    @Override
    @Deprecated
    public ObjectInputStream deserialize(String string, byte[] byArray) throws OperationsException, ReflectionException {
        throw new UnsupportedOperationException("deserialize");
    }

    @Override
    @Deprecated
    public ObjectInputStream deserialize(String string, ObjectName objectName, byte[] byArray) throws InstanceNotFoundException, OperationsException, ReflectionException {
        throw new UnsupportedOperationException("deserialize");
    }

    @Override
    public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        try {
            return this.connection().getAttribute(objectName, string);
        }
        catch (IOException iOException) {
            throw this.wrapIOException(iOException, "getAttribute");
        }
    }

    @Override
    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException {
        try {
            return this.connection().getAttributes(objectName, stringArray);
        }
        catch (IOException iOException) {
            throw this.wrapIOException(iOException, "getAttributes");
        }
    }

    @Override
    public ClassLoader getClassLoader(ObjectName objectName) throws InstanceNotFoundException {
        throw new UnsupportedOperationException("getClassLoader");
    }

    @Override
    public ClassLoader getClassLoaderFor(ObjectName objectName) throws InstanceNotFoundException {
        return this.getDefaultClassLoader();
    }

    @Override
    public ClassLoaderRepository getClassLoaderRepository() {
        return Util.getSingleClassLoaderRepository(this.getDefaultClassLoader());
    }

    @Override
    public String getDefaultDomain() {
        try {
            return this.connection().getDefaultDomain();
        }
        catch (IOException iOException) {
            throw this.wrapIOException(iOException, "getDefaultDomain");
        }
    }

    @Override
    public String[] getDomains() {
        try {
            return this.connection().getDomains();
        }
        catch (IOException iOException) {
            throw this.wrapIOException(iOException, "getDomains");
        }
    }

    @Override
    public Integer getMBeanCount() {
        try {
            return this.connection().getMBeanCount();
        }
        catch (IOException iOException) {
            throw this.wrapIOException(iOException, "getMBeanCount");
        }
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        try {
            return this.connection().getMBeanInfo(objectName);
        }
        catch (IOException iOException) {
            throw this.wrapIOException(iOException, "getMBeanInfo");
        }
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        try {
            return this.connection().getObjectInstance(objectName);
        }
        catch (IOException iOException) {
            throw this.wrapIOException(iOException, "getObjectInstance");
        }
    }

    @Override
    public Object instantiate(String string) throws ReflectionException, MBeanException {
        throw new UnsupportedOperationException("instantiate");
    }

    @Override
    public Object instantiate(String string, Object[] objectArray, String[] stringArray) throws ReflectionException, MBeanException {
        throw new UnsupportedOperationException("instantiate");
    }

    @Override
    public Object instantiate(String string, ObjectName objectName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        throw new UnsupportedOperationException("instantiate");
    }

    @Override
    public Object instantiate(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, MBeanException, InstanceNotFoundException {
        throw new UnsupportedOperationException("instantiate");
    }

    @Override
    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException {
        try {
            return this.connection().invoke(objectName, string, objectArray, stringArray);
        }
        catch (IOException iOException) {
            throw this.wrapIOException(iOException, "invoke");
        }
    }

    @Override
    public boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException {
        try {
            return this.connection().isInstanceOf(objectName, string);
        }
        catch (IOException iOException) {
            throw this.wrapIOException(iOException, "isInstanceOf");
        }
    }

    @Override
    public boolean isRegistered(ObjectName objectName) {
        try {
            return this.connection().isRegistered(objectName);
        }
        catch (IOException iOException) {
            throw this.wrapIOException(iOException, "isRegistered");
        }
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName objectName, QueryExp queryExp) {
        try {
            return this.connection().queryMBeans(objectName, queryExp);
        }
        catch (IOException iOException) {
            throw this.wrapIOException(iOException, "queryMBeans");
        }
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName objectName, QueryExp queryExp) {
        try {
            return this.connection().queryNames(objectName, queryExp);
        }
        catch (IOException iOException) {
            throw this.wrapIOException(iOException, "queryNames");
        }
    }

    @Override
    public ObjectInstance registerMBean(Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        throw new UnsupportedOperationException("registerMBean");
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        try {
            this.connection().removeNotificationListener(objectName, notificationListener);
        }
        catch (IOException iOException) {
            throw this.wrapIOException(iOException, "removeNotificationListener");
        }
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException {
        try {
            this.connection().removeNotificationListener(objectName, notificationListener, notificationFilter, object);
        }
        catch (IOException iOException) {
            throw this.wrapIOException(iOException, "removeNotificationListener");
        }
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2) throws InstanceNotFoundException, ListenerNotFoundException {
        try {
            this.connection().removeNotificationListener(objectName, objectName2);
        }
        catch (IOException iOException) {
            throw this.wrapIOException(iOException, "removeNotificationListener");
        }
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException {
        try {
            this.connection().removeNotificationListener(objectName, objectName2, notificationFilter, object);
        }
        catch (IOException iOException) {
            throw this.wrapIOException(iOException, "removeNotificationListener");
        }
    }

    @Override
    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        try {
            this.connection().setAttribute(objectName, attribute);
        }
        catch (IOException iOException) {
            throw this.wrapIOException(iOException, "setAttribute");
        }
    }

    @Override
    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        try {
            return this.connection().setAttributes(objectName, attributeList);
        }
        catch (IOException iOException) {
            throw this.wrapIOException(iOException, "setAttributes");
        }
    }

    @Override
    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        try {
            this.connection().unregisterMBean(objectName);
        }
        catch (IOException iOException) {
            throw this.wrapIOException(iOException, "unregisterMBean");
        }
    }
}

