/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import sun.swing.DefaultLookup;

public class DefaultTableCellRenderer
extends JLabel
implements TableCellRenderer,
Serializable {
    private static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    private static final Border DEFAULT_NO_FOCUS_BORDER;
    protected static Border noFocusBorder;
    private Color unselectedForeground;
    private Color unselectedBackground;

    public DefaultTableCellRenderer() {
        this.setOpaque(true);
        this.setBorder(this.getNoFocusBorder());
        this.setName("Table.cellRenderer");
    }

    private Border getNoFocusBorder() {
        Border border = DefaultLookup.getBorder(this, this.ui, "Table.cellNoFocusBorder");
        if (System.getSecurityManager() != null) {
            if (border != null) {
                return border;
            }
            return SAFE_NO_FOCUS_BORDER;
        }
        if (border != null && (noFocusBorder == null || noFocusBorder == DEFAULT_NO_FOCUS_BORDER)) {
            return border;
        }
        return noFocusBorder;
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.unselectedForeground = color;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.unselectedBackground = color;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Color color;
        Object object2;
        Color color2 = null;
        Color color3 = null;
        JTable.DropLocation dropLocation = jTable.getDropLocation();
        if (dropLocation != null && !dropLocation.isInsertRow() && !dropLocation.isInsertColumn() && dropLocation.getRow() == n && dropLocation.getColumn() == n2) {
            color2 = DefaultLookup.getColor(this, this.ui, "Table.dropCellForeground");
            color3 = DefaultLookup.getColor(this, this.ui, "Table.dropCellBackground");
            bl = true;
        }
        if (bl) {
            super.setForeground(color2 == null ? jTable.getSelectionForeground() : color2);
            super.setBackground(color3 == null ? jTable.getSelectionBackground() : color3);
        } else {
            Object object3 = object2 = this.unselectedBackground != null ? this.unselectedBackground : jTable.getBackground();
            if ((object2 == null || object2 instanceof javax.swing.plaf.UIResource) && (color = DefaultLookup.getColor(this, this.ui, "Table.alternateRowColor")) != null && n % 2 == 0) {
                object2 = color;
            }
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : jTable.getForeground());
            super.setBackground((Color)object2);
        }
        this.setFont(jTable.getFont());
        if (bl2) {
            object2 = null;
            if (bl) {
                object2 = DefaultLookup.getBorder(this, this.ui, "Table.focusSelectedCellHighlightBorder");
            }
            if (object2 == null) {
                object2 = DefaultLookup.getBorder(this, this.ui, "Table.focusCellHighlightBorder");
            }
            this.setBorder((Border)object2);
            if (!bl && jTable.isCellEditable(n, n2)) {
                color = DefaultLookup.getColor(this, this.ui, "Table.focusCellForeground");
                if (color != null) {
                    super.setForeground(color);
                }
                if ((color = DefaultLookup.getColor(this, this.ui, "Table.focusCellBackground")) != null) {
                    super.setBackground(color);
                }
            }
        } else {
            this.setBorder(this.getNoFocusBorder());
        }
        this.setValue(object);
        return this;
    }

    @Override
    public boolean isOpaque() {
        Color color = this.getBackground();
        Container container = this.getParent();
        if (container != null) {
            container = container.getParent();
        }
        boolean bl = color != null && container != null && color.equals(container.getBackground()) && container.isOpaque();
        return !bl && super.isOpaque();
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    @Override
    public void repaint(Rectangle rectangle) {
    }

    @Override
    public void repaint() {
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
        if (string == "text" || string == "labelFor" || string == "displayedMnemonic" || (string == "font" || string == "foreground") && object != object2 && this.getClientProperty("html") != null) {
            super.firePropertyChange(string, object, object2);
        }
    }

    @Override
    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }

    protected void setValue(Object object) {
        this.setText(object == null ? "" : object.toString());
    }

    static {
        noFocusBorder = DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    }

    public static class UIResource
    extends DefaultTableCellRenderer
    implements javax.swing.plaf.UIResource {
    }
}

