/*
 * Decompiled with CFR 0.152.
 */
package sun.dyn;

import java.dyn.MethodHandle;
import java.dyn.MethodType;
import java.util.Arrays;
import sun.dyn.Access;
import sun.dyn.BoundMethodHandle;
import sun.dyn.MethodHandleImpl;
import sun.dyn.MethodHandleNatives;
import sun.dyn.util.VerifyType;
import sun.dyn.util.Wrapper;

public class AdapterMethodHandle
extends BoundMethodHandle {
    private final int conversion;
    private static final Access IMPL_TOKEN = Access.getToken();

    private AdapterMethodHandle(MethodHandle methodHandle, MethodType methodType, long l, Object object) {
        super(methodType, object, methodType.parameterSlotDepth(1 + AdapterMethodHandle.convArgPos(l)));
        this.conversion = AdapterMethodHandle.convCode(l);
        if (MethodHandleNatives.JVM_SUPPORT) {
            MethodHandleNatives.init(this, methodHandle, AdapterMethodHandle.convArgPos(l));
        }
    }

    private AdapterMethodHandle(MethodHandle methodHandle, MethodType methodType, long l) {
        this(methodHandle, methodType, l, null);
    }

    public static boolean canPairwiseConvert(MethodType methodType, MethodType methodType2) {
        int n = methodType.parameterCount();
        if (n != methodType2.parameterCount()) {
            return false;
        }
        Class<?> clazz = methodType.returnType();
        Class<?> clazz2 = methodType2.returnType();
        if (!VerifyType.isNullConversion(clazz2, clazz)) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Class<?> clazz3;
            Class<?> clazz4 = methodType.parameterType(i);
            if (AdapterMethodHandle.canConvertArgument(clazz4, clazz3 = methodType2.parameterType(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean canConvertArgument(Class<?> clazz, Class<?> clazz2) {
        if (VerifyType.isNullConversion(clazz, clazz2)) {
            return true;
        }
        if (clazz.isPrimitive()) {
            if (clazz2.isPrimitive()) {
                return AdapterMethodHandle.canPrimCast(clazz, clazz2);
            }
            return AdapterMethodHandle.canBoxArgument(clazz, clazz2);
        }
        if (clazz2.isPrimitive()) {
            return AdapterMethodHandle.canUnboxArgument(clazz, clazz2);
        }
        return true;
    }

    public static MethodHandle makePairwiseConvert(Access access, MethodType methodType, MethodHandle methodHandle) {
        Object object;
        Object object2;
        int n;
        Access.check(access);
        MethodType methodType2 = methodHandle.type();
        if (methodType == methodType2) {
            return methodHandle;
        }
        if (!AdapterMethodHandle.canPairwiseConvert(methodType, methodType2)) {
            return null;
        }
        for (n = methodType.parameterCount() - 1; n >= 0 && VerifyType.isNullConversion(object2 = methodType.parameterType(n), object = methodType2.parameterType(n)); --n) {
        }
        object2 = methodHandle;
        object = methodType2.changeReturnType(methodType.returnType());
        for (int i = 0; i <= n; ++i) {
            Class<?> clazz;
            Class<?> clazz2 = methodType.parameterType(i);
            if (VerifyType.isNullConversion(clazz2, clazz = ((MethodType)object).parameterType(i))) continue;
            if (i != n) {
                object = ((MethodType)object).changeParameterType(i, clazz2);
            } else {
                assert (VerifyType.isNullConversion(methodType, ((MethodType)object).changeParameterType(i, clazz2)));
                object = methodType;
            }
            object2 = clazz2.isPrimitive() ? (clazz.isPrimitive() ? AdapterMethodHandle.makePrimCast(access, (MethodType)object, (MethodHandle)object2, i, clazz) : AdapterMethodHandle.makeBoxArgument(access, (MethodType)object, (MethodHandle)object2, i, clazz)) : (clazz.isPrimitive() ? AdapterMethodHandle.makeUnboxArgument(access, (MethodType)object, (MethodHandle)object2, i, clazz) : AdapterMethodHandle.makeCheckCast(access, (MethodType)object, (MethodHandle)object2, i, clazz));
            assert (object2 != null);
            assert (((MethodHandle)object2).type() == object);
        }
        if (((MethodHandle)object2).type() != methodType) {
            object2 = AdapterMethodHandle.makeRetypeOnly(IMPL_TOKEN, methodType, (MethodHandle)object2);
            assert (object2 != null);
            assert (n == -1);
        }
        assert (((MethodHandle)object2).type() == methodType);
        return object2;
    }

    public static MethodHandle makePermutation(Access access, MethodType methodType, MethodHandle methodHandle, int[] nArray) {
        MethodType methodType2 = methodHandle.type();
        boolean bl = true;
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n != i) {
                bl = false;
            }
            if (n >= 0 && n < methodType.parameterCount()) continue;
            nArray = new int[]{};
            break;
        }
        if (nArray.length != methodType2.parameterCount()) {
            throw MethodHandleImpl.newIllegalArgumentException("bad permutation: " + Arrays.toString(nArray));
        }
        if (bl) {
            MethodHandle methodHandle2 = AdapterMethodHandle.makePairwiseConvert(access, methodType, methodHandle);
            if (methodHandle2 == null) {
                throw MethodHandleImpl.newIllegalArgumentException("cannot convert pairwise: " + methodType);
            }
            return methodHandle2;
        }
        Class<?> clazz = methodType.returnType();
        Class<?> clazz2 = methodType2.returnType();
        if (!VerifyType.isNullConversion(clazz2, clazz)) {
            throw MethodHandleImpl.newIllegalArgumentException("bad return conversion for " + methodType);
        }
        for (int i = 0; i < nArray.length; ++i) {
            Class<?> clazz3;
            int n = nArray[i];
            Class<?> clazz4 = methodType.parameterType(n);
            if (VerifyType.isNullConversion(clazz4, clazz3 = methodType2.parameterType(i))) continue;
            throw MethodHandleImpl.newIllegalArgumentException("bad argument #" + n + " conversion for " + methodType);
        }
        throw new UnsupportedOperationException("NYI");
    }

    private static byte basicType(Class<?> clazz) {
        if (clazz == null) {
            return 14;
        }
        switch (Wrapper.forBasicType(clazz)) {
            case BOOLEAN: {
                return 4;
            }
            case CHAR: {
                return 5;
            }
            case FLOAT: {
                return 6;
            }
            case DOUBLE: {
                return 7;
            }
            case BYTE: {
                return 8;
            }
            case SHORT: {
                return 9;
            }
            case INT: {
                return 10;
            }
            case LONG: {
                return 11;
            }
            case OBJECT: {
                return 12;
            }
            case VOID: {
                return 14;
            }
        }
        return 99;
    }

    private static int type2size(int n) {
        assert (n >= 4 && n <= 12);
        return n == 6 || n == 7 ? 2 : 1;
    }

    private static long makeConv(int n, int n2, int n3, int n4) {
        assert (n3 == (n3 & 0xF));
        assert (n4 == (n4 & 0xF));
        assert (n >= 1 && n <= 4);
        long l = AdapterMethodHandle.type2size(n4) - AdapterMethodHandle.type2size(n3);
        return (long)n2 << 32 | (long)n << 8 | (long)(n3 << 16) | (long)(n4 << 12) | l << 20;
    }

    private static long makeConv(int n, int n2, int n3) {
        assert (n >= 5 && n <= 10);
        int n4 = 0;
        int n5 = 0;
        if (n >= 9 && n <= 10) {
            n5 = 12;
            n4 = 12;
        }
        return (long)n2 << 32 | (long)n << 8 | (long)(n4 << 16) | (long)(n5 << 12) | (long)(n3 << 20);
    }

    private static long makeConv(int n) {
        assert (n == 0);
        return (long)n << 8;
    }

    private static int convCode(long l) {
        return (int)l;
    }

    private static int convArgPos(long l) {
        return (int)(l >>> 32);
    }

    private static boolean convOpSupported(int n) {
        assert (n >= 0 && n <= 13);
        return (1 << n & 0x1EF) != 0;
    }

    int conversionOp() {
        return (this.conversion & 0xF00) >> 8;
    }

    @Override
    public String toString() {
        return AdapterMethodHandle.addTypeString(this, "Adapted[" + AdapterMethodHandle.basicToString(AdapterMethodHandle.nonAdapter((MethodHandle)this.vmtarget)) + "]");
    }

    private static MethodHandle nonAdapter(MethodHandle methodHandle) {
        return (MethodHandle)MethodHandleNatives.getTarget(methodHandle, 1);
    }

    private static int diffTypes(MethodType methodType, MethodType methodType2, boolean bl) {
        int n = AdapterMethodHandle.diffReturnTypes(methodType, methodType2, bl);
        if (n != 0) {
            return n;
        }
        int n2 = methodType.parameterCount();
        if (n2 != methodType2.parameterCount()) {
            return -1;
        }
        n = AdapterMethodHandle.diffParamTypes(methodType, 0, methodType2, 0, n2, bl);
        return n;
    }

    private static int diffReturnTypes(MethodType methodType, MethodType methodType2, boolean bl) {
        Class<?> clazz = methodType2.returnType();
        Class<?> clazz2 = methodType.returnType();
        if ((!bl ? VerifyType.canPassUnchecked(clazz, clazz2) : VerifyType.canPassRaw(clazz, clazz2)) > 0) {
            return 0;
        }
        if (bl && !clazz.isPrimitive() && !clazz2.isPrimitive()) {
            return 0;
        }
        return -1;
    }

    private static int diffParamTypes(MethodType methodType, int n, MethodType methodType2, int n2, int n3, boolean bl) {
        assert (n3 >= 0);
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            Class<?> clazz = methodType.parameterType(n + i);
            Class<?> clazz2 = methodType2.parameterType(n2 + i);
            if ((!bl ? VerifyType.canPassUnchecked(clazz, clazz2) : VerifyType.canPassRaw(clazz, clazz2)) > 0) continue;
            if (n4 != 0) {
                return -1 - n4;
            }
            n4 = 1 + i;
        }
        return n4;
    }

    public static boolean canRetypeOnly(MethodType methodType, MethodType methodType2) {
        return AdapterMethodHandle.canRetypeOnly(methodType, methodType2, false);
    }

    static boolean canRawRetypeOnly(MethodType methodType, MethodType methodType2) {
        return AdapterMethodHandle.canRetypeOnly(methodType, methodType2, true);
    }

    static boolean canRetypeOnly(MethodType methodType, MethodType methodType2, boolean bl) {
        if (!AdapterMethodHandle.convOpSupported(0)) {
            return false;
        }
        int n = AdapterMethodHandle.diffTypes(methodType, methodType2, bl);
        assert (n == 0 == VerifyType.isNullConversion(methodType, methodType2));
        return n == 0;
    }

    public static MethodHandle makeRetypeOnly(Access access, MethodType methodType, MethodHandle methodHandle) {
        return AdapterMethodHandle.makeRetypeOnly(access, methodType, methodHandle, false);
    }

    public static MethodHandle makeRawRetypeOnly(Access access, MethodType methodType, MethodHandle methodHandle) {
        return AdapterMethodHandle.makeRetypeOnly(access, methodType, methodHandle, true);
    }

    static MethodHandle makeRetypeOnly(Access access, MethodType methodType, MethodHandle methodHandle, boolean bl) {
        Access.check(access);
        if (!AdapterMethodHandle.canRetypeOnly(methodType, methodHandle.type(), bl)) {
            return null;
        }
        return new AdapterMethodHandle(methodHandle, methodType, AdapterMethodHandle.makeConv(0));
    }

    public static boolean canCheckCast(MethodType methodType, MethodType methodType2, int n, Class<?> clazz) {
        if (!AdapterMethodHandle.convOpSupported(1)) {
            return false;
        }
        Class<?> clazz2 = methodType.parameterType(n);
        Class<?> clazz3 = methodType2.parameterType(n);
        if (!AdapterMethodHandle.canCheckCast(clazz2, clazz) || !VerifyType.isNullConversion(clazz, clazz3)) {
            return false;
        }
        int n2 = AdapterMethodHandle.diffTypes(methodType, methodType2, false);
        return n2 == n + 1;
    }

    public static boolean canCheckCast(Class<?> clazz, Class<?> clazz2) {
        return !clazz.isPrimitive() && !clazz2.isPrimitive();
    }

    public static MethodHandle makeCheckCast(Access access, MethodType methodType, MethodHandle methodHandle, int n, Class<?> clazz) {
        Access.check(access);
        if (!AdapterMethodHandle.canCheckCast(methodType, methodHandle.type(), n, clazz)) {
            return null;
        }
        long l = AdapterMethodHandle.makeConv(1, n, 0);
        return new AdapterMethodHandle(methodHandle, methodType, l, clazz);
    }

    public static boolean canPrimCast(MethodType methodType, MethodType methodType2, int n, Class<?> clazz) {
        if (!AdapterMethodHandle.convOpSupported(2)) {
            return false;
        }
        Class<?> clazz2 = methodType.parameterType(n);
        Class<?> clazz3 = methodType2.parameterType(n);
        if (!AdapterMethodHandle.canPrimCast(clazz2, clazz) || !VerifyType.isNullConversion(clazz, clazz3)) {
            return false;
        }
        int n2 = AdapterMethodHandle.diffTypes(methodType, methodType2, false);
        return n2 == n + 1;
    }

    public static boolean canPrimCast(Class<?> clazz, Class<?> clazz2) {
        if (clazz == clazz2 || !clazz.isPrimitive() || !clazz2.isPrimitive()) {
            return false;
        }
        if (Wrapper.forPrimitiveType(clazz2).isFloating()) {
            return Wrapper.forPrimitiveType(clazz).isFloating();
        }
        assert (Wrapper.forPrimitiveType(clazz).isIntegral() && Wrapper.forPrimitiveType(clazz2).isIntegral());
        return true;
    }

    public static MethodHandle makePrimCast(Access access, MethodType methodType, MethodHandle methodHandle, int n, Class<?> clazz) {
        Access.check(access);
        MethodType methodType2 = methodHandle.type();
        Class<?> clazz2 = methodType.parameterType(n);
        Class<?> clazz3 = methodType2.parameterType(n);
        if (!AdapterMethodHandle.canPrimCast(methodType, methodType2, n, clazz)) {
            return null;
        }
        long l = AdapterMethodHandle.makeConv(2, n, AdapterMethodHandle.basicType(clazz2), AdapterMethodHandle.basicType(clazz));
        return new AdapterMethodHandle(methodHandle, methodType, l);
    }

    public static boolean canUnboxArgument(MethodType methodType, MethodType methodType2, int n, Class<?> clazz) {
        if (!AdapterMethodHandle.convOpSupported(3)) {
            return false;
        }
        Class<?> clazz2 = methodType.parameterType(n);
        Class<?> clazz3 = methodType2.parameterType(n);
        Class<?> clazz4 = Wrapper.asWrapperType(clazz);
        clazz = Wrapper.asPrimitiveType(clazz);
        if (!AdapterMethodHandle.canCheckCast(clazz2, clazz4) || clazz4 == clazz || !VerifyType.isNullConversion(clazz, clazz3)) {
            return false;
        }
        int n2 = AdapterMethodHandle.diffTypes(methodType, methodType2, false);
        return n2 == n + 1;
    }

    public static boolean canUnboxArgument(Class<?> clazz, Class<?> clazz2) {
        return !clazz.isPrimitive() && Wrapper.asPrimitiveType(clazz2).isPrimitive();
    }

    public static MethodHandle makeUnboxArgument(Access access, MethodType methodType, MethodHandle methodHandle, int n, Class<?> clazz) {
        MethodType methodType2 = methodHandle.type();
        Class<?> clazz2 = methodType.parameterType(n);
        Class<?> clazz3 = methodType2.parameterType(n);
        Class<?> clazz4 = Wrapper.asWrapperType(clazz);
        Class<?> clazz5 = Wrapper.asPrimitiveType(clazz);
        if (!AdapterMethodHandle.canUnboxArgument(methodType, methodType2, n, clazz)) {
            return null;
        }
        MethodType methodType3 = methodType;
        if (!VerifyType.isNullConversion(clazz2, clazz4)) {
            methodType3 = methodType.changeParameterType(n, clazz4);
        }
        long l = AdapterMethodHandle.makeConv(3, n, 12, AdapterMethodHandle.basicType(clazz5));
        AdapterMethodHandle adapterMethodHandle = new AdapterMethodHandle(methodHandle, methodType3, l, clazz4);
        if (methodType3 == methodType) {
            return adapterMethodHandle;
        }
        return AdapterMethodHandle.makeCheckCast(access, methodType, adapterMethodHandle, n, clazz4);
    }

    public static boolean canBoxArgument(Class<?> clazz, Class<?> clazz2) {
        if (!AdapterMethodHandle.convOpSupported(4)) {
            return false;
        }
        throw new UnsupportedOperationException("NYI");
    }

    public static MethodHandle makeBoxArgument(Access access, MethodType methodType, MethodHandle methodHandle, int n, Class<?> clazz) {
        return null;
    }

    public static boolean canDropArguments(MethodType methodType, MethodType methodType2, int n, int n2) {
        if (n2 == 0) {
            return AdapterMethodHandle.canRetypeOnly(methodType, methodType2);
        }
        if (!AdapterMethodHandle.convOpSupported(8)) {
            return false;
        }
        if (AdapterMethodHandle.diffReturnTypes(methodType, methodType2, false) != 0) {
            return false;
        }
        int n3 = methodType.parameterCount();
        if (n != 0 && AdapterMethodHandle.diffParamTypes(methodType, 0, methodType2, 0, n, false) != 0) {
            return false;
        }
        int n4 = n + n2;
        int n5 = n3 - n4;
        if (n < 0 || n >= n3 || n2 < 1 || n4 > n3 || methodType2.parameterCount() != n3 - n2) {
            return false;
        }
        return n5 == 0 || AdapterMethodHandle.diffParamTypes(methodType, n4, methodType2, n, n5, false) == 0;
    }

    public static MethodHandle makeDropArguments(Access access, MethodType methodType, MethodHandle methodHandle, int n, int n2) {
        int n3;
        Access.check(access);
        if (n2 == 0) {
            return AdapterMethodHandle.makeRetypeOnly(IMPL_TOKEN, methodType, methodHandle);
        }
        MethodType methodType2 = methodHandle.type();
        int n4 = methodType2.parameterCount();
        if (!AdapterMethodHandle.canDropArguments(methodType, methodType2, n, n2)) {
            return null;
        }
        if (n2 >= n4) {
            assert (n == n4 - 1);
            boolean bl = false;
            n3 = methodType2.parameterSlotCount();
        } else {
            int n5 = n + n2 - 1;
            int n6 = n - 1;
            int n7 = methodType2.parameterSlotDepth(1 + n5);
            int n8 = methodType2.parameterSlotDepth(1 + n6);
            n3 = n8 - n7;
            assert (n3 >= n2);
        }
        long l = AdapterMethodHandle.makeConv(8, n, n3);
        return new AdapterMethodHandle(methodHandle, methodType, (long)n3, l);
    }

    public static boolean canSpreadArguments(MethodType methodType, MethodType methodType2, Class<?> clazz, int n, int n2) {
        if (!AdapterMethodHandle.convOpSupported(10)) {
            return false;
        }
        if (AdapterMethodHandle.diffReturnTypes(methodType, methodType2, false) != 0) {
            return false;
        }
        int n3 = methodType.parameterCount();
        if (n != 0 && AdapterMethodHandle.diffParamTypes(methodType, 0, methodType2, 0, n, false) != 0) {
            return false;
        }
        int n4 = n + n2;
        int n5 = n3 - n4;
        if (n < 0 || n >= n3 || n2 < 0 || methodType2.parameterCount() != n3 - 1 + n2) {
            return false;
        }
        if (n5 != 0 && AdapterMethodHandle.diffParamTypes(methodType, n + 1, methodType2, n4, n5, false) != 0) {
            return false;
        }
        Class<?> clazz2 = methodType.parameterType(n);
        if (clazz2 != clazz && !AdapterMethodHandle.canCheckCast(clazz2, clazz)) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            Class<?> clazz3 = VerifyType.spreadArgElementType(clazz, i);
            Class<?> clazz4 = methodType2.parameterType(n + i);
            if (clazz3 != null && VerifyType.isNullConversion(clazz3, clazz4)) continue;
            return false;
        }
        return true;
    }

    public static MethodHandle makeSpreadArguments(Access access, MethodType methodType, MethodHandle methodHandle, Class<?> clazz, int n, int n2) {
        int n3;
        Access.check(access);
        MethodType methodType2 = methodHandle.type();
        int n4 = methodType2.parameterCount();
        if (!AdapterMethodHandle.canSpreadArguments(methodType, methodType2, clazz, n, n2)) {
            return null;
        }
        if (n2 >= n4) {
            assert (n == n4 - 1);
            boolean bl = false;
            n3 = methodType2.parameterSlotCount();
        } else {
            int n5 = n + n2 - 1;
            int n6 = n - 1;
            int n7 = methodType2.parameterSlotDepth(1 + n5);
            int n8 = methodType2.parameterSlotDepth(1 + n6);
            n3 = n8 - n7;
            assert (n3 >= n2);
        }
        long l = AdapterMethodHandle.makeConv(10, n, n3);
        return new AdapterMethodHandle(methodHandle, methodType, l, clazz);
    }
}

