/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pisces;

import sun.java2d.pisces.LineSink;
import sun.java2d.pisces.PiscesCache;

public class Renderer
extends LineSink {
    public static final int WIND_EVEN_ODD = 0;
    public static final int WIND_NON_ZERO = 1;
    public static final int INITIAL_EDGES = 1000;
    public static final int DEFAULT_INDICES_SIZE = 8192;
    public static final int DEFAULT_CROSSINGS_SIZE = 32768;
    private int SUBPIXEL_LG_POSITIONS_X;
    private int SUBPIXEL_LG_POSITIONS_Y;
    private int SUBPIXEL_MASK_X;
    private int SUBPIXEL_MASK_Y;
    private int SUBPIXEL_POSITIONS_X;
    private int SUBPIXEL_POSITIONS_Y;
    int MAX_AA_ALPHA;
    private int MAX_AA_ALPHA_DENOM;
    private int HALF_MAX_AA_ALPHA_DENOM;
    private int XSHIFT;
    private int YSHIFT;
    private int YSTEP;
    private int HYSTEP;
    private int YMASK;
    private static final int MIN_QUAD_OPT_WIDTH = 0x640000;
    PiscesCache cache;
    private int boundsMinX;
    private int boundsMinY;
    private int boundsMaxX;
    private int boundsMaxY;
    private int rasterMinX;
    private int rasterMaxX;
    private int rasterMinY;
    private int rasterMaxY;
    private int bboxX0;
    private int bboxY0;
    private int bboxX1;
    private int bboxY1;
    private int windingRule;
    private int x0;
    private int y0;
    private int sx0;
    private int sy0;
    private byte[] rowAA;
    private int firstOrientation;
    private int lastOrientation;
    private int flips;
    private int alphaWidth;
    private int[] edges = new int[5000];
    private int edgeIdx = 0;
    private int edgeMinY = Integer.MAX_VALUE;
    private int edgeMaxY = Integer.MIN_VALUE;
    private int[] crossingIndices;
    private int[] crossings;
    private int crossingMinY;
    private int crossingMaxY;
    private int crossingMinX = Integer.MAX_VALUE;
    private int crossingMaxX = Integer.MIN_VALUE;
    private int crossingMaxXEntries;
    private int numCrossings = 0;
    private boolean crossingsSorted = false;
    private int crossingY;
    private int crossingRowCount;
    private int crossingRowOffset;
    private int crossingRowIndex;

    public void setAntialiasing(int n, int n2) {
        this.SUBPIXEL_LG_POSITIONS_X = n;
        this.SUBPIXEL_LG_POSITIONS_Y = n2;
        this.SUBPIXEL_MASK_X = (1 << this.SUBPIXEL_LG_POSITIONS_X) - 1;
        this.SUBPIXEL_MASK_Y = (1 << this.SUBPIXEL_LG_POSITIONS_Y) - 1;
        this.SUBPIXEL_POSITIONS_X = 1 << this.SUBPIXEL_LG_POSITIONS_X;
        this.SUBPIXEL_POSITIONS_Y = 1 << this.SUBPIXEL_LG_POSITIONS_Y;
        this.MAX_AA_ALPHA = this.SUBPIXEL_POSITIONS_X * this.SUBPIXEL_POSITIONS_Y;
        this.MAX_AA_ALPHA_DENOM = 255 * this.MAX_AA_ALPHA;
        this.HALF_MAX_AA_ALPHA_DENOM = this.MAX_AA_ALPHA_DENOM / 2;
        this.XSHIFT = 16 - this.SUBPIXEL_LG_POSITIONS_X;
        this.YSHIFT = 16 - this.SUBPIXEL_LG_POSITIONS_Y;
        this.YSTEP = 1 << this.YSHIFT;
        this.HYSTEP = 1 << this.YSHIFT - 1;
        this.YMASK = ~(this.YSTEP - 1);
    }

    public int getSubpixelLgPositionsX() {
        return this.SUBPIXEL_LG_POSITIONS_X;
    }

    public int getSubpixelLgPositionsY() {
        return this.SUBPIXEL_LG_POSITIONS_Y;
    }

    public void setWindingRule(int n) {
        this.windingRule = n;
    }

    public int getWindingRule() {
        return this.windingRule;
    }

    public void beginRendering(int n, int n2, int n3, int n4) {
        this.lastOrientation = 0;
        this.flips = 0;
        this.resetEdges();
        this.boundsMinX = n << 16;
        this.boundsMinY = n2 << 16;
        this.boundsMaxX = n + n3 << 16;
        this.boundsMaxY = n2 + n4 << 16;
        this.bboxX0 = n;
        this.bboxY0 = n2;
        this.bboxX1 = n + n3;
        this.bboxY1 = n2 + n4;
    }

    @Override
    public void moveTo(int n, int n2) {
        this.close();
        this.sx0 = this.x0 = n;
        this.sy0 = this.y0 = n2;
        this.lastOrientation = 0;
    }

    @Override
    public void lineJoin() {
    }

    @Override
    public void lineTo(int n, int n2) {
        int n3;
        if (this.y0 == n2) {
            this.x0 = n;
            return;
        }
        int n4 = n3 = this.y0 < n2 ? 1 : -1;
        if (this.lastOrientation == 0) {
            this.firstOrientation = n3;
        } else if (n3 != this.lastOrientation) {
            ++this.flips;
        }
        this.lastOrientation = n3;
        this.addEdge(this.x0, this.y0 | 1, n, n2 | 1);
        this.x0 = n;
        this.y0 = n2;
    }

    @Override
    public void close() {
        int n = this.lastOrientation;
        if (this.y0 != this.sy0) {
            int n2 = n = this.y0 < this.sy0 ? 1 : -1;
        }
        if (n != this.firstOrientation) {
            ++this.flips;
        }
        this.lineTo(this.sx0, this.sy0);
    }

    @Override
    public void end() {
        this.close();
    }

    private void computeCrossingsForEdge(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = this.edges[n + 1];
        int n8 = n7 > n2 ? n7 : n2;
        int n9 = (n8 + this.HYSTEP & this.YMASK) + this.HYSTEP;
        if (n9 > (n6 = ((n5 = (n4 = this.edges[n + 3]) < n3 ? n4 : n3) - this.HYSTEP & this.YMASK) + this.HYSTEP)) {
            return;
        }
        int n10 = this.edges[n];
        int n11 = this.edges[n + 2];
        long l = (long)n11 - (long)n10;
        long l2 = (long)n4 - (long)n7;
        int n12 = this.edges[n + 4];
        int n13 = n9;
        long l3 = ((long)n13 - (long)n7) * l / l2 + (long)n10;
        this.addCrossing(n13 >> this.YSHIFT, (int)(l3 >> this.XSHIFT), n12);
        if ((n13 += this.YSTEP) > n6) {
            return;
        }
        long l4 = (long)this.YSTEP * l / l2;
        while (n13 <= n6) {
            this.addCrossing(n13 >> this.YSHIFT, (int)((l3 += l4) >> this.XSHIFT), n12);
            n13 += this.YSTEP;
        }
    }

    private void computeBounds() {
        this.rasterMinX = this.crossingMinX & ~this.SUBPIXEL_MASK_X;
        this.rasterMaxX = this.crossingMaxX | this.SUBPIXEL_MASK_X;
        this.rasterMinY = this.crossingMinY & ~this.SUBPIXEL_MASK_Y;
        this.rasterMaxY = this.crossingMaxY | this.SUBPIXEL_MASK_Y;
        if (this.rasterMinX > this.rasterMaxX || this.rasterMinY > this.rasterMaxY) {
            this.rasterMinX = 0;
            this.rasterMaxX = -1;
            this.rasterMinY = 0;
            this.rasterMaxY = -1;
            return;
        }
        if (this.rasterMinX < this.boundsMinX >> this.XSHIFT) {
            this.rasterMinX = this.boundsMinX >> this.XSHIFT;
        }
        if (this.rasterMinY < this.boundsMinY >> this.YSHIFT) {
            this.rasterMinY = this.boundsMinY >> this.YSHIFT;
        }
        if (this.rasterMaxX > this.boundsMaxX >> this.XSHIFT) {
            this.rasterMaxX = this.boundsMaxX >> this.XSHIFT;
        }
        if (this.rasterMaxY > this.boundsMaxY >> this.YSHIFT) {
            this.rasterMaxY = this.boundsMaxY >> this.YSHIFT;
        }
    }

    private int clamp(int n, int n2, int n3) {
        if (n < n2) {
            return n2;
        }
        if (n > n3) {
            return n3;
        }
        return n;
    }

    private void _endRendering() {
        int n;
        if (this.flips == 0) {
            this.bboxY0 = 0;
            this.bboxX0 = 0;
            this.bboxY1 = -1;
            this.bboxX1 = -1;
            return;
        }
        int n2 = this.edgeMinY > this.boundsMinY ? this.edgeMinY : this.boundsMinY;
        int n3 = n = this.edgeMaxY < this.boundsMaxY ? this.edgeMaxY : this.boundsMaxY;
        if (n2 > n) {
            this.bboxY0 = 0;
            this.bboxX0 = 0;
            this.bboxY1 = -1;
            this.bboxX1 = -1;
            return;
        }
        int n4 = n2 >> this.YSHIFT & ~this.SUBPIXEL_MASK_Y;
        int n5 = n >> this.YSHIFT | this.SUBPIXEL_MASK_Y;
        int n6 = n5 - n4 + 1;
        int n7 = this.flips * n6;
        int n8 = (this.boundsMaxY >> this.YSHIFT) - 1;
        if (n5 > n8) {
            n5 = n8;
        }
        this.bboxX0 = Integer.MAX_VALUE;
        this.bboxX1 = Integer.MIN_VALUE;
        this.bboxY0 = n4 >> this.SUBPIXEL_LG_POSITIONS_Y;
        this.bboxY1 = n5 + this.SUBPIXEL_POSITIONS_Y - 1 >> this.SUBPIXEL_LG_POSITIONS_Y;
        int n9 = 32768 / (this.flips * this.SUBPIXEL_POSITIONS_Y);
        n9 = Math.min(n9, n6);
        n9 = Math.max(n9, 1);
        for (int i = n4; i <= n5; i += n9 * this.SUBPIXEL_POSITIONS_Y) {
            int n10 = Math.min(i + n9 * this.SUBPIXEL_POSITIONS_Y - 1, n5);
            this.setCrossingsExtents(i, n10, this.flips);
            int n11 = i << this.YSHIFT;
            int n12 = n10 << this.YSHIFT | ~this.YMASK;
            int n13 = this.edgeIdx;
            for (int j = 0; j < n13; j += 5) {
                if (this.edges[j + 3] < n11) {
                    this.edgeIdx -= 5;
                    int n14 = this.edgeIdx;
                    int n15 = j;
                    this.edges[n15++] = this.edges[n14++];
                    this.edges[n15++] = this.edges[n14++];
                    this.edges[n15++] = this.edges[n14++];
                    this.edges[n15++] = this.edges[n14++];
                    this.edges[n15] = this.edges[n14];
                    n13 -= 5;
                    j -= 5;
                    continue;
                }
                if (this.edges[j + 1] > n12) continue;
                this.computeCrossingsForEdge(j, n11, n12);
            }
            this.computeBounds();
            if (this.rasterMaxX < this.rasterMinX) continue;
            this.bboxX0 = Math.min(this.bboxX0, this.rasterMinX >> this.SUBPIXEL_LG_POSITIONS_X);
            this.bboxX1 = Math.max(this.bboxX1, this.rasterMaxX + this.SUBPIXEL_POSITIONS_X - 1 >> this.SUBPIXEL_LG_POSITIONS_X);
            this.renderStrip();
        }
        this.crossingListFinished();
    }

    public void endRendering() {
        if (this.cache != null) {
            this.cache.bboxX0 = Integer.MAX_VALUE;
            this.cache.bboxY0 = Integer.MAX_VALUE;
            this.cache.bboxX1 = Integer.MIN_VALUE;
            this.cache.bboxY1 = Integer.MIN_VALUE;
        }
        this._endRendering();
    }

    public void getBoundingBox(int[] nArray) {
        nArray[0] = this.bboxX0;
        nArray[1] = this.bboxY0;
        nArray[2] = this.bboxX1 - this.bboxX0;
        nArray[3] = this.bboxY1 - this.bboxY0;
    }

    private void renderStrip() {
        int n;
        int n2;
        this.alphaWidth = n2 = this.rasterMaxX - this.rasterMinX + 1 >> this.SUBPIXEL_LG_POSITIONS_X;
        int n3 = n2 + 1;
        if (this.rowAA == null || this.rowAA.length < n3) {
            this.rowAA = new byte[n3];
        }
        int n4 = this.windingRule == 0 ? 1 : -1;
        int n5 = 0;
        int n6 = this.rasterMinY - 1;
        int n7 = Integer.MAX_VALUE;
        int n8 = Integer.MIN_VALUE;
        this.iterateCrossings();
        while (this.hasMoreCrossingRows()) {
            int n9;
            int n10;
            int n11;
            n5 = this.crossingY;
            for (n = n6 + 1; n < n5; ++n) {
                if ((n & this.SUBPIXEL_MASK_Y) != this.SUBPIXEL_MASK_Y && n != this.rasterMaxY) continue;
                this.emitRow(n >> this.SUBPIXEL_LG_POSITIONS_Y, 0, -1);
            }
            n6 = n5;
            if (this.crossingRowIndex < this.crossingRowCount) {
                n = this.crossings[this.crossingRowOffset + this.crossingRowIndex];
                n11 = this.crossings[this.crossingRowOffset + this.crossingRowCount - 1];
                n10 = (n >>= 1) > this.rasterMinX ? n : this.rasterMinX;
                n9 = n11 < this.rasterMaxX ? (n11 >>= 1) : this.rasterMaxX;
                n7 = Math.min(n7, (n10 -= this.rasterMinX) >> this.SUBPIXEL_LG_POSITIONS_X);
                n8 = Math.max(n8, (n9 -= this.rasterMinX) >> this.SUBPIXEL_LG_POSITIONS_X);
            }
            n = 0;
            n11 = this.rasterMinX;
            while (this.crossingRowIndex < this.crossingRowCount) {
                int n12;
                n10 = this.crossings[this.crossingRowOffset + this.crossingRowIndex];
                ++this.crossingRowIndex;
                n9 = n10 >> 1;
                int n13 = n12 = (n10 & 1) == 1 ? 1 : -1;
                if ((n & n4) != 0) {
                    int n14;
                    int n15 = n11 > this.rasterMinX ? n11 : this.rasterMinX;
                    int n16 = n14 = n9 < this.rasterMaxX ? n9 : this.rasterMaxX;
                    if (n14 > n15) {
                        int n17 = (n15 -= this.rasterMinX) >> this.SUBPIXEL_LG_POSITIONS_X;
                        int n18 = (n14 -= this.rasterMinX) - 1 >> this.SUBPIXEL_LG_POSITIONS_X;
                        if (n17 == n18) {
                            int n19 = n17;
                            this.rowAA[n19] = (byte)(this.rowAA[n19] + (n14 - n15));
                        } else {
                            int n20 = n17++;
                            this.rowAA[n20] = (byte)(this.rowAA[n20] + (this.SUBPIXEL_POSITIONS_X - (n15 & this.SUBPIXEL_MASK_X)));
                            int n21 = n14 >> this.SUBPIXEL_LG_POSITIONS_X;
                            while (n17 < n21) {
                                int n22 = n17++;
                                this.rowAA[n22] = (byte)(this.rowAA[n22] + this.SUBPIXEL_POSITIONS_X);
                            }
                            int n23 = n17;
                            this.rowAA[n23] = (byte)(this.rowAA[n23] + (n14 & this.SUBPIXEL_MASK_X));
                        }
                    }
                }
                n += n12;
                n11 = n9;
            }
            if ((n5 & this.SUBPIXEL_MASK_Y) != this.SUBPIXEL_MASK_Y && n5 != this.rasterMaxY) continue;
            this.emitRow(n5 >> this.SUBPIXEL_LG_POSITIONS_Y, n7, n8);
            n7 = Integer.MAX_VALUE;
            n8 = Integer.MIN_VALUE;
        }
        for (n = n6 + 1; n <= this.rasterMaxY; ++n) {
            if ((n & this.SUBPIXEL_MASK_Y) != this.SUBPIXEL_MASK_Y && n != this.rasterMaxY) continue;
            this.emitRow(n >> this.SUBPIXEL_LG_POSITIONS_Y, n7, n8);
            n7 = Integer.MAX_VALUE;
            n8 = Integer.MIN_VALUE;
        }
    }

    private void clearAlpha(byte[] byArray, int n, int n2, int n3) {
        if (n3 >= n2) {
            int n4 = n3 - n2 + 1;
            if (n4 + n2 > n) {
                n4 = n - n2;
            }
            int n5 = n2;
            int n6 = 0;
            while (n6 < n4) {
                byArray[n5] = 0;
                ++n6;
                ++n5;
            }
        }
    }

    private void emitRow(int n, int n2, int n3) {
        if (this.cache != null && n3 >= n2) {
            int n4 = n2 + (this.rasterMinX >> this.SUBPIXEL_LG_POSITIONS_X);
            int n5 = n3 + (this.rasterMinX >> this.SUBPIXEL_LG_POSITIONS_X);
            this.cache.startRow(n, n4, n5);
            int n6 = n2;
            byte by = this.rowAA[n6++];
            int n7 = 1;
            while (n6 <= n3) {
                byte by2;
                if ((by2 = this.rowAA[n6++]) == by && n7 < 255) {
                    ++n7;
                    continue;
                }
                this.cache.addRLERun(by, n7);
                n7 = 1;
                by = by2;
            }
            this.cache.addRLERun(by, n7);
            this.cache.addRLERun((byte)0, 0);
        }
        this.clearAlpha(this.rowAA, this.alphaWidth, n2, n3);
    }

    public void setCache(PiscesCache piscesCache) {
        this.cache = piscesCache;
    }

    private void addEdge(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = this.edgeIdx + 5;
        if (this.edges.length < n7) {
            int[] nArray = new int[Math.max(11 * this.edges.length / 10, n7)];
            System.arraycopy(this.edges, 0, nArray, 0, this.edgeIdx);
            this.edges = nArray;
        }
        int n8 = 1;
        if (n2 > n4) {
            n6 = n2;
            n2 = n4;
            n4 = n6;
            n8 = -1;
        }
        if ((n6 = n2 + this.HYSTEP & this.YMASK) > (n5 = n4 - this.HYSTEP & this.YMASK)) {
            return;
        }
        if (n8 == -1) {
            int n9 = n;
            n = n3;
            n3 = n9;
        }
        this.edges[this.edgeIdx++] = n;
        this.edges[this.edgeIdx++] = n2;
        this.edges[this.edgeIdx++] = n3;
        this.edges[this.edgeIdx++] = n4;
        this.edges[this.edgeIdx++] = n8;
        if (n2 < this.edgeMinY) {
            this.edgeMinY = n2;
        }
        if (n4 > this.edgeMaxY) {
            this.edgeMaxY = n4;
        }
    }

    private void resetEdges() {
        this.edgeIdx = 0;
        this.edgeMinY = Integer.MAX_VALUE;
        this.edgeMaxY = Integer.MIN_VALUE;
    }

    private void setCrossingsExtents(int n, int n2, int n3) {
        int n4 = n2 - n + 1;
        if (this.crossingIndices == null || this.crossingIndices.length < n4) {
            this.crossingIndices = new int[Math.max(n4, 8192)];
        }
        if (this.crossings == null || this.crossings.length < n4 * n3) {
            this.crossings = new int[Math.max(n4 * n3, 32768)];
        }
        this.crossingMinY = n;
        this.crossingMaxY = n2;
        this.crossingMaxXEntries = n3;
        this.resetCrossings();
    }

    private void resetCrossings() {
        int n = this.crossingMaxY - this.crossingMinY + 1;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            this.crossingIndices[i] = n2;
            n2 += this.crossingMaxXEntries;
        }
        this.crossingMinX = Integer.MAX_VALUE;
        this.crossingMaxX = Integer.MIN_VALUE;
        this.numCrossings = 0;
        this.crossingsSorted = false;
    }

    private void crossingListFinished() {
        if (this.crossings.length > 32768) {
            this.crossings = new int[32768];
        }
        if (this.crossingIndices.length > 8192) {
            this.crossingIndices = new int[8192];
        }
    }

    private void sortCrossings(int[] nArray, int n, int n2) {
        for (int i = n + 1; i < n + n2; ++i) {
            int n3;
            int n4;
            int n5 = nArray[n4];
            for (n4 = i; n4 > n && (n3 = nArray[n4 - 1]) > n5; --n4) {
                nArray[n4] = n3;
                nArray[n4 - 1] = n5;
            }
        }
    }

    private void sortCrossings() {
        int n = 0;
        for (int i = 0; i <= this.crossingMaxY - this.crossingMinY; ++i) {
            this.sortCrossings(this.crossings, n, this.crossingIndices[i] - n);
            n += this.crossingMaxXEntries;
        }
    }

    private void addCrossing(int n, int n2, int n3) {
        if (n2 < this.crossingMinX) {
            this.crossingMinX = n2;
        }
        if (n2 > this.crossingMaxX) {
            this.crossingMaxX = n2;
        }
        int n4 = n - this.crossingMinY;
        int n5 = this.crossingIndices[n4];
        this.crossingIndices[n4] = n5 + 1;
        int n6 = n5;
        this.crossings[n6] = n3 == 1 ? n2 | 1 : (n2 <<= 1);
        ++this.numCrossings;
    }

    private void iterateCrossings() {
        if (!this.crossingsSorted) {
            this.sortCrossings();
            this.crossingsSorted = true;
        }
        this.crossingY = this.crossingMinY - 1;
        this.crossingRowOffset = -this.crossingMaxXEntries;
    }

    private boolean hasMoreCrossingRows() {
        if (++this.crossingY <= this.crossingMaxY) {
            this.crossingRowOffset += this.crossingMaxXEntries;
            int n = this.crossingY - this.crossingMinY;
            this.crossingRowCount = this.crossingIndices[n] - n * this.crossingMaxXEntries;
            this.crossingRowIndex = 0;
            return true;
        }
        return false;
    }
}

