/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.ktab;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.security.action.GetPropertyAction;
import sun.security.krb5.Config;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.crypto.EType;
import sun.security.krb5.internal.ktab.KeyTabConstants;
import sun.security.krb5.internal.ktab.KeyTabEntry;
import sun.security.krb5.internal.ktab.KeyTabInputStream;
import sun.security.krb5.internal.ktab.KeyTabOutputStream;

public class KeyTab
implements KeyTabConstants {
    int kt_vno;
    private static KeyTab singleton = null;
    private static final boolean DEBUG = Krb5.DEBUG;
    private static String name;
    private Vector<KeyTabEntry> entries = new Vector();

    private KeyTab(String string) throws IOException, RealmException {
        this.init(string);
    }

    public static KeyTab getInstance(String string) {
        name = KeyTab.parse(string);
        if (name == null) {
            return KeyTab.getInstance();
        }
        return KeyTab.getInstance(new File(name));
    }

    public static KeyTab getInstance(File file) {
        block7: {
            try {
                if (!file.exists()) {
                    singleton = null;
                } else {
                    String string = file.getAbsolutePath();
                    if (singleton != null) {
                        File file2 = new File(name);
                        String string2 = file2.getAbsolutePath();
                        if (string2.equalsIgnoreCase(string) && DEBUG) {
                            System.out.println("KeyTab instance already exists");
                        }
                    } else {
                        singleton = new KeyTab(string);
                    }
                }
            }
            catch (Exception exception) {
                singleton = null;
                if (!DEBUG) break block7;
                System.out.println("Could not obtain an instance of KeyTab" + exception.getMessage());
            }
        }
        return singleton;
    }

    public static KeyTab getInstance() {
        block3: {
            try {
                name = KeyTab.getDefaultKeyTab();
                if (name != null) {
                    singleton = KeyTab.getInstance(new File(name));
                }
            }
            catch (Exception exception) {
                singleton = null;
                if (!DEBUG) break block3;
                System.out.println("Could not obtain an instance of KeyTab" + exception.getMessage());
            }
        }
        return singleton;
    }

    private static String getDefaultKeyTab() {
        String string;
        if (name != null) {
            return name;
        }
        String string2 = null;
        try {
            string = Config.getInstance().getDefault("default_keytab_name", "libdefaults");
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                while (stringTokenizer.hasMoreTokens() && (string2 = KeyTab.parse(stringTokenizer.nextToken())) == null) {
                }
            }
        }
        catch (KrbException krbException) {
            string2 = null;
        }
        if (string2 == null) {
            string = AccessController.doPrivileged(new GetPropertyAction("user.home"));
            if (string == null) {
                string = AccessController.doPrivileged(new GetPropertyAction("user.dir"));
            }
            if (string != null) {
                string2 = string + File.separator + "krb5.keytab";
            }
        }
        return string2;
    }

    private static String parse(String string) {
        String string2 = null;
        if (string == null) {
            return null;
        }
        string2 = string.length() >= 5 && string.substring(0, 5).equalsIgnoreCase("FILE:") ? string.substring(5) : (string.length() >= 9 && string.substring(0, 9).equalsIgnoreCase("ANY:FILE:") ? string.substring(9) : (string.length() >= 7 && string.substring(0, 7).equalsIgnoreCase("SRVTAB:") ? string.substring(7) : string));
        return string2;
    }

    private synchronized void init(String string) throws IOException, RealmException {
        if (string != null) {
            KeyTabInputStream keyTabInputStream = new KeyTabInputStream(new FileInputStream(string));
            this.load(keyTabInputStream);
            keyTabInputStream.close();
            name = string;
        }
    }

    private void load(KeyTabInputStream keyTabInputStream) throws IOException, RealmException {
        this.entries.clear();
        this.kt_vno = keyTabInputStream.readVersion();
        if (this.kt_vno == 1281) {
            keyTabInputStream.setNativeByteOrder();
        }
        int n = 0;
        while (keyTabInputStream.available() > 0) {
            n = keyTabInputStream.readEntryLength();
            KeyTabEntry keyTabEntry = keyTabInputStream.readEntry(n, this.kt_vno);
            if (DEBUG) {
                System.out.println(">>> KeyTab: load() entry length: " + n + "; type: " + (keyTabEntry != null ? keyTabEntry.keyType : 0));
            }
            if (keyTabEntry == null) continue;
            this.entries.addElement(keyTabEntry);
        }
    }

    public EncryptionKey readServiceKey(PrincipalName principalName) {
        KeyTabEntry keyTabEntry = null;
        EncryptionKey encryptionKey = null;
        if (this.entries != null) {
            for (int i = this.entries.size() - 1; i >= 0; --i) {
                keyTabEntry = this.entries.elementAt(i);
                if (!keyTabEntry.service.match(principalName)) continue;
                if (EType.isSupported(keyTabEntry.keyType)) {
                    if (encryptionKey != null && keyTabEntry.keyVersion <= encryptionKey.getKeyVersionNumber()) continue;
                    encryptionKey = new EncryptionKey(keyTabEntry.keyblock, keyTabEntry.keyType, new Integer(keyTabEntry.keyVersion));
                    continue;
                }
                if (!DEBUG) continue;
                System.out.println("Found unsupported keytype (" + keyTabEntry.keyType + ") for " + principalName);
            }
        }
        return encryptionKey;
    }

    public EncryptionKey[] readServiceKeys(PrincipalName principalName) {
        int n = this.entries.size();
        ArrayList<EncryptionKey> arrayList = new ArrayList<EncryptionKey>(n);
        if (this.entries != null) {
            for (int i = n - 1; i >= 0; --i) {
                KeyTabEntry keyTabEntry = this.entries.elementAt(i);
                if (!keyTabEntry.service.match(principalName)) continue;
                if (EType.isSupported(keyTabEntry.keyType)) {
                    EncryptionKey encryptionKey = new EncryptionKey(keyTabEntry.keyblock, keyTabEntry.keyType, new Integer(keyTabEntry.keyVersion));
                    arrayList.add(encryptionKey);
                    if (!DEBUG) continue;
                    System.out.println("Added key: " + keyTabEntry.keyType + "version: " + keyTabEntry.keyVersion);
                    continue;
                }
                if (!DEBUG) continue;
                System.out.println("Found unsupported keytype (" + keyTabEntry.keyType + ") for " + principalName);
            }
        }
        if ((n = arrayList.size()) == 0) {
            return null;
        }
        EncryptionKey[] encryptionKeyArray = arrayList.toArray(new EncryptionKey[n]);
        if (DEBUG) {
            System.out.println("Ordering keys wrt default_tkt_enctypes list");
        }
        final int[] nArray = EType.getDefaults("default_tkt_enctypes");
        Arrays.sort(encryptionKeyArray, new Comparator<EncryptionKey>(){

            @Override
            public int compare(EncryptionKey encryptionKey, EncryptionKey encryptionKey2) {
                int n;
                int n2;
                if (nArray != null && nArray != EType.getBuiltInDefaults() && (n2 = encryptionKey.getEType()) != (n = encryptionKey2.getEType())) {
                    for (int i = 0; i < nArray.length; ++i) {
                        if (nArray[i] == n2) {
                            return -1;
                        }
                        if (nArray[i] != n) continue;
                        return 1;
                    }
                }
                return encryptionKey2.getKeyVersionNumber() - encryptionKey.getKeyVersionNumber();
            }
        });
        return encryptionKeyArray;
    }

    public boolean findServiceEntry(PrincipalName principalName) {
        if (this.entries != null) {
            for (int i = 0; i < this.entries.size(); ++i) {
                KeyTabEntry keyTabEntry = this.entries.elementAt(i);
                if (!keyTabEntry.service.match(principalName)) continue;
                if (EType.isSupported(keyTabEntry.keyType)) {
                    return true;
                }
                if (!DEBUG) continue;
                System.out.println("Found unsupported keytype (" + keyTabEntry.keyType + ") for " + principalName);
            }
        }
        return false;
    }

    public static String tabName() {
        return name;
    }

    public void addEntry(PrincipalName principalName, char[] cArray) throws KrbException {
        EncryptionKey[] encryptionKeyArray = EncryptionKey.acquireSecretKeys(cArray, principalName.getSalt());
        for (int i = 0; encryptionKeyArray != null && i < encryptionKeyArray.length; ++i) {
            KeyTabEntry keyTabEntry;
            int n = encryptionKeyArray[i].getEType();
            byte[] byArray = encryptionKeyArray[i].getBytes();
            int n2 = this.retrieveEntry(principalName, n);
            int n3 = 1;
            if (n2 != -1) {
                keyTabEntry = this.entries.elementAt(n2);
                n3 = keyTabEntry.keyVersion;
                this.entries.removeElementAt(n2);
                ++n3;
            } else {
                n3 = 1;
            }
            keyTabEntry = new KeyTabEntry(principalName, principalName.getRealm(), new KerberosTime(System.currentTimeMillis()), n3, n, byArray);
            if (this.entries == null) {
                this.entries = new Vector();
            }
            this.entries.addElement(keyTabEntry);
        }
    }

    private int retrieveEntry(PrincipalName principalName, int n) {
        if (this.entries != null) {
            for (int i = 0; i < this.entries.size(); ++i) {
                KeyTabEntry keyTabEntry = this.entries.elementAt(i);
                if (!principalName.match(keyTabEntry.getService()) || n != -1 && keyTabEntry.keyType != n) continue;
                return i;
            }
        }
        return -1;
    }

    public KeyTabEntry[] getEntries() {
        if (this.entries != null) {
            KeyTabEntry[] keyTabEntryArray = new KeyTabEntry[this.entries.size()];
            for (int i = 0; i < keyTabEntryArray.length; ++i) {
                keyTabEntryArray[i] = this.entries.elementAt(i);
            }
            return keyTabEntryArray;
        }
        return null;
    }

    public static synchronized KeyTab create() throws IOException, RealmException {
        String string = KeyTab.getDefaultKeyTab();
        return KeyTab.create(string);
    }

    public static synchronized KeyTab create(String string) throws IOException, RealmException {
        KeyTabOutputStream keyTabOutputStream = new KeyTabOutputStream(new FileOutputStream(string));
        keyTabOutputStream.writeVersion(1282);
        keyTabOutputStream.close();
        singleton = new KeyTab(string);
        return singleton;
    }

    public synchronized void save() throws IOException {
        KeyTabOutputStream keyTabOutputStream = new KeyTabOutputStream(new FileOutputStream(name));
        keyTabOutputStream.writeVersion(this.kt_vno);
        for (int i = 0; i < this.entries.size(); ++i) {
            keyTabOutputStream.writeEntry(this.entries.elementAt(i));
        }
        keyTabOutputStream.close();
    }

    public int deleteEntry(PrincipalName principalName, int n) {
        int n2 = this.retrieveEntry(principalName, n);
        if (n2 != -1) {
            this.entries.removeElementAt(n2);
            return 1;
        }
        return 0;
    }

    public int deleteEntry(PrincipalName principalName) {
        int n = 0;
        while (this.deleteEntry(principalName, -1) > 0) {
            ++n;
        }
        return n;
    }

    public synchronized void createVersion(File file) throws IOException {
        KeyTabOutputStream keyTabOutputStream = new KeyTabOutputStream(new FileOutputStream(file));
        keyTabOutputStream.write16(1282);
        keyTabOutputStream.close();
    }

    public static void refresh() {
        if (singleton != null) {
            if (DEBUG) {
                System.out.println("Refreshing Keytab");
            }
            singleton = null;
        }
    }
}

