/*
 * Decompiled with CFR 0.152.
 */
package sun.security.smartcardio;

import javax.smartcardio.ATR;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardPermission;
import sun.security.smartcardio.ChannelImpl;
import sun.security.smartcardio.PCSC;
import sun.security.smartcardio.PCSCException;
import sun.security.smartcardio.TerminalImpl;

final class CardImpl
extends Card {
    private final TerminalImpl terminal;
    final long cardId;
    private final ATR atr;
    final int protocol;
    private final ChannelImpl basicChannel;
    private volatile State state;
    private volatile Thread exclusiveThread;
    private static byte[] commandOpenChannel = new byte[]{0, 112, 0, 0, 1};

    CardImpl(TerminalImpl terminalImpl, String string) throws PCSCException {
        int n;
        this.terminal = terminalImpl;
        int n2 = 2;
        if (string.equals("*")) {
            n = 3;
        } else if (string.equalsIgnoreCase("T=0")) {
            n = 1;
        } else if (string.equalsIgnoreCase("T=1")) {
            n = 2;
        } else if (string.equalsIgnoreCase("direct")) {
            n = 0;
            n2 = 3;
        } else {
            throw new IllegalArgumentException("Unsupported protocol " + string);
        }
        this.cardId = PCSC.SCardConnect(terminalImpl.contextId, terminalImpl.name, n2, n);
        byte[] byArray = new byte[2];
        byte[] byArray2 = PCSC.SCardStatus(this.cardId, byArray);
        this.atr = new ATR(byArray2);
        this.protocol = byArray[1] & 0xFF;
        this.basicChannel = new ChannelImpl(this, 0);
        this.state = State.OK;
    }

    void checkState() {
        State state = this.state;
        if (state == State.DISCONNECTED) {
            throw new IllegalStateException("Card has been disconnected");
        }
        if (state == State.REMOVED) {
            throw new IllegalStateException("Card has been removed");
        }
    }

    boolean isValid() {
        if (this.state != State.OK) {
            return false;
        }
        try {
            PCSC.SCardStatus(this.cardId, new byte[2]);
            return true;
        }
        catch (PCSCException pCSCException) {
            this.state = State.REMOVED;
            return false;
        }
    }

    private void checkSecurity(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new CardPermission(this.terminal.name, string));
        }
    }

    void handleError(PCSCException pCSCException) {
        if (pCSCException.code == -2146434967) {
            this.state = State.REMOVED;
        }
    }

    @Override
    public ATR getATR() {
        return this.atr;
    }

    @Override
    public String getProtocol() {
        switch (this.protocol) {
            case 1: {
                return "T=0";
            }
            case 2: {
                return "T=1";
            }
        }
        return "Unknown protocol " + this.protocol;
    }

    @Override
    public CardChannel getBasicChannel() {
        this.checkSecurity("getBasicChannel");
        this.checkState();
        return this.basicChannel;
    }

    private static int getSW(byte[] byArray) {
        if (byArray.length < 2) {
            return -1;
        }
        int n = byArray[byArray.length - 2] & 0xFF;
        int n2 = byArray[byArray.length - 1] & 0xFF;
        return n << 8 | n2;
    }

    @Override
    public CardChannel openLogicalChannel() throws CardException {
        this.checkSecurity("openLogicalChannel");
        this.checkState();
        this.checkExclusive();
        try {
            byte[] byArray = PCSC.SCardTransmit(this.cardId, this.protocol, commandOpenChannel, 0, commandOpenChannel.length);
            if (byArray.length != 3 || CardImpl.getSW(byArray) != 36864) {
                throw new CardException("openLogicalChannel() failed, card response: " + PCSC.toString(byArray));
            }
            return new ChannelImpl(this, byArray[0]);
        }
        catch (PCSCException pCSCException) {
            this.handleError(pCSCException);
            throw new CardException("openLogicalChannel() failed", pCSCException);
        }
    }

    void checkExclusive() throws CardException {
        Thread thread = this.exclusiveThread;
        if (thread == null) {
            return;
        }
        if (thread != Thread.currentThread()) {
            throw new CardException("Exclusive access established by another Thread");
        }
    }

    @Override
    public synchronized void beginExclusive() throws CardException {
        this.checkSecurity("exclusive");
        this.checkState();
        if (this.exclusiveThread != null) {
            throw new CardException("Exclusive access has already been assigned to Thread " + this.exclusiveThread.getName());
        }
        try {
            PCSC.SCardBeginTransaction(this.cardId);
        }
        catch (PCSCException pCSCException) {
            this.handleError(pCSCException);
            throw new CardException("beginExclusive() failed", pCSCException);
        }
        this.exclusiveThread = Thread.currentThread();
    }

    @Override
    public synchronized void endExclusive() throws CardException {
        this.checkState();
        if (this.exclusiveThread != Thread.currentThread()) {
            throw new IllegalStateException("Exclusive access not assigned to current Thread");
        }
        try {
            PCSC.SCardEndTransaction(this.cardId, 0);
        }
        catch (PCSCException pCSCException) {
            this.handleError(pCSCException);
            throw new CardException("beginExclusive() failed", pCSCException);
        }
        finally {
            this.exclusiveThread = null;
        }
    }

    @Override
    public byte[] transmitControlCommand(int n, byte[] byArray) throws CardException {
        this.checkSecurity("transmitControl");
        this.checkState();
        this.checkExclusive();
        if (byArray == null) {
            throw new NullPointerException();
        }
        try {
            byte[] byArray2 = PCSC.SCardControl(this.cardId, n, byArray);
            return byArray2;
        }
        catch (PCSCException pCSCException) {
            this.handleError(pCSCException);
            throw new CardException("transmitControlCommand() failed", pCSCException);
        }
    }

    @Override
    public void disconnect(boolean bl) throws CardException {
        if (bl) {
            this.checkSecurity("reset");
        }
        if (this.state != State.OK) {
            return;
        }
        this.checkExclusive();
        try {
            PCSC.SCardDisconnect(this.cardId, bl ? 0 : 1);
        }
        catch (PCSCException pCSCException) {
            throw new CardException("disconnect() failed", pCSCException);
        }
        finally {
            this.state = State.DISCONNECTED;
            this.exclusiveThread = null;
        }
    }

    public String toString() {
        return "PC/SC card in " + this.terminal.getName() + ", protocol " + this.getProtocol() + ", state " + (Object)((Object)this.state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.state == State.OK) {
                PCSC.SCardDisconnect(this.cardId, 0);
            }
        }
        finally {
            super.finalize();
        }
    }

    private static enum State {
        OK,
        REMOVED,
        DISCONNECTED;

    }
}

