/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jcodings.Encoding;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Numeric;
import org.jruby.util.StringSupport;

@JRubyClass(name={"Integer"}, parent="Numeric", include={"Precision"})
public abstract class RubyInteger
extends RubyNumeric {
    static final ByteList[] SINGLE_CHAR_BYTELISTS = new ByteList[256];

    public static RubyClass createIntegerClass(Ruby runtime2) {
        RubyClass integer = runtime2.defineClass("Integer", runtime2.getNumeric(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime2.setInteger(integer);
        integer.kindOf = new RubyModule.KindOf(){

            public boolean isKindOf(IRubyObject obj, RubyModule type2) {
                return obj instanceof RubyInteger;
            }
        };
        integer.getSingletonClass().undefineMethod("new");
        if (!runtime2.is1_9()) {
            integer.includeModule(runtime2.getPrecision());
        }
        integer.defineAnnotatedMethods(RubyInteger.class);
        return integer;
    }

    public RubyInteger(Ruby runtime2, RubyClass rubyClass) {
        super(runtime2, rubyClass);
    }

    public RubyInteger(RubyClass rubyClass) {
        super(rubyClass);
    }

    public RubyInteger(Ruby runtime2, RubyClass rubyClass, boolean useObjectSpace) {
        super(runtime2, rubyClass, useObjectSpace);
    }

    public RubyInteger(Ruby runtime2, RubyClass rubyClass, boolean useObjectSpace, boolean canBeTainted) {
        super(runtime2, rubyClass, useObjectSpace, canBeTainted);
    }

    public RubyInteger convertToInteger() {
        return this;
    }

    protected RubyFloat toFloat() {
        return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue());
    }

    @JRubyMethod(name={"integer?"})
    public IRubyObject integer_p() {
        return this.getRuntime().getTrue();
    }

    @JRubyMethod(name={"upto"}, frame=true)
    public IRubyObject upto(ThreadContext context, IRubyObject to, Block block) {
        if (this instanceof RubyFixnum && to instanceof RubyFixnum) {
            RubyInteger.fixnumUpto(context, ((RubyFixnum)this).getLongValue(), ((RubyFixnum)to).getLongValue(), block);
        } else {
            RubyInteger.duckUpto(context, this, to, block);
        }
        return this;
    }

    private static void fixnumUpto(ThreadContext context, long from, long to, Block block) {
        Ruby runtime2 = context.getRuntime();
        if (block.getBody().getArgumentType() == 0) {
            IRubyObject nil = runtime2.getNil();
            for (long i = from; i <= to; ++i) {
                block.yield(context, nil);
            }
        } else {
            for (long i = from; i <= to; ++i) {
                block.yield(context, RubyFixnum.newFixnum(runtime2, i));
            }
        }
    }

    private static void duckUpto(ThreadContext context, IRubyObject from, IRubyObject to, Block block) {
        Ruby runtime2 = context.getRuntime();
        IRubyObject i = from;
        RubyFixnum one = RubyFixnum.one(runtime2);
        while (!i.callMethod(context, ">", to).isTrue()) {
            block.yield(context, i);
            i = i.callMethod(context, "+", one);
        }
    }

    @JRubyMethod(name={"upto"}, frame=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject upto19(ThreadContext context, IRubyObject to, Block block) {
        return block.isGiven() ? this.upto(context, to, block) : RubyEnumerator.enumeratorize(context.getRuntime(), (IRubyObject)this, "upto", to);
    }

    @JRubyMethod(name={"downto"}, frame=true)
    public IRubyObject downto(ThreadContext context, IRubyObject to, Block block) {
        if (this instanceof RubyFixnum && to instanceof RubyFixnum) {
            RubyInteger.fixnumDownto(context, ((RubyFixnum)this).getLongValue(), ((RubyFixnum)to).getLongValue(), block);
        } else {
            RubyInteger.duckDownto(context, this, to, block);
        }
        return this;
    }

    private static void fixnumDownto(ThreadContext context, long from, long to, Block block) {
        Ruby runtime2 = context.getRuntime();
        if (block.getBody().getArgumentType() == 0) {
            IRubyObject nil = runtime2.getNil();
            for (long i = from; i >= to; --i) {
                block.yield(context, nil);
            }
        } else {
            for (long i = from; i >= to; --i) {
                block.yield(context, RubyFixnum.newFixnum(runtime2, i));
            }
        }
    }

    private static void duckDownto(ThreadContext context, IRubyObject from, IRubyObject to, Block block) {
        Ruby runtime2 = context.getRuntime();
        IRubyObject i = from;
        RubyFixnum one = RubyFixnum.one(runtime2);
        while (!i.callMethod(context, "<", to).isTrue()) {
            block.yield(context, i);
            i = i.callMethod(context, "-", one);
        }
    }

    @JRubyMethod(name={"downto"}, frame=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject downto19(ThreadContext context, IRubyObject to, Block block) {
        return block.isGiven() ? this.downto(context, to, block) : RubyEnumerator.enumeratorize(context.getRuntime(), (IRubyObject)this, "downto", to);
    }

    @JRubyMethod(name={"times"}, frame=true)
    public IRubyObject times(ThreadContext context, Block block) {
        Ruby runtime2 = context.getRuntime();
        IRubyObject i = RubyFixnum.zero(runtime2);
        RubyFixnum one = RubyFixnum.one(runtime2);
        while (i.callMethod(context, "<", this).isTrue()) {
            block.yield(context, i);
            i = i.callMethod(context, "+", one);
        }
        return this;
    }

    @JRubyMethod(name={"times"}, frame=true, compat=CompatVersion.RUBY1_9)
    public IRubyObject times19(ThreadContext context, Block block) {
        return block.isGiven() ? this.times(context, block) : RubyEnumerator.enumeratorize(context.getRuntime(), this, "times");
    }

    @JRubyMethod(name={"succ", "next"})
    public IRubyObject succ(ThreadContext context) {
        if (this instanceof RubyFixnum) {
            return RubyFixnum.newFixnum(context.getRuntime(), this.getLongValue() + 1L);
        }
        return this.callMethod(context, "+", RubyFixnum.one(context.getRuntime()));
    }

    @JRubyMethod(name={"chr"}, compat=CompatVersion.RUBY1_8)
    public RubyString chr(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        long value2 = this.getLongValue();
        if (value2 < 0L || value2 > 255L) {
            throw runtime2.newRangeError(this.toString() + " out of char range");
        }
        return RubyString.newStringShared(runtime2, SINGLE_CHAR_BYTELISTS[(int)value2]);
    }

    @JRubyMethod(name={"chr"}, compat=CompatVersion.RUBY1_9)
    public RubyString chr19(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        long value2 = this.getLongValue();
        if (value2 < 0L || value2 > 255L) {
            throw runtime2.newRangeError(this.toString() + " out of char range");
        }
        if (value2 < 128L) {
            return RubyString.newUsAsciiStringShared(runtime2, SINGLE_CHAR_BYTELISTS[(int)value2]);
        }
        return RubyString.newStringShared(runtime2, SINGLE_CHAR_BYTELISTS[(int)value2]);
    }

    @JRubyMethod(name={"chr"}, compat=CompatVersion.RUBY1_9)
    public RubyString chr19(ThreadContext context, IRubyObject arg2) {
        int n;
        Ruby runtime2 = context.getRuntime();
        long value2 = this.getLongValue();
        Encoding enc = arg2.convertToString().toEncoding(runtime2);
        if (value2 < 0L || (n = StringSupport.codeLength(runtime2, enc, (int)value2)) <= 0) {
            throw runtime2.newRangeError(this.toString() + " out of char range");
        }
        ByteList bytes2 = new ByteList(n);
        enc.codeToMbc((int)value2, bytes2.bytes, 0);
        bytes2.realSize = n;
        return RubyString.newStringNoCopy(runtime2, bytes2, enc, 0);
    }

    @JRubyMethod(name={"ord"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject ord(ThreadContext context) {
        return this;
    }

    @JRubyMethod(name={"to_i", "to_int", "floor", "ceil", "truncate"})
    public IRubyObject to_i() {
        return this;
    }

    @JRubyMethod(name={"round"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject round() {
        return this;
    }

    @JRubyMethod(name={"round"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject round19() {
        return this;
    }

    @JRubyMethod(name={"round"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject round19(ThreadContext context, IRubyObject arg2) {
        int ndigits = RubyNumeric.num2int(arg2);
        if (ndigits > 0) {
            return RubyKernel.new_float(this, this);
        }
        if (ndigits == 0) {
            return this;
        }
        ndigits = -ndigits;
        Ruby runtime2 = context.getRuntime();
        if (ndigits < 0) {
            throw runtime2.newArgumentError("ndigits out of range");
        }
        IRubyObject f = Numeric.int_pow(context, 10L, ndigits);
        if (this instanceof RubyFixnum && f instanceof RubyFixnum) {
            boolean neg;
            long x = ((RubyFixnum)this).getLongValue();
            long y = ((RubyFixnum)f).getLongValue();
            boolean bl = neg = x < 0L;
            if (neg) {
                x = -x;
            }
            x = (x + y / 2L) / y * y;
            if (neg) {
                x = -x;
            }
            return RubyFixnum.newFixnum(runtime2, x);
        }
        IRubyObject h = f.callMethod(context, "/", RubyFixnum.two(runtime2));
        IRubyObject r = this.callMethod(context, "%", f);
        IRubyObject n = this.callMethod(context, "-", r);
        if (!r.callMethod(context, "<", h).isTrue()) {
            n = n.callMethod(context, "+", f);
        }
        return n;
    }

    @JRubyMethod(name={"to_r"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject to_r(ThreadContext context) {
        return RubyRational.newRationalCanonicalize(context, this);
    }

    @JRubyMethod(name={"odd?"}, compat=CompatVersion.RUBY1_9)
    public RubyBoolean odd_p(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if (this.callMethod(context, "%", RubyFixnum.two(runtime2)) != RubyFixnum.zero(runtime2)) {
            return runtime2.getTrue();
        }
        return runtime2.getFalse();
    }

    @JRubyMethod(name={"even?"}, compat=CompatVersion.RUBY1_9)
    public RubyBoolean even_p(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if (this.callMethod(context, "%", RubyFixnum.two(runtime2)) == RubyFixnum.zero(runtime2)) {
            return runtime2.getTrue();
        }
        return runtime2.getFalse();
    }

    @JRubyMethod(name={"pred"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject pred(ThreadContext context) {
        return this.callMethod(context, "-", RubyFixnum.one(context.getRuntime()));
    }

    @JRubyMethod(name={"gcd"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject gcd(ThreadContext context, IRubyObject other) {
        return Numeric.f_gcd(context, this, RubyRational.intValue(context, other));
    }

    @JRubyMethod(name={"lcm"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject lcm(ThreadContext context, IRubyObject other) {
        return Numeric.f_lcm(context, this, RubyRational.intValue(context, other));
    }

    @JRubyMethod(name={"gcdlcm"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject gcdlcm(ThreadContext context, IRubyObject other) {
        other = RubyRational.intValue(context, other);
        return context.getRuntime().newArray(Numeric.f_gcd(context, this, other), Numeric.f_lcm(context, this, other));
    }

    @JRubyMethod(name={"numerator"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject numerator(ThreadContext context) {
        return this;
    }

    @JRubyMethod(name={"denominator"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject denominator(ThreadContext context) {
        return RubyFixnum.one(context.getRuntime());
    }

    @JRubyMethod(name={"induced_from"}, meta=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject induced_from(ThreadContext context, IRubyObject recv2, IRubyObject other) {
        if (other instanceof RubyFixnum || other instanceof RubyBignum) {
            return other;
        }
        if (other instanceof RubyFloat || other instanceof RubyRational) {
            return other.callMethod(context, "to_i");
        }
        throw recv2.getRuntime().newTypeError("failed to convert " + other.getMetaClass().getName() + " into Integer");
    }

    static {
        for (int i = 0; i < 256; ++i) {
            RubyInteger.SINGLE_CHAR_BYTELISTS[i] = new ByteList(new byte[]{(byte)i}, false);
        }
    }
}

