/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.elements;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EnumSet;
import java.util.Set;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.api.elements.FullyQualifiedElement;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.Repository;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

public abstract class PhpElementImpl
implements PhpElement {
    private static final String CLUSTER_URL = "cluster:";
    private static String clusterUrl = null;
    private final String name;
    private final String in;
    private final String fileUrl;
    private final int offset;
    private final ElementQuery elementQuery;
    private FileObject fileObject;

    PhpElementImpl(String name, String in, String fileUrl, int offset, ElementQuery elementQuery) {
        this.name = name;
        this.in = in;
        this.fileUrl = fileUrl;
        this.offset = offset;
        if (fileUrl != null && fileUrl.contains(" ")) {
            throw new IllegalArgumentException("fileURL may not contain spaces!");
        }
        this.elementQuery = elementQuery;
    }

    @Override
    public final String getFilenameUrl() {
        return this.fileUrl;
    }

    @Override
    public PhpModifiers getPhpModifiers() {
        return PhpModifiers.noModifiers();
    }

    @Override
    public final int getOffset() {
        return this.offset;
    }

    public final Set<Modifier> getModifiers() {
        return this.getPhpModifiers().toModifiers();
    }

    public OffsetRange getOffsetRange(ParserResult result) {
        return new OffsetRange(this.offset, this.offset + this.getName().length());
    }

    @Override
    public ElementQuery getElementQuery() {
        return this.elementQuery;
    }

    public synchronized FileObject getFileObject() {
        String urlStr = this.fileUrl;
        if (this.fileObject == null && this.fileUrl != null) {
            this.fileObject = PhpElementImpl.resolveFileObject(urlStr);
        }
        return this.fileObject;
    }

    public static FileObject resolveFileObject(String urlStr) {
        String url = urlStr;
        if (url.startsWith(CLUSTER_URL)) {
            clusterUrl = PhpElementImpl.getClusterUrl();
            url = clusterUrl + url.substring(CLUSTER_URL.length());
        }
        return PhpElementImpl.toFileObject(url);
    }

    public static FileObject toFileObject(String urlStr) {
        try {
            URL url = new URL(urlStr);
            return URLMapper.findFileObject((URL)url);
        }
        catch (MalformedURLException mue) {
            Exceptions.printStackTrace((Throwable)mue);
            return null;
        }
    }

    private static String getClusterUrl() {
        String retval = null;
        if (retval == null) {
            File f = InstalledFileLocator.getDefault().locate("modules/org-netbeans-modules-php-editor.jar", null, false);
            if (f == null) {
                throw new RuntimeException("Can't find cluster");
            }
            f = new File(f.getParentFile().getParentFile().getAbsolutePath());
            try {
                f = f.getCanonicalFile();
                retval = f.toURI().toURL().toExternalForm();
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
        return retval;
    }

    public final String getName() {
        return this.name;
    }

    public final String getIn() {
        return this.in;
    }

    public abstract String getSignature();

    public final boolean signatureEquals(ElementHandle handle) {
        if (handle instanceof PhpElementImpl) {
            PhpElementImpl other = (PhpElementImpl)handle;
            return this.getSignature().equals(other.getSignature());
        }
        return false;
    }

    @Override
    public final boolean isPlatform() {
        FileObject fo = this.getFileObject();
        if (fo != null) {
            try {
                return Repository.getDefault().getDefaultFileSystem().equals(fo.getFileSystem());
            }
            catch (FileStateInvalidException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return false;
    }

    public final String getMimeType() {
        return "text/x-php5";
    }

    @Override
    public final int getFlags() {
        return this.getPhpModifiers().toFlags();
    }

    public final ElementKind getKind() {
        return this.getPhpElementKind().getElementKind();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PhpElementImpl other = (PhpElementImpl)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.in == null ? other.in != null : !this.in.equals(other.in)) {
            return false;
        }
        if (this.offset != other.offset) {
            return false;
        }
        return !(this.fileUrl == null ? other.fileUrl != null : !this.fileUrl.equals(other.fileUrl));
    }

    public int hashCode() {
        int hash = 3;
        hash = 71 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 71 * hash + (this.in != null ? this.in.hashCode() : 0);
        hash = 71 * hash + (this.fileUrl != null ? this.fileUrl.hashCode() : 0);
        hash = 71 * hash + this.offset;
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPhpElementKind().toString()).append(" ");
        if (this instanceof FullyQualifiedElement) {
            sb.append(((FullyQualifiedElement)((Object)this)).getFullyQualifiedName().toString());
        } else {
            sb.append(this.getName());
        }
        return sb.toString();
    }

    static final class SEPARATOR
    extends Enum<SEPARATOR> {
        public static final /* enum */ SEPARATOR SEMICOLON = new SEPARATOR();
        public static final /* enum */ SEPARATOR COMMA = new SEPARATOR();
        public static final /* enum */ SEPARATOR COLON = new SEPARATOR();
        public static final /* enum */ SEPARATOR PIPE = new SEPARATOR();
        private static final /* synthetic */ SEPARATOR[] $VALUES;

        public static SEPARATOR[] values() {
            return (SEPARATOR[])$VALUES.clone();
        }

        public static SEPARATOR valueOf(String name) {
            return Enum.valueOf(SEPARATOR.class, name);
        }

        public static EnumSet<SEPARATOR> toEnumSet() {
            return EnumSet.allOf(SEPARATOR.class);
        }

        public String toString() {
            switch (this) {
                case SEMICOLON: {
                    return ";";
                }
                case COMMA: {
                    return ",";
                }
                case COLON: {
                    return ":";
                }
                case PIPE: {
                    return "|";
                }
            }
            assert (false);
            return super.toString();
        }

        static {
            $VALUES = new SEPARATOR[]{SEMICOLON, COMMA, COLON, PIPE};
        }
    }
}

