/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.spi.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.DLightTargetChangeEvent;
import org.netbeans.modules.dlight.api.execution.ValidationListener;
import org.netbeans.modules.dlight.api.execution.ValidationStatus;
import org.netbeans.modules.dlight.api.indicator.IndicatorDataProviderConfiguration;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.spi.indicator.IndicatorDataProvider;
import org.netbeans.modules.dlight.spi.support.TimerIDPConfiguration;
import org.netbeans.modules.dlight.util.DLightExecutorService;

public final class TimerTicker
extends IndicatorDataProvider<TimerIDPConfiguration>
implements Runnable {
    private static final DataTableMetadata TABLE_METADATA = new DataTableMetadata("time", Collections.singletonList(TimerIDPConfiguration.TIME_INFO), null);
    private final Lock lock = new Lock();
    private final IndicatorDataProviderConfiguration configuration;
    private long startTime = 0L;
    private Future<?> tickerService;

    TimerTicker(TimerIDPConfiguration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void targetStarted(DLightTarget target) {
        Lock lock = this.lock;
        synchronized (lock) {
            this.resetIndicators();
            this.tickerService = DLightExecutorService.scheduleAtFixedRate((Runnable)this, (long)1L, (TimeUnit)TimeUnit.SECONDS, (String)"TimerTicker");
            this.startTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void targetFinished(DLightTarget target) {
        Lock lock = this.lock;
        synchronized (lock) {
            this.tickerService.cancel(true);
            this.tickerService = null;
        }
    }

    @Override
    public void run() {
        DataRow data = new DataRow(TABLE_METADATA.getColumnNames(), Collections.singletonList(System.currentTimeMillis() - this.startTime));
        this.notifyIndicators(Collections.singletonList(data));
    }

    @Override
    public Collection<DataTableMetadata> getDataTablesMetadata() {
        return Collections.singletonList(TABLE_METADATA);
    }

    @Override
    public void targetStateChanged(DLightTargetChangeEvent event) {
        switch (event.state) {
            case RUNNING: {
                this.targetStarted(event.target);
                return;
            }
            case FAILED: {
                this.targetFinished(event.target);
                return;
            }
            case TERMINATED: {
                this.targetFinished(event.target);
                return;
            }
            case DONE: {
                this.targetFinished(event.target);
                return;
            }
            case STOPPED: {
                this.targetFinished(event.target);
                return;
            }
        }
    }

    @Override
    public ValidationStatus validate(DLightTarget objectToValidate) {
        return ValidationStatus.validStatus();
    }

    @Override
    public void invalidate() {
    }

    @Override
    public ValidationStatus getValidationStatus() {
        return ValidationStatus.validStatus();
    }

    @Override
    public void addValidationListener(ValidationListener listener) {
    }

    @Override
    public void removeValidationListener(ValidationListener listener) {
    }

    @Override
    public String getName() {
        return "Timer";
    }

    @Override
    public void dataFiltersChanged(List<DataFilter> newSet, boolean isAdjusting) {
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

