/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import org.netbeans.modules.cnd.debugger.common.disassembly.RegisterValue;
import org.netbeans.modules.cnd.debugger.gdb.GdbContext;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.utils.GdbUtils;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class RegistersTopComponent
extends TopComponent
implements PropertyChangeListener {
    private static RegistersTopComponent instance;
    static final String ICON_PATH = "org/netbeans/modules/cnd/debugger/common/resources/registers.png";
    private static final String PREFERRED_ID = "RegistersTopComponent";
    private final RegisterTableModel model = new RegisterTableModel();
    private JScrollPane jScrollPane1;
    private JTable jTable1;
    private static final Comparator<RegisterValue> REGISTER_COMPARATOR;

    private RegistersTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(RegistersTopComponent.class, (String)"CTL_RegistersTopComponent"));
        this.setToolTipText(NbBundle.getMessage(RegistersTopComponent.class, (String)"HINT_RegistersTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.jScrollPane1.getViewport().setBackground(UIManager.getColor("Table.background"));
        this.jTable1.setDefaultRenderer(RegisterValue.class, new RegisterCellRendererForValue());
        TableColumn col = this.jTable1.getColumnModel().getColumn(1);
        col.setCellEditor(new RegisterTableCellEditor());
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.setLayout(new BorderLayout());
        this.jTable1.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTable1);
        this.add(this.jScrollPane1, "Center");
    }

    public static synchronized RegistersTopComponent getDefault() {
        if (instance == null) {
            instance = new RegistersTopComponent();
        }
        return instance;
    }

    public static synchronized RegistersTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(RegistersTopComponent.class.getName()).warning("Cannot find RegistersTopComponent component. It will not be located properly in the window system.");
            return RegistersTopComponent.getDefault();
        }
        if (win instanceof RegistersTopComponent) {
            return (RegistersTopComponent)win;
        }
        Logger.getLogger(RegistersTopComponent.class.getName()).warning("There seem to be multiple components with the 'RegistersTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return RegistersTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
        GdbContext.getInstance().addPropertyChangeListener("Registers", this);
    }

    public void componentClosed() {
        GdbContext.getInstance().removePropertyChangeListener("Registers", this);
    }

    protected void componentShowing() {
        this.model.refresh();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.model.refresh();
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    static {
        REGISTER_COMPARATOR = new Comparator<RegisterValue>(){

            @Override
            public int compare(RegisterValue o1, RegisterValue o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
    }

    private static class RegisterCellRendererForValue
    extends DefaultTableCellRenderer.UIResource {
        private RegisterCellRendererForValue() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            RegisterValue rval;
            this.setEnabled(table == null || table.isEnabled());
            super.getTableCellRendererComponent(table, ((RegisterValue)value).getValue(), isSelected, hasFocus, row, column);
            if (value instanceof RegisterValue && (rval = (RegisterValue)value).isModified()) {
                super.setFont(this.getFont().deriveFont(1));
            }
            return this;
        }
    }

    private static class RegisterTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JComponent component = new JTextField();

        public RegisterTableCellEditor() {
            this.component.setBorder(new LineBorder(Color.black, 0));
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
            if (isSelected) {
                // empty if block
            }
            RegisterValue rv = (RegisterValue)value;
            ((JTextField)this.component).setText(rv.getValue());
            return this.component;
        }

        @Override
        public Object getCellEditorValue() {
            return ((JTextField)this.component).getText();
        }
    }

    private static class RegisterTableModel
    extends AbstractTableModel {
        private final List<RegisterValue> values = Collections.synchronizedList(new ArrayList());
        public static final int COLUMN_REGISTER = 0;
        public static final int COLUMN_VALUE = 1;
        private final String[] columnNames = new String[]{NbBundle.getMessage(RegistersTopComponent.class, (String)"LBL_REGUSAGE_REGISTER"), NbBundle.getMessage(RegistersTopComponent.class, (String)"LBL_REGUSAGE_VALUE")};
        private final Class[] types = new Class[]{String.class, RegisterValue.class};

        private RegisterTableModel() {
        }

        public Class getColumnClass(int columnIndex) {
            return this.types[columnIndex];
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.values.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            RegisterValue val = this.values.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return val.getName();
                }
                case 1: {
                    return val;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            RegisterValue val;
            RegisterValue oldVal = this.values.get(rowIndex);
            String value = (String)aValue;
            if (oldVal.getValue().equals(value)) {
                return;
            }
            GdbDebugger gdbDebugger = GdbDebugger.getGdbDebugger();
            if (gdbDebugger == null) {
                return;
            }
            String gdbValue = gdbDebugger.updateVariable("$" + oldVal.getName(), value);
            try {
                gdbValue = "0x" + Integer.toHexString(Integer.parseInt(gdbValue));
                val = new RegisterValue(oldVal.getName(), gdbValue, false);
                List cur = (List)GdbContext.getInstance().getProperty("Registers");
                cur.set(rowIndex, val);
            }
            catch (Exception e) {
                // empty catch block
            }
            val = new RegisterValue(oldVal.getName(), gdbValue, false);
            this.values.set(rowIndex, val);
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        private void refresh() {
            GdbUtils.getGdbRequestProcessor().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List res = (List)GdbContext.getInstance().getProperty("Registers");
                    List list = RegisterTableModel.this.values;
                    synchronized (list) {
                        RegisterTableModel.this.values.clear();
                        if (res != null) {
                            RegisterTableModel.this.values.addAll(res);
                        }
                        Collections.sort(RegisterTableModel.this.values, REGISTER_COMPARATOR);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RegisterTableModel.this.fireTableDataChanged();
                        }
                    });
                }
            });
        }
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return RegistersTopComponent.getDefault();
        }
    }
}

