/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.modelimpl.csm.ClassImpl;
import org.netbeans.modules.cnd.modelimpl.csm.DeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.SpecializationDescriptor;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;

public final class ClassImplSpecialization
extends ClassImpl
implements CsmTemplate {
    private CharSequence qualifiedNameSuffix = "";
    private SpecializationDescriptor specializationDesctiptor;

    private ClassImplSpecialization(AST aST, CsmFile csmFile) {
        super(null, aST, csmFile);
    }

    @Override
    protected void init(CsmScope csmScope, AST aST, boolean bl) {
        this.initScope(csmScope, aST);
        if (bl) {
            RepositoryUtils.hang(this);
        } else {
            Utils.setSelfUID(this);
        }
        this.render(aST, !bl);
        AST aST2 = AstUtil.findChildOfType(aST, 500);
        assert (aST2 != null);
        this.qualifiedNameSuffix = NameCache.getManager().getString((CharSequence)TemplateUtils.getSpecializationSuffix(aST2, this.getTemplateParameters()));
        this.initQualifiedName(csmScope, aST);
        this.specializationDesctiptor = SpecializationDescriptor.createIfNeeded(aST, this.getContainingFile(), csmScope, bl);
        if (bl) {
            this.register(this.getScope(), false);
        }
    }

    public static ClassImplSpecialization create(AST aST, CsmScope csmScope, CsmFile csmFile, boolean bl, DeclarationsContainer declarationsContainer) {
        ClassImpl classImpl = ClassImplSpecialization.findExistingClassImplInContainer(declarationsContainer, aST);
        ClassImplSpecialization classImplSpecialization = null;
        if (classImpl instanceof ClassImplSpecialization) {
            classImplSpecialization = (ClassImplSpecialization)classImpl;
        }
        if (classImplSpecialization == null) {
            classImplSpecialization = new ClassImplSpecialization(aST, csmFile);
        }
        classImplSpecialization.init(csmScope, aST, bl);
        return classImplSpecialization;
    }

    @Override
    public boolean isTemplate() {
        return true;
    }

    public boolean isSpecialization() {
        return true;
    }

    @Override
    public String getQualifiedNamePostfix() {
        return super.getQualifiedNamePostfix() + ((Object)this.qualifiedNameSuffix).toString();
    }

    public List<CsmSpecializationParameter> getSpecializationParameters() {
        return this.specializationDesctiptor != null ? this.specializationDesctiptor.getSpecializationParameters() : Collections.emptyList();
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        PersistentUtils.writeUTF(this.qualifiedNameSuffix, dataOutput);
        PersistentUtils.writeSpecializationDescriptor(this.specializationDesctiptor, dataOutput);
    }

    public ClassImplSpecialization(DataInput dataInput) throws IOException {
        super(dataInput);
        this.qualifiedNameSuffix = PersistentUtils.readUTF(dataInput, NameCache.getManager());
        this.specializationDesctiptor = PersistentUtils.readSpecializationDescriptor(dataInput);
    }

    @Override
    public String getDisplayName() {
        return this.getName() + ((Object)this.qualifiedNameSuffix).toString();
    }
}

