/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.AstRendererException;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionParameterListImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;

public class FunctionDDImpl<T>
extends FunctionImpl<T>
implements CsmFunctionDefinition {
    private final CsmCompoundStatement body;

    public FunctionDDImpl(AST aST, CsmFile csmFile, CsmScope csmScope, boolean bl) throws AstRendererException {
        super(aST, csmFile, csmScope, false, bl);
        this.body = AstRenderer.findCompoundStatement(aST, this.getContainingFile(), this);
        if (this.body == null) {
            throw new AstRendererException((FileImpl)csmFile, this.getStartOffset(), "Null body in function definition.");
        }
        if (bl) {
            this.registerInProject();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.body instanceof Disposable) {
            ((Disposable)this.body).dispose();
        }
    }

    @Override
    public CsmCompoundStatement getBody() {
        return this.body;
    }

    @Override
    public CsmFunction getDeclaration() {
        CsmFunction csmFunction;
        if (this.isCStyleStatic()) {
            CharSequence charSequence = this.getName();
            CsmSelect.CsmFilter csmFilter = CsmSelect.getFilterBuilder().createNameFilter(charSequence, true, true, false);
            Iterator iterator = CsmSelect.getStaticFunctions((CsmFile)this.getContainingFile(), (CsmSelect.CsmFilter)csmFilter);
            while (iterator.hasNext()) {
                CsmFunction csmFunction2 = (CsmFunction)iterator.next();
                if (!charSequence.equals(csmFunction2.getName())) continue;
                return csmFunction2;
            }
            return this;
        }
        String string = Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.FUNCTION) + ':' + this.getUniqueNameWithoutPrefix();
        CsmProject csmProject = this.getContainingFile().getProject();
        CsmFunction csmFunction3 = this.findDeclaration(csmProject, string);
        if (csmFunction3 != null && csmFunction3.getKind() == CsmDeclaration.Kind.FUNCTION && (!this.isStatic() || CsmKindUtilities.isClassMember((CsmObject)this) || !CsmKindUtilities.isOffsetableDeclaration((Object)csmFunction3) || this.getContainingFile().equals(((CsmOffsetableDeclaration)csmFunction3).getContainingFile()))) {
            return csmFunction3;
        }
        for (CsmProject csmProject2 : csmProject.getLibraries()) {
            csmFunction = this.findDeclaration(csmProject2, string);
            if (csmFunction == null) continue;
            return csmFunction;
        }
        if (csmFunction3 == null) {
            string = Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.FUNCTION_FRIEND) + ':' + this.getUniqueNameWithoutPrefix();
            csmFunction3 = this.findDeclaration(csmProject, string);
            if (csmFunction3 != null && csmFunction3.getKind() == CsmDeclaration.Kind.FUNCTION_FRIEND && (!this.isStatic() || CsmKindUtilities.isClassMember((CsmObject)this) || !CsmKindUtilities.isOffsetableDeclaration((Object)csmFunction3) || this.getContainingFile().equals(((CsmOffsetableDeclaration)csmFunction3).getContainingFile()))) {
                return csmFunction3;
            }
            for (CsmProject csmProject2 : csmProject.getLibraries()) {
                csmFunction = this.findDeclaration(csmProject2, string);
                if (csmFunction == null) continue;
                return csmFunction;
            }
        }
        return this;
    }

    @Override
    public boolean isPureDefinition() {
        return false;
    }

    private CsmFunction findDeclaration(CsmProject csmProject, String string) {
        CsmOffsetableDeclaration csmOffsetableDeclaration3;
        CsmOffsetableDeclaration csmOffsetableDeclaration2 = null;
        for (CsmOffsetableDeclaration csmOffsetableDeclaration3 : csmProject.findDeclarations((CharSequence)string)) {
            if (csmOffsetableDeclaration3.getKind() != CsmDeclaration.Kind.FUNCTION && csmOffsetableDeclaration3.getKind() != CsmDeclaration.Kind.FUNCTION_FRIEND) continue;
            if (csmOffsetableDeclaration2 == null) {
                csmOffsetableDeclaration2 = csmOffsetableDeclaration3;
                continue;
            }
            if (!csmOffsetableDeclaration3.getContainingFile().equals(this.getContainingFile())) continue;
            csmOffsetableDeclaration2 = csmOffsetableDeclaration3;
            break;
        }
        if (csmOffsetableDeclaration2 != null && (csmOffsetableDeclaration2.getKind() == CsmDeclaration.Kind.FUNCTION || csmOffsetableDeclaration2.getKind() == CsmDeclaration.Kind.FUNCTION_FRIEND)) {
            return (CsmFunction)csmOffsetableDeclaration2;
        }
        FunctionParameterListImpl functionParameterListImpl = this.getParameterList();
        if (functionParameterListImpl != null && !functionParameterListImpl.isEmpty() && !Utils.isCppFile((CsmFile)(csmOffsetableDeclaration3 = this.getContainingFile())) && (csmOffsetableDeclaration2 = csmProject.findDeclaration((CharSequence)(string = string.substring(0, string.indexOf(40)) + "()"))) instanceof FunctionImpl && !((FunctionImpl)csmOffsetableDeclaration2).isVoidParameterList()) {
            return (CsmFunction)csmOffsetableDeclaration2;
        }
        return null;
    }

    @Override
    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.FUNCTION_DEFINITION;
    }

    @Override
    public Collection<CsmScopeElement> getScopeElements() {
        Collection<CsmScopeElement> collection = super.getScopeElements();
        collection.add((CsmScopeElement)this.getBody());
        return collection;
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        assert (this.body != null) : "null body in " + this.getQualifiedName();
        PersistentUtils.writeCompoundStatement(this.body, dataOutput);
    }

    public FunctionDDImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.body = PersistentUtils.readCompoundStatement(dataInput);
        assert (this.body != null) : "read null body for " + this.getName();
    }
}

