/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.IDRef;
import com.sun.perseus.model.ModelEvent;
import com.sun.perseus.model.ModelNode;
import com.sun.perseus.model.Time;
import com.sun.perseus.model.TimeCondition;
import com.sun.perseus.model.TimeInstance;
import com.sun.perseus.model.TimedElementSupport;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

public class EventBaseCondition
extends TimeCondition
implements EventListener,
IDRef {
    long offset;
    Time lastEventTime = Time.UNRESOLVED;
    ModelNode eventBase;
    String eventBaseId;
    String eventType;

    public EventBaseCondition(TimedElementSupport timedElement, boolean isBegin, String eventBaseId, String eventType, long offset) {
        this(timedElement, isBegin, eventBaseId, timedElement.animationElement, eventType, offset);
    }

    protected EventBaseCondition(TimedElementSupport timedElement, boolean isBegin, String eventBaseId, ModelNode eventBase, String eventType, long offset) {
        super(timedElement, isBegin);
        if (eventType == null || eventBaseId == null && eventBase == null) {
            throw new IllegalArgumentException();
        }
        this.eventBaseId = eventBaseId;
        this.eventType = eventType;
        this.offset = offset;
        ModelNode elt = timedElement.animationElement;
        if (eventBaseId == null) {
            this.setEventBase(eventBase);
        } else {
            elt.ownerDocument.resolveIDRef(this, eventBaseId);
        }
    }

    private void setEventBase(ModelNode eventBase) {
        if (this.eventBase != null) {
            throw new IllegalStateException();
        }
        this.eventBase = eventBase;
        eventBase.ownerDocument.getEventSupport().addEventListener(eventBase, this.eventType, 1, this);
    }

    public void resolveTo(ElementNode ref) {
        this.setEventBase(ref);
    }

    public String getIdRef() {
        return this.eventBaseId;
    }

    public void handleEvent(Event evt) {
        if (this.timedElement.timeContainer.state != 5 || !((ModelEvent)evt).eventTime.isResolved()) {
            return;
        }
        Time eventTime = new Time(((ModelEvent)evt).eventTime.value);
        eventTime = this.timedElement.toContainerSimpleTime(eventTime);
        if (this.timedElement.state != 5) {
            if (this.isBegin) {
                new TimeInstance(this.timedElement, new Time(eventTime.value + this.offset), true, this.isBegin);
                this.lastEventTime = eventTime;
            }
        } else if (this.timedElement.restart == 1) {
            if (this.isBegin || !this.timedElement.hasBeginCondition(this)) {
                new TimeInstance(this.timedElement, new Time(eventTime.value + this.offset), true, this.isBegin);
                this.lastEventTime = eventTime;
            }
        } else if (!this.isBegin) {
            new TimeInstance(this.timedElement, new Time(eventTime.value + this.offset), true, this.isBegin);
            this.lastEventTime = eventTime;
        }
    }

    protected String toStringTrait() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.eventBaseId);
        sb.append('.');
        sb.append(this.eventType);
        if (this.offset != 0L) {
            if (this.offset > 0L) {
                sb.append('+');
            }
            sb.append((float)this.offset / 1000.0f);
            sb.append('s');
        }
        return sb.toString();
    }
}

