/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.bridge.exportdiff;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.search.QuickSearchComboBar;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugtracking.util.RepositoryComboSupport;
import org.netbeans.modules.versioning.util.WideButton;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AttachPanel
extends JPanel
implements ItemListener,
PropertyChangeListener {
    private QuickSearchComboBar qs;
    private PropertyChangeListener issueListener;
    private ButtonGroup buttonGroup1;
    private JLabel descriptionLabel;
    final JTextField descriptionTextField = new JTextField();
    private JLabel issueLabel;
    private JPanel issuePanel;
    private WideButton jButton2;
    private JLabel jLabel2;
    private JPanel jPanel1;
    final JComboBox repositoryComboBox = new JComboBox();
    private JLabel repositoryLabel;

    public AttachPanel(PropertyChangeListener issueListener) {
        this.initComponents();
        this.issueListener = issueListener;
        this.qs = new QuickSearchComboBar((JPanel)this);
        this.issuePanel.add((Component)this.qs, "North");
        this.issueLabel.setLabelFor(this.qs.getIssueComponent());
    }

    void init(File referenceFile) {
        if (referenceFile != null) {
            RepositoryComboSupport.setup((JComponent)this, (JComboBox)this.repositoryComboBox, (File)referenceFile);
        } else {
            RepositoryComboSupport.setup((JComponent)this, (JComboBox)this.repositoryComboBox, (boolean)false);
        }
        this.repositoryComboBox.addItemListener(this);
        this.setEnabled(false);
    }

    Issue getIssue() {
        return this.qs.getIssue();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.repositoryLabel = new JLabel();
        this.jButton2 = new WideButton();
        this.issueLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel2 = new JLabel();
        this.issuePanel = new JPanel();
        this.descriptionLabel = new JLabel();
        this.repositoryLabel.setLabelFor(this.repositoryComboBox);
        Mnemonics.setLocalizedText((JLabel)this.repositoryLabel, (String)NbBundle.getMessage(AttachPanel.class, (String)"AttachPanel.repositoryLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton2, (String)NbBundle.getMessage(AttachPanel.class, (String)"AttachPanel.jButton2.text"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttachPanel.this.jButton2ActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.issueLabel, (String)NbBundle.getMessage(AttachPanel.class, (String)"AttachPanel.issueLabel.text"));
        this.jLabel2.setForeground(UIManager.getDefaults().getColor("Button.disabledText"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(AttachPanel.class, (String)"AttachPanel.jLabel2.text"));
        this.issuePanel.setLayout(new BorderLayout());
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jLabel2).add((Component)this.issuePanel, -1, 507, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.issuePanel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jLabel2)));
        this.descriptionLabel.setLabelFor(this.descriptionTextField);
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage(AttachPanel.class, (String)"AttachPanel.descriptionLabel.text"));
        this.descriptionTextField.setColumns(30);
        this.descriptionTextField.setText(NbBundle.getMessage(AttachPanel.class, (String)"AttachPanel.descriptionTextField.text"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.repositoryLabel).add((Component)this.issueLabel).add((Component)this.descriptionLabel)).add(8, 8, 8).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.repositoryComboBox, 0, 365, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.jButton2, -2, -1, -2).add(0, 0, 0)).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((Component)this.descriptionTextField, -1, 507, Short.MAX_VALUE))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.repositoryLabel).add((Component)this.repositoryComboBox, -2, -1, -2).add((Component)this.jButton2, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -2, -1, -2).add((Component)this.issueLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.descriptionTextField, -2, -1, -2).add((Component)this.descriptionLabel))));
        this.jButton2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AttachPanel.class, (String)"AttachPanel.jButton2.AccessibleContext.accessibleDescription"));
        this.repositoryComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AttachPanel.class, (String)"AttachPanel.repositoryComboBox.AccessibleContext.accessibleDescription"));
        this.descriptionTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AttachPanel.class, (String)"AttachPanel.descriptionTextField.AccessibleContext.accessibleDescription"));
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        Repository repo = BugtrackingUtil.createRepository();
        if (repo == null) {
            return;
        }
        this.repositoryComboBox.addItem(repo);
        this.repositoryComboBox.setSelectedItem(repo);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Repository repo;
        Object item;
        this.enableFields();
        if (e.getStateChange() == 1 && (item = e.getItem()) instanceof Repository && (repo = (Repository)item) != null) {
            this.qs.setRepository(repo);
        }
    }

    @Override
    public void addNotify() {
        this.qs.addPropertyChangeListener((PropertyChangeListener)this);
        this.qs.addPropertyChangeListener(this.issueListener);
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        this.qs.removePropertyChangeListener((PropertyChangeListener)this);
        this.qs.removePropertyChangeListener(this.issueListener);
        super.removeNotify();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("QuickSearchComboBar.issue.changed")) {
            this.enableFields();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.enableFields(enabled);
        this.repositoryLabel.setEnabled(enabled);
        this.repositoryComboBox.setEnabled(enabled);
    }

    private void enableFields() {
        this.enableFields(true);
    }

    private void enableFields(boolean enable) {
        boolean repoSelected = this.repositoryComboBox.getSelectedItem() instanceof Repository;
        boolean enableFields = this.getIssue() != null && repoSelected;
        this.descriptionTextField.setEnabled(enableFields && enable);
        this.descriptionLabel.setEnabled(enableFields && enable);
        this.issueLabel.setEnabled(repoSelected && enable);
        this.qs.enableFields(repoSelected && enable);
    }
}

