/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public class ModuleUISettings {
    private static final String LAST_CHOSEN_LIBRARY_LOCATION = "lastChosenLibraryLocation";
    private static final String LAST_USED_NB_PLATFORM_LOCATION = "lastUsedNbPlatformLocation";
    private static final String NEW_MODULE_COUNTER = "newModuleCounter";
    private static final String NEW_SUITE_COUNTER = "newSuiteCounter";
    private static final String CONFIRM_RELOAD_IN_IDE = "confirmReloadInIDE";
    private static final String LAST_USED_PLATFORM_ID = "lastUsedPlatformID";
    private static final String HARNESSES_UPGRADED = "harnessesUpgraded";
    private static final String LAST_USED_CLUSTER_LOCATION = "lastUsedClusterLocation";
    private static final String SET_AS_MAIN = "setAsMain";

    public static ModuleUISettings getDefault() {
        return new ModuleUISettings();
    }

    private Preferences prefs() {
        return NbPreferences.forModule(ModuleUISettings.class);
    }

    public int getNewModuleCounter() {
        return this.prefs().getInt(NEW_MODULE_COUNTER, 0);
    }

    public void setNewModuleCounter(int count) {
        this.prefs().putInt(NEW_MODULE_COUNTER, count);
    }

    public int getNewSuiteCounter() {
        return this.prefs().getInt(NEW_SUITE_COUNTER, 0);
    }

    public void setNewSuiteCounter(int count) {
        this.prefs().putInt(NEW_SUITE_COUNTER, count);
    }

    public String getLastUsedNbPlatformLocation() {
        return this.prefs().get(LAST_USED_NB_PLATFORM_LOCATION, System.getProperty("user.home"));
    }

    public void setLastUsedNbPlatformLocation(String location) {
        assert (location != null) : "Location can not be null";
        this.prefs().put(LAST_USED_NB_PLATFORM_LOCATION, location);
    }

    public String getLastUsedClusterLocation() {
        return this.prefs().get(LAST_USED_CLUSTER_LOCATION, System.getProperty("user.home"));
    }

    public void setLastUsedClusterLocation(String location) {
        assert (location != null) : "Location can not be null";
        this.prefs().put(LAST_USED_CLUSTER_LOCATION, location);
    }

    public boolean getConfirmReloadInIDE() {
        return this.prefs().getBoolean(CONFIRM_RELOAD_IN_IDE, true);
    }

    public void setConfirmReloadInIDE(boolean b) {
        this.prefs().putBoolean(CONFIRM_RELOAD_IN_IDE, b);
    }

    public String getLastChosenLibraryLocation() {
        return this.prefs().get(LAST_CHOSEN_LIBRARY_LOCATION, System.getProperty("user.home"));
    }

    public void setLastChosenLibraryLocation(String location) {
        assert (location != null) : "Location can not be null";
        this.prefs().put(LAST_CHOSEN_LIBRARY_LOCATION, location);
    }

    public String getLastUsedPlatformID() {
        return this.prefs().get(LAST_USED_PLATFORM_ID, "default");
    }

    public void setLastUsedPlatformID(String id) {
        assert (id != null) : "Platform ID can not be null";
        this.prefs().put(LAST_USED_PLATFORM_ID, id);
    }

    public boolean getHarnessesUpgraded() {
        return this.prefs().getBoolean(HARNESSES_UPGRADED, false);
    }

    public void setHarnessesUpgraded(boolean b) {
        this.prefs().putBoolean(HARNESSES_UPGRADED, b);
    }

    public boolean getSetAsMain() {
        return this.prefs().getBoolean(SET_AS_MAIN, true);
    }

    public void setSetAsMain(boolean b) {
        this.prefs().putBoolean(SET_AS_MAIN, b);
    }
}

