/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.log;

import java.io.File;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.repository.HgURL;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public abstract class SearchHistoryAction
extends ContextAction {
    static final int DIRECTORY_ENABLED_STATUS = -8;
    static final int FILE_ENABLED_STATUS = -8;

    @Override
    protected boolean enable(Node[] nodes) {
        return HgUtils.isFromHgRepository(HgUtils.getCurrentContext(nodes));
    }

    protected static void outputSearchContextTab(File repositoryRoot, String title) {
        OutputLogger logger = SearchHistoryAction.openLogger(repositoryRoot, title);
        logger.output(NbBundle.getMessage(SearchHistoryAction.class, (String)"MSG_LOG_ROOT_CONTEXT_SEP"));
        logger.output(repositoryRoot.getAbsolutePath());
        SearchHistoryAction.closeLog(logger);
    }

    protected static void outputSearchContextTab(File repositoryRoot, File[] files, String title) {
        OutputLogger logger = SearchHistoryAction.openLogger(repositoryRoot, title);
        logger.output(NbBundle.getMessage(SearchHistoryAction.class, (String)"MSG_LOG_CONTEXT_SEP"));
        for (File f : files) {
            logger.output(f.getAbsolutePath());
        }
        SearchHistoryAction.closeLog(logger);
    }

    private static OutputLogger openLogger(File repositoryRoot, String title) {
        String loggerId = repositoryRoot != null ? new HgURL(repositoryRoot).toHgCommandUrlStringWithoutUserInfo() : null;
        OutputLogger logger = OutputLogger.getLogger(loggerId);
        logger.outputInRed(NbBundle.getMessage(SearchHistoryAction.class, (String)title));
        logger.outputInRed(NbBundle.getMessage(SearchHistoryAction.class, (String)"MSG_Log_Title_Sep"));
        return logger;
    }

    private static void closeLog(OutputLogger logger) {
        logger.outputInRed("");
        logger.closeLog();
    }

    protected File getRepositoryRoot(VCSContext context) {
        File[] roots;
        File repositoryRoot = null;
        if (context != null && (roots = HgUtils.getActionRoots(context)) != null && roots.length > 0) {
            repositoryRoot = Mercurial.getInstance().getRepositoryRoot(roots[0]);
        }
        return repositoryRoot;
    }

    protected File[] getFiles(VCSContext context, File repository) {
        File[] files = null;
        if (repository != null) {
            files = HgUtils.filterForRepository(context, repository, false);
        }
        return files;
    }
}

