/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.util;

import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public class HgProxySettings {
    private static final String PROXY_HTTP_HOST = "proxyHttpHost";
    private static final String PROXY_HTTP_PORT = "proxyHttpPort";
    private static final String PROXY_HTTPS_HOST = "proxyHttpsHost";
    private static final String PROXY_HTTPS_PORT = "proxyHttpsPort";
    private static final String NOT_PROXY_HOSTS = "proxyNonProxyHosts";
    private static final String USE_PROXY_AUTHENTICATION = "useProxyAuthentication";
    private static final String PROXY_AUTHENTICATION_USERNAME = "proxyAuthenticationUsername";
    private static final String PROXY_AUTHENTICATION_PASSWORD = "proxyAuthenticationPassword";
    private static final String PROXY_TYPE = "proxyType";
    private static final String DIRECT_CONNECTION = "0";
    private static final String AUTO_DETECT_PROXY = "1";
    private static final String MANUAL_SET_PROXY = "2";
    private String username;
    private String password;
    private String notProxyHosts;
    private boolean useAuth;
    private String httpHost;
    private String httpPort;
    private String httpsHost;
    private String httpsPort;
    private String proxyType;
    private String toString = null;

    public HgProxySettings() {
        this.init();
    }

    private void init() {
        Preferences prefs = NbPreferences.root().node("org/netbeans/core");
        this.proxyType = prefs.get(PROXY_TYPE, "");
        if (this.proxyType.equals(DIRECT_CONNECTION)) {
            this.useAuth = false;
            this.username = "";
            this.password = "";
            this.notProxyHosts = "";
            this.httpHost = "";
            this.httpPort = "";
            this.httpsHost = "";
            this.httpsPort = "";
        } else if (this.isManualSetProxy()) {
            this.useAuth = prefs.getBoolean(USE_PROXY_AUTHENTICATION, false);
            this.username = prefs.get(PROXY_AUTHENTICATION_USERNAME, "");
            this.password = prefs.get(PROXY_AUTHENTICATION_PASSWORD, "");
            this.notProxyHosts = prefs.get(NOT_PROXY_HOSTS, "").replace("|", " ,");
            this.httpHost = prefs.get(PROXY_HTTP_HOST, "");
            this.httpPort = prefs.get(PROXY_HTTP_PORT, "");
            this.httpsHost = prefs.get(PROXY_HTTPS_HOST, "");
            this.httpsPort = prefs.get(PROXY_HTTPS_PORT, "");
        } else {
            this.useAuth = false;
            this.username = "";
            this.password = "";
            this.notProxyHosts = System.getProperty("http.nonProxyHosts", "");
            this.httpHost = System.getProperty("http.proxyHost", "");
            this.httpPort = System.getProperty("http.proxyPort", "");
            this.httpsHost = System.getProperty("https.proxyHost", "");
            this.httpsPort = System.getProperty("https.proxyPort", "");
        }
    }

    public boolean isDirect() {
        return this.proxyType.equals(DIRECT_CONNECTION);
    }

    public boolean isManualSetProxy() {
        return this.proxyType.equals(MANUAL_SET_PROXY);
    }

    public boolean hasAuth() {
        return this.useAuth;
    }

    public String getHttpHost() {
        return this.httpHost;
    }

    public int getHttpPort() {
        if (this.httpPort.equals("")) {
            return 8080;
        }
        return Integer.parseInt(this.httpPort);
    }

    public String getHttpsHost() {
        return this.httpsHost;
    }

    public int getHttpsPort() {
        if (this.httpsPort.equals("")) {
            return 443;
        }
        return Integer.parseInt(this.httpsPort);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getNotProxyHosts() {
        return this.notProxyHosts;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HgProxySettings)) {
            return false;
        }
        HgProxySettings ps = (HgProxySettings)obj;
        return ps.httpHost.equals(this.httpHost) && ps.httpPort.equals(this.httpPort) && ps.httpsHost.equals(this.httpsHost) && ps.httpsPort.equals(this.httpsPort) && ps.notProxyHosts.equals(this.notProxyHosts) && ps.password.equals(this.password) && ps.proxyType.equals(this.proxyType) && ps.username.equals(this.username) && ps.useAuth == this.useAuth;
    }

    public String toString() {
        if (this.toString == null) {
            StringBuffer sb = new StringBuffer();
            sb.append("[");
            sb.append(this.httpHost);
            sb.append(",");
            sb.append(this.httpPort);
            sb.append(",");
            sb.append(this.httpsHost);
            sb.append(",");
            sb.append(this.httpsPort);
            sb.append(",");
            sb.append(this.notProxyHosts);
            sb.append(",");
            sb.append(this.password);
            sb.append(",");
            sb.append(this.proxyType);
            sb.append(",");
            sb.append(this.username);
            sb.append(",");
            sb.append(this.useAuth);
            sb.append("]");
            this.toString = sb.toString();
        }
        return this.toString;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

