/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.fs;

import java.io.File;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.remote.fs.RemoteFileSupport;
import org.netbeans.modules.cnd.remote.fs.RemoteFileSystem;
import org.netbeans.modules.cnd.remote.fs.RemoteFileSystemManager;
import org.netbeans.modules.cnd.spi.utils.FileSystemsProvider;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.EnvUtils;
import org.openide.filesystems.FileSystem;
import org.openide.util.Utilities;

public class RemoteFileSystemsProvider
extends FileSystemsProvider {
    public static final boolean USE_REMOTE_FS = CndUtils.getBoolean((String)"cnd.remote.fs", (boolean)true);

    protected FileSystemsProvider.Data getImpl(File file) {
        if (USE_REMOTE_FS) {
            return this.getImpl(file.getAbsolutePath());
        }
        return null;
    }

    protected boolean isMine(CharSequence path) {
        if (USE_REMOTE_FS) {
            String prefix = CndUtils.getIncludeFileBase();
            if (Utilities.isWindows()) {
                path = ((Object)path).toString().replace('\\', '/');
            }
            if (this.pathStartsWith(path, prefix)) {
                return true;
            }
        }
        return false;
    }

    protected FileSystemsProvider.Data getImpl(CharSequence path) {
        if (USE_REMOTE_FS) {
            CharSequence rest;
            int slashPos;
            String prefix = CndUtils.getIncludeFileBase();
            if (Utilities.isWindows()) {
                path = ((Object)path).toString().replace('\\', '/');
            }
            if (this.pathStartsWith(path, prefix) && (slashPos = CharSequenceUtils.indexOf((CharSequence)(rest = path.subSequence(prefix.length(), path.length())), (CharSequence)"/")) >= 0) {
                String hostName = ((Object)rest.subSequence(0, slashPos)).toString();
                CharSequence remotePath = rest.subSequence(slashPos + 1, rest.length());
                ExecutionEnvironment env = this.getExecutionEnvironment(hostName);
                if (env != null) {
                    RemoteFileSystem fs = RemoteFileSystemManager.getInstance().get(env);
                    FileSystemsProvider.Data data = new FileSystemsProvider.Data((FileSystem)fs, ((Object)remotePath).toString());
                    return data;
                }
            }
        }
        return null;
    }

    private boolean pathStartsWith(CharSequence path, CharSequence prefix) {
        if (CndFileUtils.isSystemCaseSensitive()) {
            return CharSequenceUtils.startsWith((CharSequence)path, (CharSequence)prefix);
        }
        return CharSequenceUtils.startsWithIgnoreCase((CharSequence)path, (CharSequence)prefix);
    }

    protected String getCaseInsensitivePathImpl(CharSequence path) {
        if (USE_REMOTE_FS) {
            String prefix = CndUtils.getIncludeFileBase();
            if (Utilities.isWindows()) {
                path = ((Object)path).toString().replace('\\', '/');
            }
            if (this.pathStartsWith(path, prefix)) {
                CharSequence start = path.subSequence(0, prefix.length());
                CharSequence rest = path.subSequence(prefix.length(), path.length());
                return start + (CndFileUtils.isSystemCaseSensitive() ? ((Object)rest).toString() : RemoteFileSupport.fixCaseSensitivePathIfNeeded(((Object)rest).toString()));
            }
        }
        return null;
    }

    private ExecutionEnvironment getExecutionEnvironment(String hostName) {
        ExecutionEnvironment result = null;
        for (ExecutionEnvironment env : ServerList.getEnvironments()) {
            if (!hostName.equals(EnvUtils.toHostID((ExecutionEnvironment)env))) continue;
            result = env;
            if (!ConnectionManager.getInstance().isConnectedTo(env)) continue;
            break;
        }
        return result;
    }
}

