/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.server;

import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.remote.mapper.RemotePathMap;
import org.netbeans.modules.cnd.remote.server.RemoteServerSetup;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncFactory;
import org.netbeans.modules.cnd.spi.remote.setup.HostSetupProvider;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.PasswordManager;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class RemoteServerRecord
implements ServerRecord {
    public static final String PROP_STATE_CHANGED = "stateChanged";
    private final ExecutionEnvironment executionEnvironment;
    private final boolean editable;
    private boolean deleted;
    private State state;
    private final Object stateLock;
    private String reason;
    private String displayName;
    private RemoteSyncFactory syncFactory;
    private boolean x11forwarding;

    @SuppressWarnings(value={"Dm"})
    RemoteServerRecord(ExecutionEnvironment env, String displayName, RemoteSyncFactory syncFactory, boolean connect) {
        CndUtils.assertTrue((env != null ? 1 : 0) != 0);
        CndUtils.assertTrue((syncFactory != null ? 1 : 0) != 0);
        this.executionEnvironment = env;
        this.syncFactory = syncFactory;
        this.stateLock = new String("RemoteServerRecord state lock for " + this.toString());
        this.reason = null;
        this.deleted = false;
        this.displayName = this.escape(displayName);
        if (env.isLocal()) {
            this.editable = false;
            this.state = State.ONLINE;
        } else {
            this.editable = true;
            this.state = connect ? State.UNINITIALIZED : State.OFFLINE;
        }
        this.x11forwarding = Boolean.getBoolean("cnd.remote.X11");
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.executionEnvironment;
    }

    public String toString() {
        return this.executionEnvironment.toString();
    }

    public synchronized void validate(boolean force) {
        if (this.isOnline()) {
            return;
        }
        RemoteUtil.LOGGER.log(Level.FINE, "RSR.validate2: Validating {0}", this.toString());
        if (force) {
            ProgressHandle ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(RemoteServerRecord.class, (String)"PBAR_ConnectingTo", (Object)this.getDisplayName()));
            ph.start();
            this.init(null);
            ph.finish();
        }
        String msg = this.isOnline() ? NbBundle.getMessage(RemoteServerRecord.class, (String)"Validation_OK", (Object)this.getDisplayName()) : NbBundle.getMessage(RemoteServerRecord.class, (String)"Validation_ERR", (Object)this.getDisplayName(), (Object)this.getStateAsText(), (Object)this.getReason());
        StatusDisplayer.getDefault().setStatusText(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void init(PropertyChangeSupport pcs) {
        assert (!SwingUtilities.isEventDispatchThread()) : "RemoteServer initialization must be done out of EDT";
        try {
            ConnectionManager.getInstance().connectTo(this.executionEnvironment);
        }
        catch (IOException ex) {
            RemoteUtil.LOGGER.log(Level.INFO, "Error connecting to " + this.executionEnvironment, ex);
            this.state = State.OFFLINE;
            this.reason = ex.getMessage();
            return;
        }
        catch (CancellationException ex) {
            this.state = State.CANCELLED;
            return;
        }
        State ostate = this.state;
        this.state = State.INITIALIZING;
        RemoteServerSetup rss = new RemoteServerSetup(this.getExecutionEnvironment());
        if (rss.needsSetupOrUpdate()) {
            rss.setup();
        }
        boolean initPathMap = false;
        Object object = this.stateLock;
        synchronized (object) {
            if (rss.isCancelled()) {
                this.state = State.CANCELLED;
            } else if (rss.isFailed()) {
                this.state = State.OFFLINE;
                this.reason = rss.getReason();
            } else {
                initPathMap = true;
                this.state = State.ONLINE;
            }
        }
        if (initPathMap) {
            RemotePathMap.getPathMap(this.getExecutionEnvironment()).init();
        }
        if (pcs != null) {
            pcs.firePropertyChange(PROP_STATE_CHANGED, (Object)ostate, (Object)this.state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resetOfflineState() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != State.INITIALIZING && this.state != State.ONLINE) {
                this.state = State.UNINITIALIZED;
                return true;
            }
        }
        return false;
    }

    public String getStateAsText() {
        return NbBundle.getMessage(RemoteServerRecord.class, (String)this.state.toString());
    }

    public boolean isOnline() {
        if (this.state == State.ONLINE && !ConnectionManager.getInstance().isConnectedTo(this.executionEnvironment)) {
            this.state = State.OFFLINE;
        }
        return this.state == State.ONLINE;
    }

    public boolean isOffline() {
        if (this.state == State.ONLINE && !ConnectionManager.getInstance().isConnectedTo(this.executionEnvironment)) {
            this.state = State.OFFLINE;
        }
        return this.state == State.OFFLINE;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isRemote() {
        return this.executionEnvironment.isRemote();
    }

    public String getDisplayName() {
        return this.displayName != null && this.displayName.length() > 0 ? this.displayName : this.executionEnvironment.getDisplayName();
    }

    String getRawDisplayName() {
        return this.displayName;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteServerRecord other = (RemoteServerRecord)obj;
        return this.executionEnvironment == other.executionEnvironment || this.executionEnvironment != null && this.executionEnvironment.equals(other.executionEnvironment);
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (this.executionEnvironment != null ? this.executionEnvironment.hashCode() : 0);
        return hash;
    }

    public String getServerDisplayName() {
        if (this.displayName == null || this.displayName.length() == 0) {
            if (this.executionEnvironment.isLocal()) {
                return "localhost";
            }
            return this.executionEnvironment.getHost();
        }
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = this.escape(displayName);
    }

    private String escape(String text) {
        if (text != null) {
            text = text.replace('|', '_');
            text = text.replace(',', '_');
        }
        return text;
    }

    public String getServerName() {
        return this.executionEnvironment.getHost();
    }

    public String getUserName() {
        return this.executionEnvironment.getUser();
    }

    public boolean isRememberPassword() {
        return PasswordManager.getInstance().isRememberPassword(this.executionEnvironment);
    }

    public void setRememberPassword(boolean rememberPassword) {
        PasswordManager.getInstance().setRememberPassword(this.executionEnvironment, rememberPassword);
    }

    public String getReason() {
        return this.reason == null ? "" : this.reason;
    }

    public RemoteSyncFactory getSyncFactory() {
        return this.syncFactory;
    }

    public void setSyncFactory(RemoteSyncFactory factory) {
        this.syncFactory = factory;
    }

    void setState(State state) {
        this.state = state;
    }

    public boolean isSetUp() {
        Collection providers = Lookup.getDefault().lookupAll(HostSetupProvider.class);
        for (HostSetupProvider provider : providers) {
            if (!provider.canCheckSetup(this.executionEnvironment)) continue;
            return provider.isSetUp(this.executionEnvironment);
        }
        return true;
    }

    public boolean setUp() {
        Collection providers = Lookup.getDefault().lookupAll(HostSetupProvider.class);
        for (HostSetupProvider provider : providers) {
            if (!provider.canCheckSetup(this.executionEnvironment)) continue;
            return provider.setUp(this.executionEnvironment);
        }
        return true;
    }

    public boolean getX11Forwarding() {
        return this.x11forwarding;
    }

    public void setX11Forwarding(boolean x11forwarding) {
        this.x11forwarding = x11forwarding;
    }

    public static enum State {
        UNINITIALIZED,
        INITIALIZING,
        ONLINE,
        OFFLINE,
        CANCELLED;

    }
}

