/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.toolchain.ui.options;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.spi.toolchain.CompilerSetFactory;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerFlavorImpl;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerSetImpl;
import org.netbeans.modules.cnd.toolchain.compilerset.CompilerSetManagerImpl;
import org.netbeans.modules.cnd.toolchain.compilerset.ToolUtils;
import org.netbeans.modules.cnd.utils.ui.FileChooser;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.remote.api.ui.FileChooserBuilder;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class AddCompilerSetPanel
extends JPanel
implements DocumentListener,
Runnable {
    private DialogDescriptor dialogDescriptor = null;
    private final CompilerSetManagerImpl csm;
    private final boolean local;
    private final Object lastFoundLock = new Object();
    private CompilerSet lastFoundRemoteCompilerSet;
    private final Object compilerCheckExecutorLock = new Object();
    private final ScheduledExecutorService compilerCheckExecutor;
    private ScheduledFuture<?> compilerCheckTask;
    private final Color defaultLbErrColor;
    private static final Logger log = Logger.getLogger("cnd.remote.logger");
    private JButton btBaseDirectory;
    private JComboBox cbFamily;
    private JLabel infoLabel;
    private JLabel lbBaseDirectory;
    private JLabel lbError;
    private JLabel lbFamily;
    private JLabel lbName;
    private JTextField tfBaseDirectory;
    private JTextField tfName;

    public AddCompilerSetPanel(CompilerSetManager csm) {
        this.initComponents();
        this.lbError.setText("");
        this.defaultLbErrColor = this.lbError.getForeground();
        this.csm = (CompilerSetManagerImpl)csm;
        this.local = ((CompilerSetManagerImpl)csm).getExecutionEnvironment().isLocal();
        List<CompilerFlavor> list = CompilerFlavorImpl.getFlavors(csm.getPlatform());
        for (CompilerFlavor cf : list) {
            this.cbFamily.addItem(cf);
        }
        this.cbFamily.addItem(CompilerFlavor.getUnknown(csm.getPlatform()));
        this.tfName.setText("");
        this.validateData();
        this.tfBaseDirectory.getDocument().addDocumentListener(this);
        this.tfName.getDocument().addDocumentListener(this);
        this.compilerCheckExecutor = Executors.newScheduledThreadPool(1);
    }

    public static CompilerSet invokeMe(CompilerSetManagerImpl csm) {
        AddCompilerSetPanel panel = new AddCompilerSetPanel(csm);
        ExecutionEnvironment execEnv = csm.getExecutionEnvironment();
        String title = execEnv.isRemote() ? NbBundle.getMessage(AddCompilerSetPanel.class, (String)"NEW_TOOL_SET_TITLE_REMOTE", (Object)ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)execEnv)) : NbBundle.getMessage(AddCompilerSetPanel.class, (String)"NEW_TOOL_SET_TITLE");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)panel, title);
        panel.setDialogDescriptor(dialogDescriptor);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        return dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION ? panel.getCompilerSet() : null;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return AddCompilerSetPanel.this.compilerCheckExecutor.shutdownNow();
            }
        });
    }

    public void setDialogDescriptor(DialogDescriptor dialogDescriptor) {
        this.dialogDescriptor = dialogDescriptor;
        dialogDescriptor.setValid(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleBaseDirUpdate() {
        if (this.dialogDescriptor != null) {
            this.dialogDescriptor.setValid(false);
        }
        this.lastFoundRemoteCompilerSet = null;
        String path = this.tfBaseDirectory.getText().trim();
        if (path.length() > 0) {
            Object object = this.compilerCheckExecutorLock;
            synchronized (object) {
                if (this.compilerCheckTask != null) {
                    log.log(Level.FINEST, "Cancelling check for {0}", path);
                    this.compilerCheckTask.cancel(true);
                }
                log.log(Level.FINEST, "Submitting check for {0}", path);
                this.compilerCheckTask = this.compilerCheckExecutor.schedule(this, this.local ? 500L : 1000L, TimeUnit.MILLISECONDS);
            }
        } else {
            this.showError(NbBundle.getMessage(this.getClass(), (String)"BASE_EMPTY"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String path = this.tfBaseDirectory.getText().trim();
        log.log(Level.FINEST, "Running check for {0}", path);
        this.showStatus(NbBundle.getMessage(this.getClass(), (String)"CHECK_IN_PROGRESS", (Object)path));
        long time = System.currentTimeMillis();
        if (path.length() == 0) {
            log.log(Level.FINEST, "Done check for {0} - the path is empty", path);
            this.showError(NbBundle.getMessage(this.getClass(), (String)"BASE_EMPTY"));
            return;
        }
        if (this.local) {
            List<CompilerFlavor> flavors = CompilerSetFactory.getCompilerSetFlavor(new File(path).getAbsolutePath(), this.csm.getPlatform());
            if (flavors.size() > 0) {
                String baseDirectory = this.getBaseDirectory();
                String compilerSetName = this.getCompilerSetName().trim();
                CompilerSet cs = CompilerSetFactory.getCustomCompilerSet(new File(baseDirectory).getAbsolutePath(), flavors.get(0), compilerSetName);
                ((CompilerSetManagerImpl)CompilerSetManager.get(ExecutionEnvironmentFactory.getLocal())).initCompilerSet(cs);
                Object object = this.lastFoundLock;
                synchronized (object) {
                    this.lastFoundRemoteCompilerSet = cs;
                }
            }
        } else {
            if (!this.checkConnection()) {
                log.log(Level.FINEST, "Done check for {0} - no connection to host", path);
                this.showError(NbBundle.getMessage(this.getClass(), (String)"CANNOT_CONNECT"));
                return;
            }
            List<CompilerSet> css = this.csm.findRemoteCompilerSets(path);
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                log.log(Level.FINEST, "Interrupted (1) check for {0}", path);
            }
            if (Thread.interrupted()) {
                log.log(Level.FINEST, "Interrupted (2) check for {0}", path);
                this.showError(NbBundle.getMessage(this.getClass(), (String)"CANCELLED"));
                return;
            }
            if (css.size() > 0) {
                Object object = this.lastFoundLock;
                synchronized (object) {
                    this.lastFoundRemoteCompilerSet = css.get(0);
                }
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AddCompilerSetPanel.this.showStatus("");
                if (AddCompilerSetPanel.this.lastFoundRemoteCompilerSet != null) {
                    AddCompilerSetPanel.this.cbFamily.setSelectedItem(AddCompilerSetPanel.this.lastFoundRemoteCompilerSet.getCompilerFlavor());
                } else {
                    AddCompilerSetPanel.this.cbFamily.setSelectedItem(CompilerFlavor.getUnknown(AddCompilerSetPanel.this.csm.getPlatform()));
                }
                AddCompilerSetPanel.this.updateDataFamily();
                if (!AddCompilerSetPanel.this.dialogDescriptor.isValid()) {
                    AddCompilerSetPanel.this.tfName.setText("");
                }
            }
        });
        if (log.isLoggable(Level.FINEST)) {
            time = System.currentTimeMillis() - time;
            log.log(Level.FINEST, "Done check for {0}; check took {1} ms", new Object[]{path, time});
        }
    }

    private boolean checkConnection() {
        if (ConnectionManager.getInstance().isConnectedTo(this.csm.getExecutionEnvironment())) {
            return true;
        }
        try {
            ConnectionManager.getInstance().connectTo(this.csm.getExecutionEnvironment());
            return true;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return false;
        }
        catch (CancellationException ex) {
            return false;
        }
    }

    private void updateBaseDirectory() {
        String seed = null;
        if (this.tfBaseDirectory.getText().length() > 0) {
            seed = this.tfBaseDirectory.getText();
        } else if (FileChooser.getCurrectChooserFile() != null) {
            seed = FileChooser.getCurrectChooserFile().getPath();
        } else {
            ExecutionEnvironment env = this.csm.getExecutionEnvironment();
            if (env.isLocal()) {
                seed = System.getProperty("user.home");
            } else if (!HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)env) && !ConnectionManager.getInstance().isConnectedTo(env)) {
                seed = null;
            } else {
                try {
                    seed = HostInfoUtils.getHostInfo((ExecutionEnvironment)env).getUserDir();
                }
                catch (IOException ex) {
                }
                catch (CancellationException ex) {
                    // empty catch block
                }
            }
        }
        JFileChooser fileChooser = new FileChooserBuilder(this.csm.getExecutionEnvironment()).createFileChooser(seed);
        fileChooser.setDialogTitle(NbBundle.getMessage(this.getClass(), (String)"SELECT_BASE_DIRECTORY_TITLE"));
        fileChooser.setFileSelectionMode(1);
        int ret = fileChooser.showOpenDialog(this);
        if (ret == 1) {
            return;
        }
        String dirPath = fileChooser.getSelectedFile().getPath();
        this.tfBaseDirectory.setText(dirPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDataFamily() {
        CompilerFlavor flavor = (CompilerFlavor)this.cbFamily.getSelectedItem();
        int n = 0;
        String suggestedName = null;
        while (this.csm.getCompilerSet(suggestedName = flavor.toString() + (n > 0 ? "_" + n : "")) != null) {
            ++n;
        }
        this.tfName.setText(suggestedName);
        Object object = this.lastFoundLock;
        synchronized (object) {
            if (this.lastFoundRemoteCompilerSet != null) {
                String compilerSetName = this.getCompilerSetName().trim();
                CompilerSetImpl cs = ((CompilerSetImpl)this.lastFoundRemoteCompilerSet).createCopy(flavor, this.lastFoundRemoteCompilerSet.getDirectory(), compilerSetName, this.lastFoundRemoteCompilerSet.isAutoGenerated(), this.lastFoundRemoteCompilerSet.getEncoding(), false);
                this.lastFoundRemoteCompilerSet = cs;
            }
        }
        this.validateData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateData() {
        boolean valid = true;
        String path = this.tfBaseDirectory.getText().trim();
        this.showStatus("");
        Object object = this.lastFoundLock;
        synchronized (object) {
            if (this.lastFoundRemoteCompilerSet == null) {
                valid = false;
                this.showError(NbBundle.getMessage(this.getClass(), (String)(path.length() == 0 ? "BASE_EMPTY" : "REMOTEBASE_INVALID"), (Object)path));
            }
        }
        this.cbFamily.setEnabled(valid);
        this.tfName.setEnabled(valid);
        String compilerSetName = ToolUtils.replaceOddCharacters(this.tfName.getText().trim(), '_');
        if (valid) {
            if (compilerSetName.length() == 0) {
                valid = false;
                this.showError(NbBundle.getMessage(this.getClass(), (String)"NAME_EMPTY"));
            } else if (compilerSetName.contains("|")) {
                valid = false;
                this.showError(NbBundle.getMessage(this.getClass(), (String)"NAME_INVALID", (Object)compilerSetName));
            }
        }
        if (valid && this.csm.getCompilerSet(compilerSetName.trim()) != null) {
            valid = false;
            this.showError(NbBundle.getMessage(this.getClass(), (String)"TOOLNAME_ALREADY_EXISTS", (Object)compilerSetName));
        }
        if (this.dialogDescriptor != null) {
            this.dialogDescriptor.setValid(valid);
        }
    }

    private void showError(String message) {
        this.lbError.setForeground(Color.RED);
        this.lbError.setText(message);
    }

    private void showStatus(String message) {
        this.lbError.setForeground(this.defaultLbErrColor);
        this.lbError.setText(message);
    }

    private void handleUpdate(DocumentEvent e) {
        if (e.getDocument() == this.tfBaseDirectory.getDocument()) {
            this.handleBaseDirUpdate();
        } else {
            this.validateData();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.handleUpdate(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.handleUpdate(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    public String getBaseDirectory() {
        return this.tfBaseDirectory.getText();
    }

    private CompilerFlavor getFamily() {
        return (CompilerFlavor)this.cbFamily.getSelectedItem();
    }

    private String getCompilerSetName() {
        return ToolUtils.replaceOddCharacters(this.tfName.getText().trim(), '_');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompilerSet getCompilerSet() {
        String compilerSetName = this.getCompilerSetName().trim();
        Object object = this.lastFoundLock;
        synchronized (object) {
            if (this.lastFoundRemoteCompilerSet != null) {
                ((CompilerSetImpl)this.lastFoundRemoteCompilerSet).setName(compilerSetName);
                return this.lastFoundRemoteCompilerSet;
            }
            return null;
        }
    }

    private void initComponents() {
        this.infoLabel = new JLabel();
        this.lbBaseDirectory = new JLabel();
        this.tfBaseDirectory = new JTextField();
        this.btBaseDirectory = new JButton();
        this.lbFamily = new JLabel();
        this.cbFamily = new JComboBox();
        this.lbName = new JLabel();
        this.tfName = new JTextField();
        this.lbError = new JLabel();
        this.setMinimumSize(new Dimension(580, 190));
        this.setPreferredSize(new Dimension(580, 190));
        this.setLayout(new GridBagLayout());
        this.infoLabel.setText(NbBundle.getMessage(AddCompilerSetPanel.class, (String)"AddCompilerSetPanel.taInfo.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 6, 12);
        this.add((Component)this.infoLabel, gridBagConstraints);
        this.lbBaseDirectory.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/toolchain/ui/options/Bundle").getString("lbBaseDirectory_MN").charAt(0));
        this.lbBaseDirectory.setLabelFor(this.tfBaseDirectory);
        this.lbBaseDirectory.setText(NbBundle.getMessage(AddCompilerSetPanel.class, (String)"AddCompilerSetPanel.lbBaseDirectory.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 6, 6);
        this.add((Component)this.lbBaseDirectory, gridBagConstraints);
        this.tfBaseDirectory.setColumns(40);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 283;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.add((Component)this.tfBaseDirectory, gridBagConstraints);
        this.tfBaseDirectory.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddCompilerSetPanel.class, (String)"AddCompilerSetPanel.tfBaseDirectory.AccessibleContext.accessibleDescription"));
        this.btBaseDirectory.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/toolchain/ui/options/Bundle").getString("btBrowse").charAt(0));
        this.btBaseDirectory.setText(NbBundle.getMessage(AddCompilerSetPanel.class, (String)"AddCompilerSetPanel.btBaseDirectory.text"));
        this.btBaseDirectory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddCompilerSetPanel.this.btBaseDirectoryActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipady = -6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 6, 6, 12);
        this.add((Component)this.btBaseDirectory, gridBagConstraints);
        this.lbFamily.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/toolchain/ui/options/Bundle").getString("lbFamily_MN").charAt(0));
        this.lbFamily.setLabelFor(this.cbFamily);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/toolchain/ui/options/Bundle");
        this.lbFamily.setText(bundle.getString("AddCompilerSetPanel.lbFamily.text"));
        this.lbFamily.setToolTipText(bundle.getString("AddCompilerSetPanel.lbFamily.toolTipText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 6, 6);
        this.add((Component)this.lbFamily, gridBagConstraints);
        this.cbFamily.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddCompilerSetPanel.this.cbFamilyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = -4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 12);
        this.add((Component)this.cbFamily, gridBagConstraints);
        this.lbName.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/toolchain/ui/options/Bundle").getString("lbToolSetName_MN").charAt(0));
        this.lbName.setLabelFor(this.tfName);
        this.lbName.setText(NbBundle.getMessage(AddCompilerSetPanel.class, (String)"AddCompilerSetPanel.lbName.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 6, 6);
        this.add((Component)this.lbName, gridBagConstraints);
        this.tfName.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 6, 6, 12);
        this.add((Component)this.tfName, gridBagConstraints);
        this.tfName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddCompilerSetPanel.class, (String)"AddCompilerSetPanel.tfName.AccessibleContext.accessibleDescription"));
        this.lbError.setText(NbBundle.getMessage(AddCompilerSetPanel.class, (String)"AddCompilerSetPanel.lbError.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 0, 12);
        this.add((Component)this.lbError, gridBagConstraints);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddCompilerSetPanel.class, (String)"AddCompilerSetPanel.AccessibleContext.accessibleDescription"));
    }

    private void cbFamilyActionPerformed(ActionEvent evt) {
        this.updateDataFamily();
    }

    private void btBaseDirectoryActionPerformed(ActionEvent evt) {
        this.updateBaseDirectory();
    }
}

