/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.flow.visual;

import java.awt.datatransfer.Transferable;
import java.util.List;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.modules.vmd.api.flow.visual.FlowBadgeDescriptor;
import org.netbeans.modules.vmd.api.flow.visual.FlowScene;
import org.netbeans.modules.vmd.api.model.DesignComponent;

public abstract class FlowDescriptor {
    private DesignComponent representedComponent;
    private String descriptorID;

    protected FlowDescriptor(DesignComponent representedComponent, String descriptorID) {
        assert (representedComponent != null && descriptorID != null);
        this.representedComponent = representedComponent;
        this.descriptorID = descriptorID;
    }

    public final DesignComponent getRepresentedComponent() {
        return this.representedComponent;
    }

    public final String getDescriptorID() {
        return this.descriptorID;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowDescriptor desc = (FlowDescriptor)o;
        return this.representedComponent == desc.representedComponent && this.descriptorID.equals(desc.descriptorID);
    }

    public final int hashCode() {
        return 29 * this.representedComponent.hashCode() + this.descriptorID.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.representedComponent.getComponentID() + ":" + this.descriptorID;
    }

    public static interface KeyActionBehaviour
    extends Behaviour {
        public boolean keyPressed(WidgetAction.WidgetKeyEvent var1);
    }

    public static interface EditActionBehaviour
    extends Behaviour {
        public void edit(FlowDescriptor var1);
    }

    public static interface RenameActionBehaviour
    extends Behaviour {
        public boolean isEditable(FlowDescriptor var1);

        public String getText(FlowDescriptor var1);

        public void setText(FlowDescriptor var1, String var2);
    }

    public static interface SelectActionBehaviour
    extends Behaviour {
        public boolean select(FlowDescriptor var1, int var2);
    }

    public static interface AcceptActionBehaviour
    extends Behaviour {
        public boolean isAcceptable(FlowDescriptor var1, Transferable var2);

        public void accept(FlowDescriptor var1, Transferable var2);
    }

    public static interface BadgeDecorator
    extends Decorator {
        public void updateBadges(FlowDescriptor var1, FlowScene var2, List<FlowBadgeDescriptor> var3);
    }

    public static interface Behaviour {
    }

    public static interface Decorator {
    }
}

