/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import java.beans.PropertyEditor;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.util.StringUtils;
import org.springframework.validation.AbstractErrors;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DefaultMessageCodesResolver;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.validation.ObjectError;

public abstract class AbstractBindingResult
extends AbstractErrors
implements BindingResult,
Serializable {
    private final String objectName;
    private MessageCodesResolver messageCodesResolver = new DefaultMessageCodesResolver();
    private final List errors = new LinkedList();
    private final Set suppressedFields = new HashSet();

    protected AbstractBindingResult(String objectName) {
        this.objectName = objectName;
    }

    public void setMessageCodesResolver(MessageCodesResolver messageCodesResolver) {
        this.messageCodesResolver = messageCodesResolver;
    }

    public MessageCodesResolver getMessageCodesResolver() {
        return this.messageCodesResolver;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void reject(String errorCode, Object[] errorArgs, String defaultMessage) {
        this.addError(new ObjectError(this.getObjectName(), this.resolveMessageCodes(errorCode), errorArgs, defaultMessage));
    }

    public void rejectValue(String field, String errorCode, Object[] errorArgs, String defaultMessage) {
        if ("".equals(this.getNestedPath()) && !StringUtils.hasLength(field)) {
            this.reject(errorCode, errorArgs, defaultMessage);
            return;
        }
        String fixedField = this.fixedField(field);
        Object newVal = this.getActualFieldValue(fixedField);
        FieldError fe = new FieldError(this.getObjectName(), fixedField, newVal, false, this.resolveMessageCodes(errorCode, field), errorArgs, defaultMessage);
        this.addError(fe);
    }

    public void addError(ObjectError error) {
        this.errors.add(error);
    }

    public void addAllErrors(Errors errors) {
        if (!errors.getObjectName().equals(this.getObjectName())) {
            throw new IllegalArgumentException("Errors object needs to have same object name");
        }
        this.errors.addAll(errors.getAllErrors());
    }

    public String[] resolveMessageCodes(String errorCode) {
        return this.getMessageCodesResolver().resolveMessageCodes(errorCode, this.getObjectName());
    }

    public String[] resolveMessageCodes(String errorCode, String field) {
        String fixedField = this.fixedField(field);
        Class fieldType = this.getFieldType(fixedField);
        return this.getMessageCodesResolver().resolveMessageCodes(errorCode, this.getObjectName(), fixedField, fieldType);
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public int getErrorCount() {
        return this.errors.size();
    }

    public List getAllErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public List getGlobalErrors() {
        LinkedList result = new LinkedList();
        Iterator it = this.errors.iterator();
        while (it.hasNext()) {
            Object error = it.next();
            if (error instanceof FieldError) continue;
            result.add(error);
        }
        return Collections.unmodifiableList(result);
    }

    public ObjectError getGlobalError() {
        Iterator it = this.errors.iterator();
        while (it.hasNext()) {
            ObjectError objectError = (ObjectError)it.next();
            if (objectError instanceof FieldError) continue;
            return objectError;
        }
        return null;
    }

    public List getFieldErrors() {
        LinkedList result = new LinkedList();
        Iterator it = this.errors.iterator();
        while (it.hasNext()) {
            Object error = it.next();
            if (!(error instanceof FieldError)) continue;
            result.add(error);
        }
        return Collections.unmodifiableList(result);
    }

    public FieldError getFieldError() {
        Iterator it = this.errors.iterator();
        while (it.hasNext()) {
            Object error = it.next();
            if (!(error instanceof FieldError)) continue;
            return (FieldError)error;
        }
        return null;
    }

    public List getFieldErrors(String field) {
        LinkedList result = new LinkedList();
        String fixedField = this.fixedField(field);
        Iterator it = this.errors.iterator();
        while (it.hasNext()) {
            Object error = it.next();
            if (!(error instanceof FieldError) || !this.isMatchingFieldError(fixedField, (FieldError)error)) continue;
            result.add(error);
        }
        return Collections.unmodifiableList(result);
    }

    public FieldError getFieldError(String field) {
        String fixedField = this.fixedField(field);
        Iterator it = this.errors.iterator();
        while (it.hasNext()) {
            FieldError fe;
            Object error = it.next();
            if (!(error instanceof FieldError) || !this.isMatchingFieldError(fixedField, fe = (FieldError)error)) continue;
            return fe;
        }
        return null;
    }

    public Object getFieldValue(String field) {
        FieldError fe = this.getFieldError(field);
        Object value = null;
        value = fe != null ? fe.getRejectedValue() : this.getActualFieldValue(this.fixedField(field));
        if (fe == null || !fe.isBindingFailure()) {
            value = this.formatFieldValue(field, value);
        }
        return value;
    }

    public Class getFieldType(String field) {
        Object value = this.getActualFieldValue(this.fixedField(field));
        if (value != null) {
            return value.getClass();
        }
        return null;
    }

    public Map getModel() {
        HashMap<String, Object> model = new HashMap<String, Object>(2);
        model.put(MODEL_KEY_PREFIX + this.getObjectName(), this);
        model.put(this.getObjectName(), this.getTarget());
        return model;
    }

    public Object getRawFieldValue(String field) {
        return this.getActualFieldValue(this.fixedField(field));
    }

    public PropertyEditor findEditor(String field, Class valueType) {
        PropertyEditorRegistry editorRegistry = this.getPropertyEditorRegistry();
        if (editorRegistry != null) {
            Class valueTypeToUse = valueType;
            if (valueTypeToUse == null) {
                valueTypeToUse = this.getFieldType(field);
            }
            return editorRegistry.findCustomEditor(valueTypeToUse, this.fixedField(field));
        }
        return null;
    }

    public PropertyEditorRegistry getPropertyEditorRegistry() {
        return null;
    }

    public void recordSuppressedField(String field) {
        this.suppressedFields.add(field);
    }

    public String[] getSuppressedFields() {
        return StringUtils.toStringArray(this.suppressedFields);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BindingResult)) {
            return false;
        }
        BindingResult otherResult = (BindingResult)other;
        return this.getObjectName().equals(otherResult.getObjectName()) && this.getTarget().equals(otherResult.getTarget()) && ((Object)this.getAllErrors()).equals(otherResult.getAllErrors());
    }

    public int hashCode() {
        return this.getObjectName().hashCode() * 29 + this.getTarget().hashCode();
    }

    public abstract Object getTarget();

    protected abstract Object getActualFieldValue(String var1);

    protected Object formatFieldValue(String field, Object value) {
        return value;
    }
}

