/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.svg;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.m2g.SVGEventListener;
import javax.microedition.m2g.SVGImage;
import org.netbeans.microedition.svg.SVGAnimatorWrapper;
import org.netbeans.microedition.util.CancellableTask;

public class SVGWaitScreen
extends SVGAnimatorWrapper {
    public static final Command SUCCESS_COMMAND = new Command("Success", 4, 0);
    public static final Command FAILURE_COMMAND = new Command("Failure", 4, 0);
    private CancellableTask task;
    private Thread backgroundExecutor;

    public SVGWaitScreen(SVGImage svgImage, Display display) throws IllegalArgumentException {
        super(svgImage, display);
        this.setSVGEventListener(new WaitScreenSvgEventListener());
    }

    public void setTask(CancellableTask task) {
        this.task = task;
    }

    public CancellableTask getTask() {
        return this.task;
    }

    private void doAction() {
        CommandListener cl = this.getCommandListener();
        if (cl != null) {
            if (this.task != null && this.task.hasFailed()) {
                cl.commandAction(FAILURE_COMMAND, (Displayable)this);
            } else {
                cl.commandAction(SUCCESS_COMMAND, (Displayable)this);
            }
        }
    }

    private class WaitScreenSvgEventListener
    implements SVGEventListener {
        private WaitScreenSvgEventListener() {
        }

        public void keyPressed(int i) {
        }

        public void keyReleased(int i) {
        }

        public void pointerPressed(int i, int i0) {
        }

        public void pointerReleased(int i, int i0) {
        }

        public void hideNotify() {
        }

        public void showNotify() {
            if (SVGWaitScreen.this.task != null) {
                if (SVGWaitScreen.this.backgroundExecutor == null) {
                    SVGWaitScreen.this.backgroundExecutor = new Thread(new BackgroundExecutor(SVGWaitScreen.this.task));
                    SVGWaitScreen.this.backgroundExecutor.start();
                }
            } else {
                SVGWaitScreen.this.getDisplay().callSerially(new Runnable(){

                    public void run() {
                        SVGWaitScreen.this.doAction();
                    }
                });
            }
        }

        public void sizeChanged(int i, int i0) {
        }
    }

    private class BackgroundExecutor
    implements Runnable {
        private CancellableTask task;

        public BackgroundExecutor(CancellableTask task) throws IllegalArgumentException {
            if (task == null) {
                throw new IllegalArgumentException("Task parameter cannot be null");
            }
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.task.run();
            }
            finally {
                SVGWaitScreen.this.backgroundExecutor = null;
                SVGWaitScreen.this.doAction();
            }
        }
    }
}

