/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xdm.xam;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.netbeans.modules.xml.xam.dom.ChangeInfo;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.modules.xml.xam.dom.SyncUnit;
import org.netbeans.modules.xml.xdm.XDMModel;
import org.netbeans.modules.xml.xdm.diff.NodeInfo;
import org.netbeans.modules.xml.xdm.nodes.Document;
import org.netbeans.modules.xml.xdm.nodes.Node;
import org.netbeans.modules.xml.xdm.xam.XDMAccess;
import org.w3c.dom.Element;

public class XDMListener
implements PropertyChangeListener {
    private AbstractDocumentModel model;
    private boolean inSync;
    private Document oldDocument;
    private boolean xamModelHasRoot;
    private Map<Integer, SyncUnit> syncUnits = new HashMap<Integer, SyncUnit>();

    public XDMListener(AbstractDocumentModel model) {
        this.model = model;
    }

    public boolean xamModelHasRoot() {
        return this.xamModelHasRoot;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        Node now;
        if (!this.inSync) {
            return;
        }
        NodeInfo oldInfo = (NodeInfo)event.getOldValue();
        NodeInfo newInfo = (NodeInfo)event.getNewValue();
        Node old = oldInfo != null ? oldInfo.getNode() : null;
        Node node = now = newInfo != null ? newInfo.getNode() : null;
        if (old != null) {
            this.processEvent(old, oldInfo, false);
        }
        if (now != null) {
            this.processEvent(now, newInfo, true);
        }
    }

    private XDMModel getXDMModel() {
        return ((XDMAccess)this.model.getAccess()).getXDMModel();
    }

    void startSync() {
        this.inSync = true;
        this.xamModelHasRoot = true;
        this.syncUnits.clear();
        this.oldDocument = this.getXDMModel().getCurrentDocument();
        this.getXDMModel().addPropertyChangeListener(this);
    }

    Document getOldDocument() {
        return this.oldDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endSync(boolean processing) {
        this.getXDMModel().removePropertyChangeListener(this);
        try {
            if (processing) {
                for (SyncUnit unit : this.syncUnits.values()) {
                    this.model.processSyncUnit(unit);
                }
            }
        }
        finally {
            this.syncUnits.clear();
            this.inSync = false;
        }
    }

    private static Integer getID(ChangeInfo change) {
        if (change.getParent() == null) {
            return 0;
        }
        org.netbeans.modules.xml.xdm.nodes.Element parent = (org.netbeans.modules.xml.xdm.nodes.Element)change.getParent();
        return parent.getId();
    }

    private static Integer getID(DocumentComponent c) {
        if (c == null) {
            return 0;
        }
        org.netbeans.modules.xml.xdm.nodes.Element xdmElement = (org.netbeans.modules.xml.xdm.nodes.Element)((AbstractDocumentComponent)c).getPeer();
        return xdmElement.getId();
    }

    protected void processEvent(Node eventNode, NodeInfo nodeInfo, boolean isAdded) {
        List<Node> pathToRoot = nodeInfo.getNewAncestors();
        if (pathToRoot.size() == 1) {
            this.processRootRelatedEvent(eventNode, pathToRoot, isAdded);
        } else {
            if (eventNode.getId() == pathToRoot.get(0).getId()) {
                throw new IllegalArgumentException("Event node has same id as parent");
            }
            pathToRoot = new ArrayList<Node>(pathToRoot);
            pathToRoot.add(0, eventNode);
            List<Node> namespacePathToRoot = null;
            if (isAdded) {
                namespacePathToRoot = pathToRoot;
            } else {
                namespacePathToRoot = nodeInfo.getOriginalAncestors();
                namespacePathToRoot = new ArrayList<Node>(namespacePathToRoot);
                namespacePathToRoot.add(0, eventNode);
                assert (namespacePathToRoot.size() == pathToRoot.size());
            }
            ChangeInfo change = this.model.prepareChangeInfo(pathToRoot);
            change.setAdded(isAdded);
            this.processChange(change);
        }
    }

    protected void processRootRelatedEvent(Node eventNode, List<Node> pathToRoot, boolean isAdded) {
        assert (pathToRoot.get(0) instanceof Document);
        if (!(eventNode instanceof org.netbeans.modules.xml.xdm.nodes.Element)) {
            return;
        }
        if (!isAdded) {
            this.xamModelHasRoot = false;
            return;
        }
        DocumentComponent rootComponent = null;
        String errorMessage = null;
        try {
            rootComponent = this.model.createRootComponent((Element)((org.netbeans.modules.xml.xdm.nodes.Element)eventNode));
        }
        catch (IllegalArgumentException e) {
            errorMessage = e.getMessage();
        }
        if (rootComponent == null) {
            errorMessage = errorMessage != null ? errorMessage : "Unexpected root element " + AbstractDocumentComponent.getQName((org.w3c.dom.Node)eventNode);
            throw new IllegalArgumentException(new IOException(errorMessage));
        }
        this.xamModelHasRoot = true;
        this.model.firePropertyChangeEvent(new PropertyChangeEvent(this.model, "state", Model.State.NOT_SYNCED, Model.State.VALID));
    }

    protected void processChange(ChangeInfo change) {
        Integer unitID = XDMListener.getID(change);
        SyncUnit existing = this.syncUnits.get(unitID);
        SyncUnit su = this.model.prepareSyncUnit(change, existing);
        if (su == null) {
            return;
        }
        Integer reviewedID = XDMListener.getID(su.getTarget());
        existing = this.syncUnits.get(reviewedID);
        if (existing == null) {
            if (unitID.equals(reviewedID)) {
                this.syncUnits.put(reviewedID, su);
            } else {
                existing = this.syncUnits.get(reviewedID);
                if (existing != null) {
                    existing.merge(su);
                } else {
                    this.syncUnits.put(reviewedID, su);
                }
            }
        } else if (existing != su) {
            if (unitID.equals(reviewedID)) {
                existing.merge(su);
            } else {
                this.syncUnits.remove(unitID);
                existing = this.syncUnits.get(reviewedID);
                if (existing != null) {
                    existing.merge(su);
                } else {
                    this.syncUnits.put(reviewedID, su);
                }
            }
        }
    }

    static List<org.w3c.dom.Node> toDomNodes(List<Node> nodes) {
        ArrayList<org.w3c.dom.Node> domNodes = new ArrayList<org.w3c.dom.Node>();
        for (Node n : nodes) {
            domNodes.add(n);
        }
        return domNodes;
    }

    protected ChangeInfo prepareChangeInfo(List<? extends Node> pathToRoot, List<? extends Node> nsContextPathToRoot) {
        if (pathToRoot.size() < 1) {
            throw new IllegalArgumentException("pathToRoot here should be at least 1");
        }
        if (pathToRoot.get(pathToRoot.size() - 1) instanceof Document) {
            pathToRoot.remove(pathToRoot.size() - 1);
        }
        if (pathToRoot.size() < 2) {
            throw new IllegalArgumentException("pathToRoot here should be at least 2");
        }
        org.w3c.dom.Node current = null;
        Element parent = null;
        boolean changedIsDomainElement = true;
        Set qnames = this.model.getQNames();
        if (qnames != null && qnames.size() > 0) {
            for (int i = pathToRoot.size() - 1; i >= 0; --i) {
                Node n = pathToRoot.get(i);
                parent = (org.netbeans.modules.xml.xdm.nodes.Element)current;
                current = n;
                if (!(n instanceof org.netbeans.modules.xml.xdm.nodes.Element)) {
                    changedIsDomainElement = false;
                } else {
                    QName currentQName = new QName(this.model.getAccess().lookupNamespaceURI(current, nsContextPathToRoot), current.getLocalName());
                    if (qnames.contains(currentQName)) continue;
                    changedIsDomainElement = false;
                }
                break;
            }
        } else {
            current = pathToRoot.get(0);
            parent = (Element)((Object)pathToRoot.get(1));
            changedIsDomainElement = current instanceof Element;
        }
        ArrayList<org.netbeans.modules.xml.xdm.nodes.Element> rootToParent = new ArrayList<org.netbeans.modules.xml.xdm.nodes.Element>();
        if (parent != null) {
            for (int i = pathToRoot.indexOf(parent); i < pathToRoot.size(); ++i) {
                rootToParent.add(0, (org.netbeans.modules.xml.xdm.nodes.Element)pathToRoot.get(i));
            }
        }
        ArrayList<Node> otherNodes = new ArrayList<Node>();
        if (parent != null) {
            int iCurrent = pathToRoot.indexOf(current);
            for (int i = 0; i < iCurrent; ++i) {
                otherNodes.add(0, pathToRoot.get(i));
            }
        }
        return new ChangeInfo(parent, current, changedIsDomainElement, rootToParent, otherNodes);
    }
}

