/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ExpressionPool;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.actions.RunIntoMethodActionProvider;
import org.netbeans.modules.debugger.jpda.actions.StepOperationActionProvider;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.debugger.ui.MethodChooser;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotation;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MethodChooserSupport
implements PropertyChangeListener {
    private JPDADebuggerImpl debugger;
    private JPDAThread currentThread;
    private String url;
    private ReferenceType clazzRef;
    private MethodChooser chooser;
    ArrayList<Annotation> annotations;
    private int startLine;
    private int endLine;
    private int selectedIndex = -1;
    private EditorContext.Operation[] operations;
    private Location[] locations;
    private boolean[] isCertainlyReachable;

    MethodChooserSupport(JPDADebuggerImpl jPDADebuggerImpl, String string, ReferenceType referenceType, int n, int n2) {
        this.debugger = jPDADebuggerImpl;
        this.currentThread = jPDADebuggerImpl.getCurrentThread();
        this.url = string;
        this.clazzRef = referenceType;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public MethodChooser.Segment[] getSegments() {
        MethodChooser.Segment[] segmentArray = new MethodChooser.Segment[this.operations.length];
        for (int i = 0; i < segmentArray.length; ++i) {
            int n = this.operations[i].getMethodStartPosition().getOffset();
            int n2 = this.operations[i].getMethodEndPosition().getOffset();
            segmentArray[i] = this.isCertainlyReachable[i] ? new MethodChooser.Segment(n, n2) : new UncertainSegment(n, n2);
        }
        return segmentArray;
    }

    public int getSegmentsCount() {
        return this.operations.length;
    }

    public String getHint() {
        return NbBundle.getMessage(MethodChooserSupport.class, (String)"MSG_RunIntoMethod_Status_Line_Help");
    }

    public KeyStroke[] getStopEvents() {
        return new KeyStroke[]{KeyStroke.getKeyStroke(119, 0), KeyStroke.getKeyStroke(118, 64), KeyStroke.getKeyStroke(118, 128)};
    }

    public KeyStroke[] getConfirmEvents() {
        return new KeyStroke[]{KeyStroke.getKeyStroke(118, 0)};
    }

    public MethodChooser createChooser() {
        return new MethodChooser(this.url, this.getSegments(), this.selectedIndex, this.getHint(), this.getStopEvents(), this.getConfirmEvents());
    }

    public void tearUp(MethodChooser methodChooser) {
        System.setProperty("org.netbeans.modules.debugger.jpda.doNotShowTooltips", "true");
        this.chooser = methodChooser;
        this.debugger.addPropertyChangeListener(this);
        this.debugger.getThreadsCollector().addPropertyChangeListener(this);
        this.annotateLines();
    }

    public void tearDown() {
        System.clearProperty("org.netbeans.modules.debugger.jpda.doNotShowTooltips");
        this.debugger.removePropertyChangeListener(this);
        this.debugger.getThreadsCollector().removePropertyChangeListener(this);
        this.clearAnnotations();
    }

    public void doStepInto() {
        final int n = this.chooser.getSelectedIndex();
        final String string = this.operations[n].getMethodName();
        this.debugger.getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                RunIntoMethodActionProvider.doAction(MethodChooserSupport.this.debugger, string, MethodChooserSupport.this.locations[n], true);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        this.operations = new EditorContext.Operation[0];
        List<Object> list = Collections.emptyList();
        try {
            for (int i = this.currentThread.getLineNumber(null); i > 0 && (list = ReferenceTypeWrapper.locationsOfLine(this.clazzRef, i)).isEmpty(); --i) {
            }
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return false;
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return false;
        }
        catch (ClassNotPreparedExceptionWrapper classNotPreparedExceptionWrapper) {
        }
        catch (AbsentInformationException absentInformationException) {
            ErrorManager.getDefault().notify(1, (Throwable)absentInformationException);
        }
        if (list.isEmpty()) {
            return false;
        }
        ExpressionPool.Expression expression = this.debugger.getExpressionPool().getExpressionAt((Location)list.get(0), this.url);
        if (expression == null) {
            return false;
        }
        EditorContext.Operation operation = this.currentThread.getCurrentOperation();
        List list2 = this.currentThread.getLastOperations();
        EditorContext.Operation operation2 = list2 != null && list2.size() > 0 ? (EditorContext.Operation)list2.get(list2.size() - 1) : null;
        EditorContext.Operation operation3 = null;
        EditorContext.Operation[] operationArray = expression.getOperations();
        if (operationArray.length == 0) {
            return false;
        }
        Location[] locationArray = expression.getLocations();
        this.operations = new EditorContext.Operation[operationArray.length];
        this.locations = new Location[operationArray.length];
        for (n8 = 0; n8 < operationArray.length; ++n8) {
            this.operations[n8] = operationArray[n8];
            this.locations[n8] = locationArray[n8];
        }
        this.startLine = this.operations[0].getMethodStartPosition().getLine();
        this.endLine = this.operations[this.operations.length - 1].getMethodEndPosition().getLine();
        for (n8 = 1; n8 < this.operations.length - 1; ++n8) {
            n7 = this.operations[n8].getMethodStartPosition().getLine();
            if (n7 < this.startLine) {
                this.startLine = n7;
            }
            if (n7 <= this.endLine) continue;
            this.endLine = n7;
        }
        n8 = -1;
        n7 = -1;
        if (operation != null) {
            n6 = operation.getBytecodeIndex();
            for (n5 = 0; n5 < this.operations.length; ++n5) {
                if (this.operations[n5].getBytecodeIndex() != n6) continue;
                n8 = n5;
                break;
            }
        }
        if (operation2 != null) {
            n6 = operation2.getBytecodeIndex();
            for (n5 = 0; n5 < this.operations.length; ++n5) {
                if (this.operations[n5].getBytecodeIndex() != n6) continue;
                n7 = n5;
                break;
            }
        }
        EditorContext.Operation operation4 = null;
        if (n8 == -1) {
            operation3 = this.operations[this.operations.length - 1];
            operation4 = this.operations[0];
        } else {
            int n9 = n5 = n8 == n7 ? n8 : n8 - 1;
            if (n5 + 1 < this.operations.length) {
                operation4 = this.operations[n5 + 1];
            }
            operationArray = new EditorContext.Operation[this.operations.length - 1 - n5];
            locationArray = new Location[this.operations.length - 1 - n5];
            for (n4 = 0; n4 < operationArray.length; ++n4) {
                operationArray[n4] = this.operations[n4 + n5 + 1];
                locationArray[n4] = this.locations[n4 + n5 + 1];
            }
            this.operations = operationArray;
            this.locations = locationArray;
            if (this.operations.length == 0) {
                return false;
            }
            operation3 = this.operations[0];
        }
        Object[][] objectArray = new Object[this.operations.length][2];
        for (n4 = 0; n4 < this.operations.length; ++n4) {
            objectArray[n4][0] = this.operations[n4];
            objectArray[n4][1] = this.locations[n4];
        }
        Arrays.sort(objectArray, new OperatorsComparator());
        this.isCertainlyReachable = new boolean[this.operations.length];
        for (n4 = 0; n4 < this.operations.length; ++n4) {
            this.operations[n4] = (EditorContext.Operation)objectArray[n4][0];
            this.locations[n4] = (Location)objectArray[n4][1];
            this.isCertainlyReachable[n4] = true;
        }
        int[] nArray = new int[this.operations.length];
        for (n3 = 0; n3 < nArray.length; ++n3) {
            nArray[n3] = 0;
        }
        this.detectUnreachableOps(nArray, operation);
        n3 = 0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] >= 2) continue;
            ++n3;
        }
        operationArray = this.operations;
        locationArray = this.locations;
        this.operations = new EditorContext.Operation[n3];
        this.locations = new Location[n3];
        this.isCertainlyReachable = new boolean[n3];
        n2 = 0;
        int n10 = -1;
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] >= 2) continue;
            this.operations[n2] = operationArray[n];
            this.locations[n2] = locationArray[n];
            boolean bl = this.isCertainlyReachable[n2] = nArray[n] == 0;
            if (operation4 == this.operations[n2]) {
                n10 = n2;
            }
            ++n2;
        }
        this.selectedIndex = 0;
        for (n = 0; n < this.operations.length; ++n) {
            if (!this.operations[n].equals((Object)operation3) || !this.isCertainlyReachable[n]) continue;
            this.selectedIndex = n;
        }
        if (n10 >= 0 && !this.isCertainlyReachable[n10]) {
            MethodChooserSupport methodChooserSupport = this;
            synchronized (methodChooserSupport) {
                StepOperationActionProvider.doAction(this.debugger, this);
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    Exceptions.printStackTrace((Throwable)interruptedException);
                }
            }
            return this.init();
        }
        if (this.operations.length == 1) {
            String string = this.operations[this.selectedIndex].getMethodName();
            RunIntoMethodActionProvider.doAction(this.debugger, string, this.locations[this.selectedIndex], true);
            return true;
        }
        return false;
    }

    private void detectUnreachableOps(final int[] nArray, final EditorContext.Operation operation) {
        Object object;
        FileObject fileObject = null;
        try {
            fileObject = URLMapper.findFileObject((URL)new URL(this.url));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (fileObject == null) {
            return;
        }
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        if (dataObject == null) {
            return;
        }
        final EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return;
        }
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        if (javaSource == null) {
            return;
        }
        final JEditorPane[] jEditorPaneArray = new JEditorPane[1];
        if (SwingUtilities.isEventDispatchThread()) {
            object = editorCookie.getOpenedPanes();
            if (object != null && ((JEditorPane[])object).length > 0) {
                jEditorPaneArray[0] = object[0];
            }
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        JEditorPane[] jEditorPaneArray2 = editorCookie.getOpenedPanes();
                        if (jEditorPaneArray2 != null && jEditorPaneArray2.length > 0) {
                            jEditorPaneArray[0] = jEditorPaneArray2[0];
                        }
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
                Exceptions.printStackTrace((Throwable)invocationTargetException);
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
        }
        try {
            object = javaSource.runWhenScanFinished((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    if (compilationController.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        ErrorManager.getDefault().log(16, "Unable to resolve " + compilationController.getFileObject() + " to phase " + JavaSource.Phase.RESOLVED + ", current phase = " + compilationController.getPhase() + "\nDiagnostics = " + compilationController.getDiagnostics() + "\nFree memory = " + Runtime.getRuntime().freeMemory());
                        return;
                    }
                    SourcePositions sourcePositions = compilationController.getTrees().getSourcePositions();
                    CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
                    TreeUtilities treeUtilities = compilationController.getTreeUtilities();
                    int n = operation == null ? 0 : operation.getMethodStartPosition().getOffset() + 1;
                    for (int i = 0; i < MethodChooserSupport.this.operations.length; ++i) {
                        int n2 = MethodChooserSupport.this.operations[i].getMethodStartPosition().getOffset() + 1;
                        for (TreePath treePath = treeUtilities.pathFor(n2); treePath != null; treePath = treePath.getParentPath()) {
                            ExpressionTree expressionTree;
                            ExpressionTree expressionTree2;
                            Tree tree = treePath.getLeaf();
                            if (tree instanceof ConditionalExpressionTree) {
                                expressionTree2 = (ConditionalExpressionTree)tree;
                                expressionTree = expressionTree2.getTrueExpression();
                                ExpressionTree expressionTree3 = expressionTree2.getFalseExpression();
                                long l = sourcePositions.getStartPosition(compilationUnitTree, expressionTree);
                                long l2 = sourcePositions.getEndPosition(compilationUnitTree, expressionTree);
                                long l3 = sourcePositions.getStartPosition(compilationUnitTree, expressionTree3);
                                long l4 = sourcePositions.getEndPosition(compilationUnitTree, expressionTree3);
                                if (l <= (long)n2 && (long)n2 <= l2) {
                                    if ((long)n >= l) continue;
                                    this.markSegment(i, false);
                                    continue;
                                }
                                if (l3 > (long)n2 || (long)n2 > l4) continue;
                                if ((long)n < l) {
                                    this.markSegment(i, false);
                                    continue;
                                }
                                if (l > (long)n || (long)n > l2) continue;
                                this.markSegment(i, true);
                                continue;
                            }
                            if (tree.getKind() != Tree.Kind.CONDITIONAL_AND && tree.getKind() != Tree.Kind.CONDITIONAL_OR) continue;
                            expressionTree2 = (BinaryTree)tree;
                            expressionTree = expressionTree2.getRightOperand();
                            long l = sourcePositions.getStartPosition(compilationUnitTree, expressionTree);
                            long l5 = sourcePositions.getEndPosition(compilationUnitTree, expressionTree);
                            if (l > (long)n2 || (long)n2 > l5 || (long)n >= l) continue;
                            this.markSegment(i, false);
                        }
                    }
                }

                public void markSegment(int n, boolean bl) {
                    if (nArray[n] == 2) {
                        return;
                    }
                    nArray[n] = bl ? 2 : 1;
                }
            }, true);
            if (!object.isDone()) {
                if (EventQueue.isDispatchThread()) {
                    return;
                }
                try {
                    object.get();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException executionException) {
                    ErrorManager.getDefault().notify((Throwable)executionException);
                }
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    private void annotateLines() {
        this.annotations = new ArrayList();
        EditorContext editorContext = EditorContextBridge.getContext();
        JPDAThread jPDAThread = this.debugger.getCurrentThread();
        EditorContext.Operation operation = jPDAThread.getCurrentOperation();
        int n = operation != null ? operation.getStartPosition().getLine() : jPDAThread.getLineNumber(null);
        String string = operation != null ? "CurrentExpressionLine" : "CurrentPC";
        for (int i = this.startLine; i <= this.endLine; ++i) {
            Object object;
            if (i == n || !((object = editorContext.annotate(this.url, i, string, null)) instanceof Annotation)) continue;
            this.annotations.add((Annotation)object);
        }
    }

    private void clearAnnotations() {
        if (this.annotations != null) {
            for (Annotation annotation : this.annotations) {
                annotation.detach();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("exec".equals(propertyChangeEvent.getPropertyName())) {
            MethodChooserSupport methodChooserSupport = this;
            synchronized (methodChooserSupport) {
                this.notifyAll();
            }
        }
        if (this.debugger.getState() == 4 || this.currentThread != this.debugger.getCurrentThread() || !this.currentThread.isSuspended()) {
            MethodChooserSupport methodChooserSupport = this;
            synchronized (methodChooserSupport) {
                this.notifyAll();
            }
            this.chooser.releaseUI(false);
        }
    }

    private static class UncertainSegment
    extends MethodChooser.Segment {
        public UncertainSegment(int n, int n2) {
            super(n, n2);
        }
    }

    private static final class OperatorsComparator
    implements Comparator {
        private OperatorsComparator() {
        }

        public int compare(Object object, Object object2) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])object2;
            EditorContext.Operation operation = (EditorContext.Operation)objectArray[0];
            EditorContext.Operation operation2 = (EditorContext.Operation)objectArray2[0];
            return operation.getMethodStartPosition().getOffset() - operation2.getMethodStartPosition().getOffset();
        }
    }
}

