/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.ActionsManagerListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.ClassLoadUnloadBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAStep;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ExpressionPool;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.JPDAStepImpl;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.IllegalThreadStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidRequestStateExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.LocationWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ObjectCollectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ReferenceTypeWrapper;
import org.netbeans.modules.debugger.jpda.jdi.StackFrameWrapper;
import org.netbeans.modules.debugger.jpda.jdi.ThreadReferenceWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VirtualMachineWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestManagerWrapper;
import org.netbeans.modules.debugger.jpda.jdi.request.EventRequestWrapper;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class RunIntoMethodActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener,
ActionsManagerListener {
    private static final Logger logger = Logger.getLogger(RunIntoMethodActionProvider.class.getName());
    private JPDADebuggerImpl debugger;
    private ActionsManager lastActionsManager;

    public RunIntoMethodActionProvider(ContextProvider contextProvider) {
        this.debugger = (JPDADebuggerImpl)((Object)contextProvider.lookupFirst(null, JPDADebugger.class));
        this.debugger.addPropertyChangeListener("state", this);
        EditorContextBridge.getContext().addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void destroy() {
        this.debugger.removePropertyChangeListener("state", this);
        EditorContextBridge.getContext().removePropertyChangeListener((PropertyChangeListener)this);
    }

    static ActionsManager getCurrentActionsManager() {
        return DebuggerManager.getDebuggerManager().getCurrentEngine() == null ? DebuggerManager.getDebuggerManager().getActionsManager() : DebuggerManager.getDebuggerManager().getCurrentEngine().getActionsManager();
    }

    private ActionsManager getActionsManager() {
        ActionsManager actionsManager = RunIntoMethodActionProvider.getCurrentActionsManager();
        if (actionsManager != this.lastActionsManager) {
            if (this.lastActionsManager != null) {
                this.lastActionsManager.removeActionsManagerListener("actionStateChanged", (ActionsManagerListener)this);
            }
            actionsManager.addActionsManagerListener("actionStateChanged", (ActionsManagerListener)this);
            this.lastActionsManager = actionsManager;
        }
        return actionsManager;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setEnabled(ActionsManager.ACTION_RUN_INTO_METHOD, this.getActionsManager().isEnabled(ActionsManager.ACTION_CONTINUE) && this.debugger.getState() == 3 && EditorContextBridge.getContext().getCurrentLineNumber() >= 0 && EditorContextBridge.getContext().getCurrentURL().endsWith(".java"));
        if (this.debugger.getState() == 4) {
            this.destroy();
        }
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_RUN_INTO_METHOD);
    }

    public void doAction(Object object) {
        final String[] stringArray = new String[1];
        final String[] stringArray2 = new String[1];
        final String[] stringArray3 = new String[1];
        final int[] nArray = new int[1];
        final int[] nArray2 = new int[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    EditorContext editorContext = EditorContextBridge.getContext();
                    stringArray[0] = editorContext.getSelectedMethodName();
                    nArray[0] = editorContext.getCurrentLineNumber();
                    nArray2[0] = EditorContextBridge.getCurrentOffset();
                    stringArray2[0] = editorContext.getCurrentURL();
                    stringArray3[0] = editorContext.getCurrentClassName();
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            ErrorManager.getDefault().notify(invocationTargetException.getTargetException());
            return;
        }
        catch (InterruptedException interruptedException) {
            ErrorManager.getDefault().notify((Throwable)interruptedException);
            return;
        }
        final String string = stringArray[0];
        if (string.length() < 1) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(RunIntoMethodActionProvider.class, (String)"MSG_Put_cursor_on_some_method_call"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        final int n = nArray[0];
        final int n2 = nArray2[0];
        final String string2 = stringArray2[0];
        String string3 = stringArray3[0];
        VirtualMachine virtualMachine = this.debugger.getVirtualMachine();
        if (virtualMachine == null) {
            return;
        }
        JPDAThreadImpl jPDAThreadImpl = (JPDAThreadImpl)this.debugger.getCurrentThread();
        ThreadReference threadReference = jPDAThreadImpl.getThreadReference();
        ReferenceType referenceType = null;
        String string4 = null;
        try {
            if (ThreadReferenceWrapper.frameCount(threadReference) < 1) {
                return;
            }
            referenceType = LocationWrapper.declaringType(StackFrameWrapper.location(ThreadReferenceWrapper.frame(threadReference, 0)));
            string4 = ReferenceTypeWrapper.name(referenceType);
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return;
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
        }
        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
            return;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return;
        }
        if (referenceType != null && (string3 == null || string3.equals(string4))) {
            this.doAction(string2, referenceType, n, n2, string, true);
        } else {
            ClassLoadUnloadBreakpoint classLoadUnloadBreakpoint;
            try {
                classLoadUnloadBreakpoint = VirtualMachineWrapper.classesByName(virtualMachine, string3);
                if (classLoadUnloadBreakpoint.size() > 0) {
                    this.doAction(string2, classLoadUnloadBreakpoint.get(0), n, n2, string, true);
                    return;
                }
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                return;
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                return;
            }
            classLoadUnloadBreakpoint = ClassLoadUnloadBreakpoint.create((String)string3, (boolean)false, (int)1);
            classLoadUnloadBreakpoint.setHidden(true);
            classLoadUnloadBreakpoint.setSuspend(0);
            classLoadUnloadBreakpoint.addJPDABreakpointListener(new JPDABreakpointListener(){

                public void breakpointReached(JPDABreakpointEvent jPDABreakpointEvent) {
                    DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)classLoadUnloadBreakpoint);
                    RunIntoMethodActionProvider.this.doAction(string2, jPDABreakpointEvent.getReferenceType(), n, n2, string, false);
                }
            });
            try {
                Method method = JPDABreakpoint.class.getDeclaredMethod("setSession", JPDADebugger.class);
                method.setAccessible(true);
                method.invoke((Object)classLoadUnloadBreakpoint, new Object[]{this.debugger});
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)classLoadUnloadBreakpoint);
            RunIntoMethodActionProvider.resume(this.debugger);
        }
    }

    private static void resume(JPDADebugger jPDADebugger) {
        if (jPDADebugger.getSuspend() == 1) {
            jPDADebugger.getCurrentThread().resume();
        } else {
            Session session = ((JPDADebuggerImpl)jPDADebugger).getSession();
            session.getEngineForLanguage("Java").getActionsManager().doAction(ActionsManager.ACTION_CONTINUE);
        }
    }

    private void doAction(String string, ReferenceType referenceType, int n, int n2, String string2, boolean bl) {
        Object object;
        List<Object> list = Collections.emptyList();
        try {
            while (n > 0 && (list = ReferenceTypeWrapper.locationsOfLine(referenceType, n)).isEmpty()) {
                --n;
            }
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return;
        }
        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
            return;
        }
        catch (ClassNotPreparedExceptionWrapper classNotPreparedExceptionWrapper) {
        }
        catch (AbsentInformationException absentInformationException) {
            ErrorManager.getDefault().notify(1, (Throwable)absentInformationException);
        }
        logger.fine("doAction(" + string + ", " + referenceType + ", " + n + ", " + string2 + ") locations = " + list);
        if (list.isEmpty()) {
            object = NbBundle.getMessage(RunIntoMethodActionProvider.class, (String)"MSG_RunIntoMeth_absentInfo", (Object)referenceType.name());
            NotifyDescriptor.Message message = new NotifyDescriptor.Message(object);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        object = this.debugger.getExpressionPool().getExpressionAt((Location)list.get(0), string);
        Location location = null;
        if (object != null) {
            EditorContext.Operation[] operationArray = ((ExpressionPool.Expression)object).getOperations();
            for (int i = 0; i < operationArray.length; ++i) {
                EditorContext.Operation operation = operationArray[i];
                if (operation.getMethodStartPosition().getOffset() > n2 || n2 > operation.getMethodEndPosition().getOffset()) continue;
                location = ((ExpressionPool.Expression)object).getLocations()[i];
                break;
            }
        }
        if (location == null) {
            location = (Location)list.get(0);
        }
        RunIntoMethodActionProvider.doAction(this.debugger, string2, location, false, bl);
    }

    static boolean doAction(JPDADebuggerImpl jPDADebuggerImpl, String string, Location location, boolean bl) {
        return RunIntoMethodActionProvider.doAction(jPDADebuggerImpl, string, location, bl, true);
    }

    private static boolean doAction(final JPDADebuggerImpl jPDADebuggerImpl, final String string, Location location, boolean bl, boolean bl2) {
        JPDAThreadImpl jPDAThreadImpl;
        boolean bl3;
        CallStackFrame[] callStackFrameArray;
        final VirtualMachine virtualMachine = jPDADebuggerImpl.getVirtualMachine();
        if (virtualMachine == null) {
            return false;
        }
        final int n = LocationWrapper.lineNumber0(location, "Java");
        JPDAThreadImpl jPDAThreadImpl2 = (JPDAThreadImpl)jPDADebuggerImpl.getCurrentThread();
        if (jPDAThreadImpl2 == null) {
            return false;
        }
        try {
            callStackFrameArray = jPDAThreadImpl2.getCallStack(0, 1);
        }
        catch (AbsentInformationException absentInformationException) {
            return false;
        }
        if (callStackFrameArray.length < 1) {
            return false;
        }
        CallStackFrameImpl callStackFrameImpl = (CallStackFrameImpl)callStackFrameArray[0];
        try {
            bl3 = LocationWrapper.equals(StackFrameWrapper.location(callStackFrameImpl.getStackFrame()), location);
            jPDAThreadImpl = (JPDAThreadImpl)callStackFrameImpl.getThread();
        }
        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
            return false;
        }
        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
            return false;
        }
        catch (InternalExceptionWrapper internalExceptionWrapper) {
            return false;
        }
        final boolean bl4 = bl;
        if (bl3) {
            RunIntoMethodActionProvider.traceLineForMethod(jPDADebuggerImpl, jPDAThreadImpl2.getThreadReference(), string, n, bl4);
        } else {
            final JPDAStep[] jPDAStepArray = new JPDAStep[]{null};
            try {
                final BreakpointRequest breakpointRequest = EventRequestManagerWrapper.createBreakpointRequest(VirtualMachineWrapper.eventRequestManager(virtualMachine), location);
                final ThreadReference threadReference = jPDAThreadImpl.getThreadReference();
                Executor executor = new Executor(){

                    @Override
                    public boolean exec(Event event) {
                        ThreadReference threadReference2 = ((BreakpointEvent)event).thread();
                        try {
                            if (!threadReference.equals(threadReference2)) {
                                logger.fine("doAction: tracingExecutor.exec(" + event + ") called with non-preferred thread.");
                                for (int i = 20; !ThreadReferenceWrapper.isAtBreakpoint(threadReference) && i > 0; --i) {
                                    try {
                                        Thread.sleep(50L);
                                        continue;
                                    }
                                    catch (InterruptedException interruptedException) {
                                        break;
                                    }
                                }
                                if (ThreadReferenceWrapper.isAtBreakpoint(threadReference) && ThreadReferenceWrapper.frameCount(threadReference2) > 0) {
                                    Location location;
                                    Location location2 = StackFrameWrapper.location(ThreadReferenceWrapper.frame(threadReference2, 0));
                                    if (ThreadReferenceWrapper.frameCount(threadReference) > 0 && ((Object)location2).equals(location = StackFrameWrapper.location(ThreadReferenceWrapper.frame(threadReference, 0)))) {
                                        logger.fine("doAction: tracingExecutor - preferredThread " + threadReference + " is at breakpoint, resuming hit thread " + threadReference2);
                                        return true;
                                    }
                                }
                            }
                        }
                        catch (InternalExceptionWrapper internalExceptionWrapper) {
                        }
                        catch (InternalException internalException) {
                        }
                        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                        }
                        catch (VMDisconnectedException vMDisconnectedException) {
                        }
                        catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                        }
                        catch (ObjectCollectedException objectCollectedException) {
                        }
                        catch (IllegalThreadStateExceptionWrapper illegalThreadStateExceptionWrapper) {
                        }
                        catch (IllegalThreadStateException illegalThreadStateException) {
                        }
                        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                        }
                        catch (InvalidStackFrameExceptionWrapper invalidStackFrameExceptionWrapper) {
                            // empty catch block
                        }
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("doAction: tracingExecutor.exec(" + event + ") called with thread " + threadReference2 + " which is " + (threadReference.equals(threadReference2) ? "" : "not ") + "preferred.");
                            logger.fine("Calling location reached, tracing for " + string + "()");
                        }
                        if (jPDAStepArray[0] != null) {
                            ((JPDAStepImpl)jPDAStepArray[0]).cancel();
                        }
                        try {
                            EventRequestManagerWrapper.deleteEventRequest(VirtualMachineWrapper.eventRequestManager(virtualMachine), breakpointRequest);
                            jPDADebuggerImpl.getOperator().unregister(breakpointRequest);
                        }
                        catch (InternalExceptionWrapper internalExceptionWrapper) {
                        }
                        catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                            return false;
                        }
                        RunIntoMethodActionProvider.traceLineForMethod(jPDADebuggerImpl, threadReference2, string, n, bl4);
                        return true;
                    }

                    @Override
                    public void removed(EventRequest eventRequest) {
                    }
                };
                jPDADebuggerImpl.getOperator().register(breakpointRequest, executor);
                EventRequestWrapper.setSuspendPolicy(breakpointRequest, jPDADebuggerImpl.getSuspend());
                try {
                    EventRequestWrapper.enable(breakpointRequest);
                }
                catch (ObjectCollectedExceptionWrapper objectCollectedExceptionWrapper) {
                    jPDADebuggerImpl.getOperator().unregister(breakpointRequest);
                    return false;
                }
                catch (InvalidRequestStateExceptionWrapper invalidRequestStateExceptionWrapper) {
                    Exceptions.printStackTrace((Throwable)invalidRequestStateExceptionWrapper);
                    jPDADebuggerImpl.getOperator().unregister(breakpointRequest);
                    return false;
                }
                if (bl) {
                    jPDAStepArray[0] = RunIntoMethodActionProvider.setBoundaryStepRequest(jPDADebuggerImpl, jPDAThreadImpl, breakpointRequest);
                }
            }
            catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                return false;
            }
            catch (InternalExceptionWrapper internalExceptionWrapper) {
                return false;
            }
        }
        if (bl2) {
            RunIntoMethodActionProvider.resume(jPDADebuggerImpl);
        }
        return true;
    }

    private static JPDAStep setBoundaryStepRequest(final JPDADebuggerImpl jPDADebuggerImpl, JPDAThread jPDAThread, final EventRequest eventRequest) {
        JPDAStep jPDAStep = jPDADebuggerImpl.createJPDAStep(-2, 2);
        jPDAStep.addPropertyChangeListener("exec", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                VirtualMachine virtualMachine = jPDADebuggerImpl.getVirtualMachine();
                if (virtualMachine != null) {
                    try {
                        jPDADebuggerImpl.getOperator().unregister(eventRequest);
                        EventRequestManagerWrapper.deleteEventRequest(VirtualMachineWrapper.eventRequestManager(virtualMachine), eventRequest);
                    }
                    catch (InternalExceptionWrapper internalExceptionWrapper) {
                    }
                    catch (VMDisconnectedExceptionWrapper vMDisconnectedExceptionWrapper) {
                        // empty catch block
                    }
                }
            }
        });
        jPDAStep.addStep(jPDAThread);
        return jPDAStep;
    }

    private static void traceLineForMethod(final JPDADebuggerImpl jPDADebuggerImpl, ThreadReference threadReference, final String string, final int n, final boolean bl) {
        final JPDAThreadImpl jPDAThreadImpl = jPDADebuggerImpl.getThread(threadReference);
        final int n2 = jPDAThreadImpl.getStackDepth();
        final JPDAStep jPDAStep = jPDADebuggerImpl.createJPDAStep(-2, 1);
        jPDAStep.setHidden(true);
        jPDAStep.addPropertyChangeListener("exec", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                block12: {
                    if (Logger.getLogger(RunIntoMethodActionProvider.class.getName()).isLoggable(Level.FINE)) {
                        logger.fine("traceLineForMethod(" + string + ") step is at " + jPDADebuggerImpl.getCurrentThread().getClassName() + ":" + jPDADebuggerImpl.getCurrentThread().getMethodName());
                    }
                    int n3 = jPDAThreadImpl.getStackDepth();
                    logger.fine("  depth = " + n3 + ", target = " + n2);
                    if (n3 == n2) {
                        try {
                            if (jPDAThreadImpl.getCallStack()[0].getLineNumber("Java") != n) {
                                jPDAStep.setHidden(false);
                                break block12;
                            }
                            logger.fine("  back on the method invoaction line, setting additional step into.");
                            jPDAStep.setDepth(1);
                            jPDAStep.addStep(jPDADebuggerImpl.getCurrentThread());
                        }
                        catch (AbsentInformationException absentInformationException) {
                            ErrorManager.getDefault().notify(1, (Throwable)absentInformationException);
                            jPDAStep.setHidden(false);
                        }
                    } else if (jPDAThreadImpl.getMethodName().equals(string)) {
                        jPDAStep.setHidden(false);
                    } else if (jPDAThreadImpl.getMethodName().equals("<init>") && (jPDAThreadImpl.getClassName().endsWith("." + string) || jPDAThreadImpl.getClassName().equals(string))) {
                        jPDAStep.setHidden(false);
                    } else if (bl) {
                        jPDAStep.setHidden(false);
                    } else {
                        jPDAStep.setDepth(3);
                        jPDAStep.addStep(jPDADebuggerImpl.getCurrentThread());
                    }
                }
            }
        });
        jPDAStep.addStep((JPDAThread)jPDAThreadImpl);
    }

    public void actionPerformed(Object object) {
    }

    public void actionStateChanged(Object object, boolean bl) {
        if (ActionsManager.ACTION_CONTINUE == object) {
            this.setEnabled(ActionsManager.ACTION_RUN_INTO_METHOD, bl && this.debugger.getState() == 3 && EditorContextBridge.getContext().getCurrentLineNumber() >= 0 && EditorContextBridge.getContext().getCurrentURL().endsWith(".java"));
        }
    }
}

