/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.jdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.debugger.jpda.JDIExceptionReporter;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InvalidStackFrameExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.NativeMethodExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;

public final class StackFrameWrapper {
    private StackFrameWrapper() {
    }

    public static List<Value> getArgumentValues0(StackFrame a) throws InvalidStackFrameExceptionWrapper {
        try {
            return a.getArgumentValues();
        }
        catch (InternalException ex) {
            JDIExceptionReporter.report(ex);
            return Collections.emptyList();
        }
        catch (VMDisconnectedException ex) {
            return Collections.emptyList();
        }
        catch (InvalidStackFrameException ex) {
            throw new InvalidStackFrameExceptionWrapper(ex);
        }
    }

    public static List<Value> getArgumentValues(StackFrame a) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper {
        try {
            return a.getArgumentValues();
        }
        catch (InternalException ex) {
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (InvalidStackFrameException ex) {
            throw new InvalidStackFrameExceptionWrapper(ex);
        }
    }

    public static Value getValue(StackFrame a, LocalVariable b) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper {
        try {
            return a.getValue(b);
        }
        catch (InternalException ex) {
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (InvalidStackFrameException ex) {
            throw new InvalidStackFrameExceptionWrapper(ex);
        }
    }

    public static Map<LocalVariable, Value> getValues0(StackFrame a, List<? extends LocalVariable> b) throws InvalidStackFrameExceptionWrapper {
        try {
            return a.getValues(b);
        }
        catch (InternalException ex) {
            JDIExceptionReporter.report(ex);
            return Collections.emptyMap();
        }
        catch (VMDisconnectedException ex) {
            return Collections.emptyMap();
        }
        catch (InvalidStackFrameException ex) {
            throw new InvalidStackFrameExceptionWrapper(ex);
        }
    }

    public static Map<LocalVariable, Value> getValues(StackFrame a, List<? extends LocalVariable> b) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper {
        try {
            return a.getValues(b);
        }
        catch (InternalException ex) {
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (InvalidStackFrameException ex) {
            throw new InvalidStackFrameExceptionWrapper(ex);
        }
    }

    public static Location location(StackFrame a) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper {
        try {
            return a.location();
        }
        catch (InternalException ex) {
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (InvalidStackFrameException ex) {
            throw new InvalidStackFrameExceptionWrapper(ex);
        }
    }

    public static void setValue(StackFrame a, LocalVariable b, Value c) throws InvalidTypeException, ClassNotLoadedException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper {
        try {
            a.setValue(b, c);
        }
        catch (InternalException ex) {
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (InvalidStackFrameException ex) {
            throw new InvalidStackFrameExceptionWrapper(ex);
        }
    }

    public static ObjectReference thisObject(StackFrame a) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper {
        try {
            try {
                return a.thisObject();
            }
            catch (InternalException iex) {
                try {
                    if (iex.errorCode() == 35) {
                        return null;
                    }
                    throw iex;
                }
                catch (InternalException ex) {
                    JDIExceptionReporter.report(ex);
                    throw new InternalExceptionWrapper(ex);
                }
            }
        }
        catch (VMDisconnectedException ex) {
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (InvalidStackFrameException ex) {
            throw new InvalidStackFrameExceptionWrapper(ex);
        }
    }

    public static ThreadReference thread(StackFrame a) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper {
        try {
            return a.thread();
        }
        catch (InternalException ex) {
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (InvalidStackFrameException ex) {
            throw new InvalidStackFrameExceptionWrapper(ex);
        }
    }

    public static LocalVariable visibleVariableByName(StackFrame a, String b) throws AbsentInformationException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper, NativeMethodExceptionWrapper {
        try {
            return a.visibleVariableByName(b);
        }
        catch (InternalException ex) {
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (InvalidStackFrameException ex) {
            throw new InvalidStackFrameExceptionWrapper(ex);
        }
        catch (NativeMethodException ex) {
            throw new NativeMethodExceptionWrapper(ex);
        }
    }

    public static List<LocalVariable> visibleVariables0(StackFrame a) throws AbsentInformationException, InvalidStackFrameExceptionWrapper, NativeMethodExceptionWrapper {
        try {
            return a.visibleVariables();
        }
        catch (InternalException ex) {
            JDIExceptionReporter.report(ex);
            return Collections.emptyList();
        }
        catch (VMDisconnectedException ex) {
            return Collections.emptyList();
        }
        catch (InvalidStackFrameException ex) {
            throw new InvalidStackFrameExceptionWrapper(ex);
        }
        catch (NativeMethodException ex) {
            throw new NativeMethodExceptionWrapper(ex);
        }
    }

    public static List<LocalVariable> visibleVariables(StackFrame a) throws AbsentInformationException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, InvalidStackFrameExceptionWrapper, NativeMethodExceptionWrapper {
        try {
            return a.visibleVariables();
        }
        catch (InternalException ex) {
            JDIExceptionReporter.report(ex);
            throw new InternalExceptionWrapper(ex);
        }
        catch (VMDisconnectedException ex) {
            throw new VMDisconnectedExceptionWrapper(ex);
        }
        catch (InvalidStackFrameException ex) {
            throw new InvalidStackFrameExceptionWrapper(ex);
        }
        catch (NativeMethodException ex) {
            throw new NativeMethodExceptionWrapper(ex);
        }
    }
}

