/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.modules.tasklist.filter.KeywordsFilter;
import org.netbeans.modules.tasklist.filter.TaskFilter;
import org.netbeans.modules.tasklist.filter.TypesFilter;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class FilterRepository {
    private static FilterRepository theInstance;
    private LinkedList<TaskFilter> filters = new LinkedList();
    private int active = -1;

    FilterRepository() {
    }

    public static FilterRepository getDefault() {
        if (null == theInstance) {
            theInstance = new FilterRepository();
        }
        return theInstance;
    }

    public void assign(FilterRepository fr) {
        if (fr != this) {
            this.filters.clear();
            Iterator it = fr.filters.iterator();
            while (it.hasNext()) {
                this.filters.add((TaskFilter)((TaskFilter)it.next()).clone());
            }
            this.active = fr.active;
        }
    }

    public Object clone() {
        FilterRepository ret = new FilterRepository();
        ret.assign(this);
        return ret;
    }

    public List<TaskFilter> getAllFilters() {
        return new ArrayList<TaskFilter>(this.filters);
    }

    void add(TaskFilter f) {
        this.filters.add(f);
    }

    void remove(TaskFilter f) {
        if (f == this.getActive()) {
            this.setActive(null);
        }
        this.filters.remove(f);
    }

    Iterator<TaskFilter> iterator() {
        return this.filters.iterator();
    }

    int size() {
        return this.filters.size();
    }

    TaskFilter getFilterByName(String name) {
        for (TaskFilter f : this.filters) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    public TaskFilter getActive() {
        return this.active == -1 || this.filters.isEmpty() ? null : this.filters.get(this.active);
    }

    public void setActive(TaskFilter newactive) {
        if (newactive == null) {
            this.active = -1;
        } else {
            int i = this.filters.indexOf(newactive);
            if (i != -1) {
                this.active = i;
            }
        }
    }

    public void load() throws IOException {
        TypesFilter types;
        TaskFilter filter;
        this.filters.clear();
        this.active = -1;
        Preferences prefs = NbPreferences.forModule(FilterRepository.class);
        prefs = prefs.node("Filters");
        this.active = prefs.getInt("active", -1);
        int count = prefs.getInt("count", 0);
        for (int i = 0; i < count; ++i) {
            filter = new TaskFilter();
            try {
                filter.load(prefs, "Filter_" + i);
            }
            catch (BackingStoreException bsE) {
                IOException ioE = new IOException("Cannot load filter repository");
                ioE.initCause(bsE);
                throw ioE;
            }
            this.filters.add(filter);
        }
        boolean shouldSave = false;
        if (prefs.getBoolean("firstTimeStart", true)) {
            prefs.putBoolean("firstTimeStart", false);
            filter = this.createNewFilter();
            filter.setName(NbBundle.getMessage(FilterRepository.class, (String)"LBL_DefaultFilter"));
            types = new TypesFilter();
            types.setTaskCountLimit(100);
            filter.setTypesFilter(types);
            filter.setKeywordsFilter(new KeywordsFilter());
            this.filters.add(filter);
            this.setActive(filter);
            shouldSave = true;
        }
        if (prefs.getBoolean("firstTimeStartWithIssue", true)) {
            prefs.putBoolean("firstTimeStartWithIssue", false);
            filter = this.createNewFilter();
            filter.setName(NbBundle.getMessage(FilterRepository.class, (String)"LBL_IssuesFilter"));
            types = new TypesFilter();
            types.clear();
            types.setEnabled("org.netbeans.modules.bugtracking.tasklist.TaskListProvider", true);
            types.setTaskCountLimit(100);
            filter.setTypesFilter(types);
            filter.setKeywordsFilter(new KeywordsFilter());
            this.filters.add(filter);
            shouldSave = true;
        }
        if (shouldSave) {
            this.save();
        }
    }

    public void save() throws IOException {
        try {
            Preferences prefs = NbPreferences.forModule(FilterRepository.class);
            prefs = prefs.node("Filters");
            prefs.clear();
            prefs.putBoolean("firstTimeStart", false);
            prefs.putBoolean("firstTimeStartWithIssue", false);
            prefs.putInt("count", this.filters.size());
            prefs.putInt("active", this.active);
            for (int i = 0; i < this.filters.size(); ++i) {
                TaskFilter filter = this.filters.get(i);
                filter.save(prefs, "Filter_" + i);
            }
        }
        catch (BackingStoreException bsE) {
            IOException ioE = new IOException("Cannot save filter repository");
            ioE.initCause(bsE);
            throw ioE;
        }
    }

    TaskFilter createNewFilter() {
        return new TaskFilter(NbBundle.getMessage(FilterRepository.class, (String)"LBL_NewFilter"));
    }

    void clear() {
        this.filters.clear();
        this.setActive(null);
    }

    List<TaskFilter> getFilters() {
        return new ArrayList<TaskFilter>(this.filters);
    }
}

