/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.drivers.text;

import org.netbeans.jemmy.Timeout;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.LightSupportiveDriver;
import org.netbeans.jemmy.drivers.TextDriver;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.JTextComponentOperator;
import org.netbeans.jemmy.operators.TextComponentOperator;

public abstract class TextAPIDriver
extends LightSupportiveDriver
implements TextDriver {
    public TextAPIDriver(String[] supported) {
        super(supported);
    }

    public void changeCaretPosition(ComponentOperator oper, int position) {
        this.checkSupported(oper);
        if (oper instanceof TextComponentOperator) {
            ((TextComponentOperator)oper).setCaretPosition(position);
        } else {
            ((JTextComponentOperator)oper).setCaretPosition(position);
        }
    }

    public void selectText(ComponentOperator oper, int startPosition, int finalPosition) {
        int end;
        this.checkSupported(oper);
        int start = startPosition < finalPosition ? startPosition : finalPosition;
        int n = end = startPosition > finalPosition ? startPosition : finalPosition;
        if (oper instanceof TextComponentOperator) {
            TextComponentOperator toper = (TextComponentOperator)oper;
            toper.setSelectionStart(start);
            toper.setSelectionEnd(end);
        } else {
            JTextComponentOperator toper = (JTextComponentOperator)oper;
            toper.setSelectionStart(start);
            toper.setSelectionEnd(end);
        }
    }

    public void clearText(ComponentOperator oper) {
        if (oper instanceof TextComponentOperator) {
            ((TextComponentOperator)oper).setText("");
        } else {
            ((JTextComponentOperator)oper).setText("");
        }
    }

    public void typeText(ComponentOperator oper, String text, int caretPosition) {
        this.checkSupported(oper);
        String curtext = this.getText(oper);
        int realPos = caretPosition;
        if (this.getSelectionStart(oper) == realPos || this.getSelectionEnd(oper) == realPos) {
            if (this.getSelectionEnd(oper) == realPos) {
                realPos -= this.getSelectionEnd(oper) - this.getSelectionStart(oper);
            }
            curtext = curtext.substring(0, this.getSelectionStart(oper)) + curtext.substring(this.getSelectionEnd(oper));
        }
        this.changeText(oper, curtext.substring(0, realPos) + text + curtext.substring(realPos));
    }

    public void changeText(ComponentOperator oper, String text) {
        this.checkSupported(oper);
        if (oper instanceof TextComponentOperator) {
            ((TextComponentOperator)oper).setText(text);
        } else {
            ((JTextComponentOperator)oper).setText(text);
        }
    }

    public void enterText(ComponentOperator oper, String text) {
        this.changeText(oper, text);
        DriverManager.getKeyDriver(oper).pushKey(oper, 10, 0, new Timeout("", 0L));
    }

    public abstract String getText(ComponentOperator var1);

    public abstract int getCaretPosition(ComponentOperator var1);

    public abstract int getSelectionStart(ComponentOperator var1);

    public abstract int getSelectionEnd(ComponentOperator var1);
}

