/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicButtonUI;
import org.netbeans.modules.form.ComponentInspector;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormLoaderSettings;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormNode;
import org.openide.actions.MoveDownAction;
import org.openide.actions.MoveUpAction;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.ListView;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;

public class NonVisualTray
extends JPanel
implements ExplorerManager.Provider {
    private FormModel formModel;
    private NonVisualView listView;
    private ExplorerManager manager;

    public NonVisualTray(FormModel formModel) {
        this.formModel = formModel;
        this.manager = new ExplorerManager();
        FormNode formNode = FormEditor.getFormEditor(formModel).getOthersContainerNode();
        this.manager.setRootContext((Node)new NonVisualNode((Node)formNode, new NonVisualChildren((Node)formNode)));
        Listener listener = new Listener();
        this.manager.addPropertyChangeListener((PropertyChangeListener)listener);
        ComponentInspector componentInspector = ComponentInspector.getInstance();
        componentInspector.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)listener);
        this.listView = new NonVisualView();
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.listView), "Center");
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    void updateVisualSettings() {
        this.listView.updateVisualSettings();
    }

    private static class NonVisualNode
    extends FilterNode {
        public NonVisualNode(Node node) {
            super(node);
            this.disableDelegation(160);
        }

        public NonVisualNode(Node node, FilterNode.Children children) {
            super(node, (Children)children);
        }

        public String getShortDescription() {
            return this.getName();
        }

        protected Node getOriginal() {
            return super.getOriginal();
        }

        public Action[] getActions(boolean bl) {
            List<Class> list = Arrays.asList(MoveUpAction.class, MoveDownAction.class);
            Action[] actionArray = this.getOriginal().getActions(bl);
            ArrayList<Action> arrayList = new ArrayList<Action>(Arrays.asList(actionArray));
            for (int i = 0; i < actionArray.length; ++i) {
                Action action = actionArray[i];
                if (action == null || !list.contains(action.getClass())) continue;
                arrayList.remove(action);
            }
            return arrayList.toArray(new Action[arrayList.size()]);
        }
    }

    private class NonVisualChildren
    extends FilterNode.Children {
        public NonVisualChildren(Node node) {
            super(node);
        }

        protected Node copyNode(Node node) {
            return new NonVisualNode(node);
        }
    }

    private class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                if (propertyChangeEvent.getSource() == NonVisualTray.this.manager) {
                    Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
                    Node[] nodeArray2 = new Node[nodeArray.length];
                    for (int i = 0; i < nodeArray2.length; ++i) {
                        nodeArray2[i] = ((NonVisualNode)nodeArray[i]).getOriginal();
                    }
                    ComponentInspector componentInspector = ComponentInspector.getInstance();
                    Node[] nodeArray3 = componentInspector.getSelectedNodes();
                    if (!Arrays.asList(nodeArray3).containsAll(Arrays.asList(nodeArray2))) {
                        try {
                            componentInspector.setSelectedNodes(nodeArray2, FormEditor.getFormEditor(NonVisualTray.this.formModel));
                        }
                        catch (PropertyVetoException propertyVetoException) {}
                    }
                } else {
                    Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
                    ArrayList<Node> arrayList = new ArrayList<Node>();
                    Node node = ((NonVisualNode)NonVisualTray.this.manager.getRootContext()).getOriginal();
                    for (int i = 0; i < nodeArray.length; ++i) {
                        if (node != nodeArray[i].getParentNode()) continue;
                        arrayList.add(this.findFilterNode(nodeArray[i]));
                    }
                    try {
                        NonVisualTray.this.manager.setSelectedNodes(arrayList.toArray(new Node[arrayList.size()]));
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }

        private Node findFilterNode(Node node) {
            Node node2 = NonVisualTray.this.manager.getRootContext();
            Node[] nodeArray = node2.getChildren().getNodes(false);
            for (int i = 0; i < nodeArray.length; ++i) {
                NonVisualNode nonVisualNode = (NonVisualNode)nodeArray[i];
                if (nonVisualNode.getOriginal() != node) continue;
                return nonVisualNode;
            }
            return null;
        }
    }

    private static class Renderer
    implements ListCellRenderer {
        private JButton button = new JButton();
        private Border selectedBorder;
        private Border unselectedBorder;

        public Renderer() {
            this.button.setUI(new BasicButtonUI());
            this.unselectedBorder = BorderFactory.createEmptyBorder(4, 4, 4, 4);
            Color color = FormLoaderSettings.getInstance().getSelectionBorderColor();
            this.selectedBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createLineBorder(color));
            this.button.setOpaque(false);
            int n = this.button.getFontMetrics(this.button.getFont()).getHeight();
            this.button.setPreferredSize(new Dimension(72, 50 + n));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Node node = Visualizer.findNode((Object)object);
            ImageIcon imageIcon = new ImageIcon(node.getIcon(2));
            this.button.setIcon(imageIcon);
            String string = node.getShortDescription();
            this.button.setText(string);
            this.button.setHorizontalTextPosition(0);
            this.button.setVerticalTextPosition(3);
            this.button.setHorizontalAlignment(0);
            this.button.setBorder(bl ? this.selectedBorder : this.unselectedBorder);
            return this.button;
        }
    }

    private static class NonVisualView
    extends ListView {
        public NonVisualView() {
            this.list.setCellRenderer(new Renderer());
            this.list.setLayoutOrientation(2);
            this.list.setVisibleRowCount(-1);
            this.list.setBorder(BorderFactory.createEmptyBorder(0, 4, 4, 4));
            this.updateVisualSettings();
            this.setTraversalAllowed(false);
            this.setVerticalScrollBarPolicy(21);
            this.setHorizontalScrollBarPolicy(31);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            return new Dimension(1, (int)dimension.getHeight());
        }

        void updateVisualSettings() {
            this.list.setBackground(FormLoaderSettings.getInstance().getFormDesignerBackgroundColor());
        }
    }
}

