/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer.api;

import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class RepositoryInfo {
    private String id;
    private String type;
    private String name;
    private String repositoryPath;
    private String repositoryUrl;
    private String indexUpdateUrl;
    private final List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();

    public RepositoryInfo(String id, String type, String name, String repositoryPath, String repositoryUrl, String indexUpdateUrl) {
        this.id = id;
        this.type = type;
        this.name = name;
        this.repositoryPath = repositoryPath;
        this.repositoryUrl = repositoryUrl;
        this.indexUpdateUrl = indexUpdateUrl;
        assert (!(this.isLocal() && this.isRemoteDownloadable())) : "Cannot have both local and remote index fields filled in. Repository: " + id + " Path=" + repositoryPath + " Remote URL:" + indexUpdateUrl;
    }

    public static RepositoryInfo createRepositoryInfo(FileObject fo) {
        String remoteBundleName;
        String type = (String)fo.getAttribute("provider");
        if (type == null) {
            type = "nexus";
        }
        String id = fo.getName();
        String name = (String)fo.getAttribute("displayName");
        if (name == null) {
            name = id;
        }
        if ((remoteBundleName = (String)fo.getAttribute("SystemFileSystem.localizingBundle")) != null) {
            try {
                ResourceBundle bundle = NbBundle.getBundle((String)remoteBundleName);
                String nm = bundle.getString(fo.getPath());
                if (nm != null) {
                    name = nm;
                }
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        String path = (String)fo.getAttribute("path");
        String repourl = (String)fo.getAttribute("repoUrl");
        String indexurl = (String)fo.getAttribute("repoIndexUrl");
        return new RepositoryInfo(id, type, name, path, repourl, indexurl);
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public String getIndexUpdateUrl() {
        return this.indexUpdateUrl;
    }

    public boolean isRemoteDownloadable() {
        return this.indexUpdateUrl != null;
    }

    public boolean isLocal() {
        return this.repositoryPath != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener cl) {
        List<ChangeListener> list = this.changeListeners;
        synchronized (list) {
            this.changeListeners.add(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener cl) {
        List<ChangeListener> list = this.changeListeners;
        synchronized (list) {
            this.changeListeners.remove(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChangeIndex() {
        List<ChangeListener> list = this.changeListeners;
        synchronized (list) {
            for (ChangeListener changeListener : this.changeListeners) {
                changeListener.stateChanged(new ChangeEvent(this));
            }
        }
    }
}

