/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.java.navigation.ClassMemberPanelUI;
import org.netbeans.modules.java.navigation.ElementNode;

public class ElementScanningTask
implements CancellableTask<CompilationInfo> {
    private ClassMemberPanelUI ui;
    private final AtomicBoolean canceled = new AtomicBoolean();
    private static final String TYPE_COLOR = "#707070";
    private static final String INHERITED_COLOR = "#7D694A";

    public ElementScanningTask(ClassMemberPanelUI classMemberPanelUI) {
        this.ui = classMemberPanelUI;
    }

    public void cancel() {
        this.canceled.set(true);
    }

    public void run(CompilationInfo compilationInfo) throws Exception {
        this.canceled.set(false);
        long l = System.currentTimeMillis();
        if (compilationInfo.getChangedTree() != null) {
            long l2 = System.currentTimeMillis();
            Logger.getLogger("TIMER").log(Level.FINE, "Element Scanning Task", new Object[]{compilationInfo.getFileObject(), l2 - l});
            return;
        }
        ElementNode.Description description = new ElementNode.Description(this.ui);
        description.fileObject = compilationInfo.getFileObject();
        description.subs = new ArrayList<ElementNode.Description>();
        CompilationUnitTree compilationUnitTree = compilationInfo.getCompilationUnit();
        List list = compilationInfo.getTopLevelElements();
        HashMap<Element, Long> hashMap = new HashMap<Element, Long>();
        if (!this.canceled.get()) {
            Trees trees = compilationInfo.getTrees();
            Object object = new PositionVisitor(trees, this.canceled);
            ((PositionVisitor)object).scan((Tree)compilationUnitTree, (Map<Element, Long>)hashMap);
        }
        if (!this.canceled.get() && list != null) {
            for (Object object : list) {
                ElementNode.Description description2 = this.element2description((Element)object, null, false, compilationInfo, hashMap);
                if (null == description2) continue;
                description.subs.add(description2);
                this.addMembers((TypeElement)object, description2, compilationInfo, hashMap);
            }
        }
        if (!this.canceled.get()) {
            this.ui.refresh(description);
        }
        long l3 = System.currentTimeMillis();
        Logger.getLogger("TIMER").log(Level.FINE, "Element Scanning Task", new Object[]{compilationInfo.getFileObject(), l3 - l});
    }

    private void addMembers(TypeElement typeElement, ElementNode.Description description, CompilationInfo compilationInfo, Map<Element, Long> map) {
        List<? extends Element> list = compilationInfo.getElements().getAllMembers(typeElement);
        for (Element element : list) {
            if (this.canceled.get()) {
                return;
            }
            ElementNode.Description description2 = this.element2description(element, typeElement, description.isInherited, compilationInfo, map);
            if (null == description2) continue;
            description.subs.add(description2);
            if (!(element instanceof TypeElement) || description2.isInherited) continue;
            this.addMembers((TypeElement)element, description2, compilationInfo, map);
        }
    }

    private ElementNode.Description element2description(Element element, Element element2, boolean bl, CompilationInfo compilationInfo, Map<Element, Long> map) {
        if (compilationInfo.getElementUtilities().isSynthetic(element)) {
            return null;
        }
        boolean bl2 = bl || null != element2 && !((Object)element2).equals(element.getEnclosingElement());
        ElementNode.Description description = new ElementNode.Description(this.ui, element.getSimpleName().toString(), (ElementHandle<? extends Element>)ElementHandle.create((Element)element), element.getKind(), TreePathHandle.create((Element)element, (CompilationInfo)compilationInfo), bl2);
        if (element instanceof TypeElement) {
            description.subs = new ArrayList<ElementNode.Description>();
            description.htmlHeader = this.createHtmlHeader((TypeElement)element, compilationInfo.getElements().isDeprecated(element), description.isInherited);
        } else if (element instanceof ExecutableElement) {
            description.htmlHeader = this.createHtmlHeader((ExecutableElement)element, compilationInfo.getElements().isDeprecated(element), description.isInherited);
        } else if (element instanceof VariableElement) {
            if (element.getKind() != ElementKind.FIELD && element.getKind() != ElementKind.ENUM_CONSTANT) {
                return null;
            }
            description.htmlHeader = this.createHtmlHeader((VariableElement)element, compilationInfo.getElements().isDeprecated(element), description.isInherited);
        }
        description.modifiers = element.getModifiers();
        description.pos = this.getPosition(element, compilationInfo, map);
        if (bl2) {
            description.cpInfo = compilationInfo.getClasspathInfo();
        }
        return description;
    }

    private long getPosition(Element element, CompilationInfo compilationInfo, Map<Element, Long> map) {
        Long l = map.get(element);
        if (l == null) {
            return -1L;
        }
        return l;
    }

    private String createHtmlHeader(ExecutableElement executableElement, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("<s>");
        }
        if (bl2) {
            stringBuilder.append("<font color=#7D694A>");
        }
        if (executableElement.getKind() == ElementKind.CONSTRUCTOR) {
            stringBuilder.append(executableElement.getEnclosingElement().getSimpleName());
        } else {
            stringBuilder.append(executableElement.getSimpleName());
        }
        if (bl) {
            stringBuilder.append("</s>");
        }
        stringBuilder.append("(");
        List<? extends VariableElement> list = executableElement.getParameters();
        Object object = list.iterator();
        while (object.hasNext()) {
            VariableElement variableElement = object.next();
            stringBuilder.append("<font color=#707070>");
            boolean bl3 = !object.hasNext() && executableElement.isVarArgs();
            stringBuilder.append(this.printArg(variableElement.asType(), bl3));
            stringBuilder.append("</font>");
            stringBuilder.append(" ");
            stringBuilder.append(variableElement.getSimpleName());
            if (!object.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(")");
        if (executableElement.getKind() != ElementKind.CONSTRUCTOR && (object = executableElement.getReturnType()).getKind() != TypeKind.VOID) {
            stringBuilder.append(" : ");
            stringBuilder.append("<font color=#707070>");
            stringBuilder.append(this.print(executableElement.getReturnType()));
            stringBuilder.append("</font>");
        }
        return stringBuilder.toString();
    }

    private String createHtmlHeader(VariableElement variableElement, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("<s>");
        }
        if (bl2) {
            stringBuilder.append("<font color=#7D694A>");
        }
        stringBuilder.append(variableElement.getSimpleName());
        if (bl) {
            stringBuilder.append("</s>");
        }
        if (variableElement.getKind() != ElementKind.ENUM_CONSTANT) {
            stringBuilder.append(" : ");
            stringBuilder.append("<font color=#707070>");
            stringBuilder.append(this.print(variableElement.asType()));
            stringBuilder.append("</font>");
        }
        return stringBuilder.toString();
    }

    private String createHtmlHeader(TypeElement typeElement, boolean bl, boolean bl2) {
        List<? extends TypeMirror> list;
        Object object;
        Object object2;
        List<? extends TypeParameterElement> list2;
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("<s>");
        }
        if (bl2) {
            stringBuilder.append("<font color=#7D694A>");
        }
        stringBuilder.append(typeElement.getSimpleName());
        if (bl) {
            stringBuilder.append("</s>");
        }
        if ((list2 = typeElement.getTypeParameters()) != null && !list2.isEmpty()) {
            stringBuilder.append("&lt;");
            object2 = list2.iterator();
            while (object2.hasNext()) {
                object = (TypeParameterElement)object2.next();
                stringBuilder.append(object.getSimpleName());
                try {
                    list = object.getBounds();
                    if (!list.isEmpty()) {
                        stringBuilder.append(this.printBounds(list));
                    }
                }
                catch (NullPointerException nullPointerException) {
                    System.err.println("El " + typeElement);
                    nullPointerException.printStackTrace();
                }
                if (!object2.hasNext()) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("&gt;");
        }
        object2 = typeElement.getSuperclass();
        object = this.print((TypeMirror)object2);
        if (object2 == null || typeElement.getKind() == ElementKind.ENUM || typeElement.getKind() == ElementKind.ANNOTATION_TYPE || "Object".equals(object) || "<none>".equals(object)) {
            object = null;
        }
        list = typeElement.getInterfaces();
        if (!(object == null && list.isEmpty() || typeElement.getKind() == ElementKind.ANNOTATION_TYPE)) {
            stringBuilder.append(" :: ");
            if (object != null) {
                stringBuilder.append("<font color=#707070>");
                stringBuilder.append((String)object);
                stringBuilder.append("</font>");
            }
            if (!list.isEmpty()) {
                if (object != null) {
                    stringBuilder.append(" : ");
                }
                Iterator<? extends TypeMirror> iterator = list.iterator();
                while (iterator.hasNext()) {
                    TypeMirror typeMirror = iterator.next();
                    stringBuilder.append("<font color=#707070>");
                    stringBuilder.append(this.print(typeMirror));
                    stringBuilder.append("</font>");
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(", ");
                }
            }
        }
        return stringBuilder.toString();
    }

    private String printBounds(List<? extends TypeMirror> list) {
        if (list.size() == 1 && "java.lang.Object".equals(((Object)list.get(0)).toString())) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" extends ");
        Iterator<? extends TypeMirror> iterator = list.iterator();
        while (iterator.hasNext()) {
            TypeMirror typeMirror = iterator.next();
            stringBuilder.append(this.print(typeMirror));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(" & ");
        }
        return stringBuilder.toString();
    }

    private String printArg(TypeMirror typeMirror, boolean bl) {
        if (bl) {
            assert (typeMirror.getKind() == TypeKind.ARRAY);
            ArrayType arrayType = (ArrayType)typeMirror;
            StringBuilder stringBuilder = new StringBuilder(this.print(arrayType.getComponentType()));
            stringBuilder.append("...");
            return stringBuilder.toString();
        }
        return this.print(typeMirror);
    }

    private String print(TypeMirror typeMirror) {
        switch (typeMirror.getKind()) {
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)typeMirror;
                StringBuilder stringBuilder = new StringBuilder(declaredType.asElement().getSimpleName().toString());
                List<? extends TypeMirror> list = declaredType.getTypeArguments();
                if (!list.isEmpty()) {
                    stringBuilder.append("&lt;");
                    Iterator<? extends TypeMirror> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        TypeMirror typeMirror2 = iterator.next();
                        stringBuilder.append(this.print(typeMirror2));
                        if (!iterator.hasNext()) continue;
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("&gt;");
                }
                return stringBuilder.toString();
            }
            case TYPEVAR: {
                TypeVariable typeVariable = (TypeVariable)typeMirror;
                StringBuilder stringBuilder = new StringBuilder(typeVariable.asElement().getSimpleName().toString());
                return stringBuilder.toString();
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)typeMirror;
                StringBuilder stringBuilder = new StringBuilder(this.print(arrayType.getComponentType()));
                stringBuilder.append("[]");
                return stringBuilder.toString();
            }
            case WILDCARD: {
                WildcardType wildcardType = (WildcardType)typeMirror;
                StringBuilder stringBuilder = new StringBuilder("?");
                if (wildcardType.getExtendsBound() != null) {
                    stringBuilder.append(" extends ");
                    stringBuilder.append(this.print(wildcardType.getExtendsBound()));
                }
                if (wildcardType.getSuperBound() != null) {
                    stringBuilder.append(" super ");
                    stringBuilder.append(this.print(wildcardType.getSuperBound()));
                }
                return stringBuilder.toString();
            }
        }
        return ((Object)typeMirror).toString();
    }

    private static class PositionVisitor
    extends TreePathScanner<Void, Map<Element, Long>> {
        private final Trees trees;
        private final SourcePositions sourcePositions;
        private final AtomicBoolean canceled;
        private CompilationUnitTree cu;

        public PositionVisitor(Trees trees, AtomicBoolean atomicBoolean) {
            assert (trees != null);
            assert (atomicBoolean != null);
            this.trees = trees;
            this.sourcePositions = trees.getSourcePositions();
            this.canceled = atomicBoolean;
        }

        @Override
        public Void visitCompilationUnit(CompilationUnitTree compilationUnitTree, Map<Element, Long> map) {
            this.cu = compilationUnitTree;
            return (Void)super.visitCompilationUnit(compilationUnitTree, map);
        }

        @Override
        public Void visitClass(ClassTree classTree, Map<Element, Long> map) {
            Element element = this.trees.getElement(this.getCurrentPath());
            if (element != null) {
                long l = this.sourcePositions.getStartPosition(this.cu, classTree);
                map.put(element, l);
            }
            return (Void)super.visitClass(classTree, map);
        }

        @Override
        public Void visitMethod(MethodTree methodTree, Map<Element, Long> map) {
            Element element = this.trees.getElement(this.getCurrentPath());
            if (element != null) {
                long l = this.sourcePositions.getStartPosition(this.cu, methodTree);
                map.put(element, l);
            }
            return null;
        }

        @Override
        public Void visitVariable(VariableTree variableTree, Map<Element, Long> map) {
            Element element = this.trees.getElement(this.getCurrentPath());
            if (element != null) {
                long l = this.sourcePositions.getStartPosition(this.cu, variableTree);
                map.put(element, l);
            }
            return null;
        }

        @Override
        public Void scan(Tree tree, Map<Element, Long> map) {
            if (!this.canceled.get()) {
                return (Void)super.scan(tree, map);
            }
            return null;
        }
    }
}

