/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.indicators.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.dlight.api.indicator.IndicatorMetadata;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.visualizer.VisualizerConfiguration;
import org.netbeans.modules.dlight.indicators.Aggregation;
import org.netbeans.modules.dlight.indicators.DataRowToTimeSeries;
import org.netbeans.modules.dlight.indicators.TimeSeriesDescriptor;
import org.netbeans.modules.dlight.indicators.TimeSeriesIndicatorConfiguration;
import org.netbeans.modules.dlight.indicators.impl.TimeSeriesDescriptorAccessor;
import org.netbeans.modules.dlight.indicators.support.DefaultDataRowToTimeSeries;
import org.netbeans.modules.dlight.util.ValueFormatter;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

public final class TimeSeriesIndicatorConfigurationFactory {
    private TimeSeriesIndicatorConfigurationFactory() {
    }

    static TimeSeriesIndicatorConfiguration createTimeSeriesIndicator(Map<?, ?> map) {
        IndicatorMetadata metadata = TimeSeriesIndicatorConfigurationFactory.getStringAndCreateInstance(map, "metadata", IndicatorMetadata.class);
        int position = TimeSeriesIndicatorConfigurationFactory.getInt(map, "position");
        TimeSeriesIndicatorConfiguration indicatorConfiguration = new TimeSeriesIndicatorConfiguration(metadata, position);
        if (TimeSeriesIndicatorConfigurationFactory.getString(map, "aggregation") != null) {
            Aggregation aggregation = Aggregation.valueOf(TimeSeriesIndicatorConfigurationFactory.getString(map, "aggregation"));
            indicatorConfiguration.setAggregation(aggregation);
        }
        if (map.get("granularity") != null) {
            indicatorConfiguration.setGranularity((Long)map.get("granularity"));
        }
        if (map.get("graph.scale") != null) {
            indicatorConfiguration.setGraphScale((Integer)map.get("graph.scale"));
        }
        if (map.get("title") != null) {
            indicatorConfiguration.setTitle(TimeSeriesIndicatorConfigurationFactory.getString(map, "title"));
        }
        if (map.get("label.formatter") != null && map.get("label.formatter") instanceof ValueFormatter) {
            indicatorConfiguration.setLabelFormatter((ValueFormatter)map.get("label.formatter"));
        }
        indicatorConfiguration.setLastNonNull(TimeSeriesIndicatorConfigurationFactory.getBoolean(map, "LastNonNull"));
        if (TimeSeriesIndicatorConfigurationFactory.getString(map, "action.displayName") != null) {
            indicatorConfiguration.setActionDisplayName(TimeSeriesIndicatorConfigurationFactory.getString(map, "action.displayName"));
        }
        if (TimeSeriesIndicatorConfigurationFactory.getString(map, "action.tooltip") != null) {
            indicatorConfiguration.setActionTooltip(TimeSeriesIndicatorConfigurationFactory.getString(map, "action.tooltip"));
        }
        List uncheckedDescriptors = TimeSeriesIndicatorConfigurationFactory.getStringAndCreateInstance(map, "timeSeriesDescriptors", List.class);
        indicatorConfiguration.addTimeSeriesDescriptors(uncheckedDescriptors.toArray(new TimeSeriesDescriptor[uncheckedDescriptors.size()]));
        DataRowToTimeSeries dataRowToTimeSeries = TimeSeriesIndicatorConfigurationFactory.getStringAndCreateInstance(map, "row.handler", DataRowToTimeSeries.class);
        if (dataRowToTimeSeries == null) {
            DataTableMetadata.Column[][] rowHandlerColumns = new DataTableMetadata.Column[uncheckedDescriptors.size()][];
            int descriptorCount = uncheckedDescriptors.size();
            for (int i = 0; i < descriptorCount; ++i) {
                Collection<DataTableMetadata.Column> descriptorColumns = TimeSeriesDescriptorAccessor.getDefault().getSourceColumns((TimeSeriesDescriptor)uncheckedDescriptors.get(i));
                rowHandlerColumns[i] = descriptorColumns.toArray(new DataTableMetadata.Column[descriptorColumns.size()]);
            }
            dataRowToTimeSeries = new DefaultDataRowToTimeSeries(rowHandlerColumns);
        }
        indicatorConfiguration.setDataRowHandler(dataRowToTimeSeries);
        VisualizerConfiguration visualizer = TimeSeriesIndicatorConfigurationFactory.getStringAndCreateInstance(map, "visualizer", VisualizerConfiguration.class);
        if (visualizer != null) {
            indicatorConfiguration.addVisualizerConfiguration(visualizer);
        }
        return indicatorConfiguration;
    }

    private static <T> T getStringAndCreateInstance(Map<?, ?> map, String key, Class<T> clazz) {
        return TimeSeriesIndicatorConfigurationFactory.createInstance(TimeSeriesIndicatorConfigurationFactory.getString(map, key), clazz);
    }

    static <T> T createInstance(String path, Class<T> clazz) {
        if (path != null) {
            FileObject fileObject = FileUtil.getConfigFile((String)path);
            return fileObject == null ? null : (T)TimeSeriesIndicatorConfigurationFactory.createInstance(fileObject, clazz);
        }
        return null;
    }

    static <T> T createInstance(FileObject instanceFileObject, Class<T> clazz) {
        if (instanceFileObject != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)instanceFileObject);
                InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
                if (instanceCookie != null) {
                    return clazz.cast(instanceCookie.instanceCreate());
                }
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ClassNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ClassCastException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    private static String getString(Map<?, ?> map, String key) {
        return (String)map.get(key);
    }

    private static boolean getBoolean(Map<?, ?> map, String key) {
        Object value = map.get(key);
        return value instanceof Boolean ? (Boolean)value : false;
    }

    private static int getInt(Map<?, ?> map, String key) {
        Object value = map.get(key);
        return value instanceof Integer ? (Integer)value : 0;
    }
}

