/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.embedder;

import java.lang.reflect.Field;
import java.util.List;
import java.util.logging.Logger;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.extension.DefaultExtensionManager;
import org.apache.maven.extension.ExtensionManagerException;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.netbeans.modules.maven.embedder.NbWagonManager;

public class NbExtensionManager
extends DefaultExtensionManager {
    protected Field wagonMan;
    private Logger LOG = Logger.getLogger(NbExtensionManager.class.getName());

    public NbExtensionManager() {
        try {
            this.wagonMan = DefaultExtensionManager.class.getDeclaredField("wagonManager");
            this.wagonMan.setAccessible(true);
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchFieldException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addExtension(Extension extension, Model originatingModel, List remoteRepositories, MavenExecutionRequest request) throws ExtensionManagerException {
        String key = extension.getGroupId() + ":" + extension.getArtifactId();
        this.openSesame(key);
        try {
            this.LOG.fine("add extension1=" + extension.getGroupId() + ":" + extension.getArtifactId() + ":" + extension.getVersion());
            super.addExtension(extension, originatingModel, remoteRepositories, request);
        }
        finally {
            this.LOG.fine("---------------------------------------------------------");
            this.closeSesame(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addExtension(Extension extension, MavenProject project, MavenExecutionRequest request) throws ExtensionManagerException {
        String key = extension.getGroupId() + ":" + extension.getArtifactId();
        this.openSesame(key);
        try {
            this.LOG.fine("add extension2=" + extension.getGroupId() + ":" + extension.getArtifactId() + ":" + extension.getVersion());
            super.addExtension(extension, project, request);
        }
        finally {
            this.LOG.fine("---------------------------------------------------------");
            this.closeSesame(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPluginAsExtension(Plugin plugin, Model originatingModel, List remoteRepositories, MavenExecutionRequest request) throws ExtensionManagerException {
        String key = plugin.getGroupId() + ":" + plugin.getArtifactId();
        this.openSesame(key);
        try {
            this.LOG.fine("add plugin as ext=" + plugin.getGroupId() + ":" + plugin.getArtifactId() + ":" + plugin.getVersion());
            super.addPluginAsExtension(plugin, originatingModel, remoteRepositories, request);
        }
        finally {
            this.LOG.fine("---------------------------------------------------------");
            this.closeSesame(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerWagons() {
        try {
            this.LOG.fine("register wagons...");
            super.registerWagons();
        }
        finally {
            this.LOG.fine("---------------------------------------------------------");
        }
    }

    private void closeSesame(String str) {
        if (this.wagonMan != null) {
            try {
                Object manObj = this.wagonMan.get(this);
                if (manObj instanceof NbWagonManager) {
                    NbWagonManager manager = (NbWagonManager)manObj;
                    manager.cleanLetGone(str);
                }
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void openSesame(String str) {
        if (this.wagonMan != null) {
            try {
                Object manObj = this.wagonMan.get(this);
                if (manObj instanceof NbWagonManager) {
                    NbWagonManager manager = (NbWagonManager)manObj;
                    manager.letGoThrough(str);
                }
            }
            catch (IllegalArgumentException ex) {
                ex.printStackTrace();
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }
    }
}

