/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints.introduce;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.hints.introduce.ErrorLabel;
import org.netbeans.modules.ruby.hints.introduce.IntroduceVariablePanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class IntroduceMethodPanel
extends JPanel {
    private JButton btnOk;
    private Set<String> takenNames;
    private ButtonGroup accessGroup;
    private JLabel errorLabel;
    private ButtonGroup initilizeIn;
    private JLabel lblName;
    private JTextField name;
    private String methodNameTest;

    public IntroduceMethodPanel(String name, Set<String> takenNames) {
        this.takenNames = takenNames;
        this.initComponents();
        this.name.setText(name);
        if (name != null && name.trim().length() > 0) {
            this.name.setCaretPosition(name.length());
            this.name.setSelectionStart(0);
            this.name.setSelectionEnd(name.length());
        }
    }

    public void setOkButton(JButton btn) {
        this.btnOk = btn;
        this.btnOk.setEnabled(((ErrorLabel)this.errorLabel).isInputTextValid());
    }

    private JLabel createErrorLabel() {
        ErrorLabel.Validator validator = new ErrorLabel.Validator(){

            @Override
            public String validate(String text) {
                if (null == text || text.length() == 0) {
                    return "";
                }
                if (!RubyUtils.isValidRubyMethodName((String)text)) {
                    return IntroduceMethodPanel.this.getDefaultErrorMessage(text);
                }
                if (IntroduceMethodPanel.this.takenNames.contains(text)) {
                    return NbBundle.getMessage(IntroduceVariablePanel.class, (String)"MethodAlreadyExists", (Object)text);
                }
                return null;
            }
        };
        final ErrorLabel eLabel = new ErrorLabel(this.name.getDocument(), validator);
        eLabel.addPropertyChangeListener("isValid", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                IntroduceMethodPanel.this.btnOk.setEnabled(eLabel.isInputTextValid());
            }
        });
        return eLabel;
    }

    String getDefaultErrorMessage(String inputText) {
        return NbBundle.getMessage(IntroduceMethodPanel.class, (String)"NotValidIdentifier", (Object)inputText);
    }

    private void initComponents() {
        this.initilizeIn = new ButtonGroup();
        this.accessGroup = new ButtonGroup();
        this.lblName = new JLabel();
        this.name = new JTextField();
        this.errorLabel = this.createErrorLabel();
        this.lblName.setLabelFor(this.name);
        Mnemonics.setLocalizedText((JLabel)this.lblName, (String)NbBundle.getBundle(IntroduceMethodPanel.class).getString("LBL_Name"));
        this.name.setColumns(20);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.lblName).add(29, 29, 29).add((Component)this.name, -1, 425, Short.MAX_VALUE)).add((Component)this.errorLabel, -1, 494, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.name, -2, -1, -2).add((Component)this.lblName)).addPreferredGap(0, 61, Short.MAX_VALUE).add((Component)this.errorLabel).addContainerGap()));
        this.name.getAccessibleContext().setAccessibleName(NbBundle.getMessage(IntroduceMethodPanel.class, (String)"AN_IntrMethod_Name"));
        this.name.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceMethodPanel.class, (String)"AD_IntrMethod_Name"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IntroduceMethodPanel.class, (String)"AD_IntrMethod_Dialog"));
    }

    public String getMethodName() {
        if (this.methodNameTest != null) {
            return this.methodNameTest;
        }
        return this.name.getText();
    }

    void setMethodName(String methodName) {
        this.methodNameTest = methodName;
    }
}

